/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.content.storage.fs;

import java.io.File;
import java.math.BigInteger;
import org.activiti.content.storage.exception.ContentStorageException;

public class PathConverter {
    public BigInteger blockSize = BigInteger.valueOf(1024L);
    public int iterationDepth = 4;
    public int blockSizeInt = 1024;

    public File getPathForId(BigInteger id) {
        BigInteger remainder = null;
        if (id.compareTo(BigInteger.ZERO) < 0) {
            throw new ContentStorageException("ID cannot be negative");
        }
        Long[] blocks = new Long[this.iterationDepth];
        for (int i = 0; i < this.iterationDepth; ++i) {
            remainder = id.remainder(this.blockSize);
            blocks[i] = remainder.longValue();
            id = id.subtract(remainder).divide(this.blockSize);
        }
        if (!id.equals(BigInteger.ZERO)) {
            throw new ContentStorageException("ID out of range of content storage limit: " + this.blockSize.pow(this.iterationDepth).subtract(BigInteger.ONE));
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = this.iterationDepth - 1; i >= 0; --i) {
            buffer.append(blocks[i].toString()).append(File.separatorChar);
        }
        return new File(buffer.toString());
    }

    public BigInteger getIdForPath(File path) {
        BigInteger result = BigInteger.ZERO;
        BigInteger currentFactor = BigInteger.ONE;
        int depth = 0;
        File parent = path;
        while (parent != null && depth < this.iterationDepth) {
            try {
                result = result.add(new BigInteger(parent.getName()).multiply(currentFactor));
                parent = parent.getParentFile();
                ++depth;
                currentFactor = currentFactor.multiply(this.blockSize);
            }
            catch (NumberFormatException nfe) {
                throw new ContentStorageException("Illegal format of path segment: " + parent.getName(), (Throwable)nfe);
            }
        }
        return result;
    }

    public void setBlockSize(int blockSize) {
        this.blockSizeInt = blockSize;
        this.blockSize = BigInteger.valueOf(blockSize);
    }

    public int getBlockSize() {
        return this.blockSizeInt;
    }

    public void setIterationDepth(int iterationDepth) {
        this.iterationDepth = iterationDepth;
    }

    public int getIterationDepth() {
        return this.iterationDepth;
    }
}

