/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.variable;

import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class ShortType
implements VariableType {
    private static final long serialVersionUID = 1L;

    public String getTypeName() {
        return "short";
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        if (valueFields.getLongValue() != null) {
            return new Short(valueFields.getLongValue().shortValue());
        }
        return null;
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setLongValue(Long.valueOf(((Short)value).longValue()));
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setLongValue(null);
            valueFields.setTextValue(null);
        }
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Short.class.isAssignableFrom(value.getClass()) || Short.TYPE.isAssignableFrom(value.getClass());
    }
}

