/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.util.io;

import java.io.BufferedInputStream;
import java.io.InputStream;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.impl.util.ReflectUtil;
import org.activiti5.engine.impl.util.io.StreamSource;

public class ResourceStreamSource
implements StreamSource {
    String resource;
    ClassLoader classLoader;

    public ResourceStreamSource(String resource) {
        this.resource = resource;
    }

    public ResourceStreamSource(String resource, ClassLoader classLoader) {
        this.resource = resource;
        this.classLoader = classLoader;
    }

    @Override
    public InputStream getInputStream() {
        InputStream inputStream = null;
        inputStream = this.classLoader == null ? ReflectUtil.getResourceAsStream(this.resource) : this.classLoader.getResourceAsStream(this.resource);
        if (inputStream == null) {
            throw new ActivitiIllegalArgumentException("resource '" + this.resource + "' doesn't exist");
        }
        return new BufferedInputStream(inputStream);
    }

    public String toString() {
        return "Resource[" + this.resource + "]";
    }
}

