/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.pvm.runtime;

import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.impl.delegate.ActivityBehavior;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti5.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;
import org.activiti5.engine.impl.pvm.process.ScopeImpl;
import org.activiti5.engine.impl.pvm.runtime.AbstractEventAtomicOperation;
import org.activiti5.engine.impl.pvm.runtime.InterpretableExecution;

public class AtomicOperationActivityEnd
extends AbstractEventAtomicOperation {
    @Override
    protected ScopeImpl getScope(InterpretableExecution execution) {
        return (ScopeImpl)((Object)execution.getActivity());
    }

    @Override
    protected String getEventName() {
        return "end";
    }

    @Override
    protected void eventNotificationsCompleted(InterpretableExecution execution) {
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        ActivityImpl parentActivity = activity.getParentActivity();
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && execution instanceof ExecutionEntity) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_COMPLETED, execution.getActivity().getId(), (String)executionEntity.getActivity().getProperties().get("name"), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), (String)executionEntity.getActivity().getProperties().get("type"), executionEntity.getActivity().getActivityBehavior().getClass().getCanonicalName()));
        }
        if (parentActivity != null && !parentActivity.isScope()) {
            execution.setActivity(parentActivity);
            execution.performOperation(ACTIVITY_END);
        } else if (execution.isProcessInstanceType()) {
            if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.PROCESS_COMPLETED, execution));
            }
            execution.performOperation(PROCESS_END);
        } else if (execution.isScope()) {
            ActivityBehavior parentActivityBehavior;
            ActivityBehavior activityBehavior = parentActivityBehavior = parentActivity != null ? parentActivity.getActivityBehavior() : null;
            if (parentActivityBehavior instanceof CompositeActivityBehavior) {
                CompositeActivityBehavior compositeActivityBehavior = (CompositeActivityBehavior)parentActivity.getActivityBehavior();
                if (activity.isScope() && activity.getOutgoingTransitions().isEmpty()) {
                    InterpretableExecution parentScopeExecution = (InterpretableExecution)execution.getParent();
                    execution.destroy();
                    execution.remove();
                    parentScopeExecution.setActivity(parentActivity);
                    compositeActivityBehavior.lastExecutionEnded(parentScopeExecution);
                } else {
                    execution.setActivity(parentActivity);
                    compositeActivityBehavior.lastExecutionEnded(execution);
                }
            } else {
                InterpretableExecution parentScopeExecution = (InterpretableExecution)execution.getParent();
                execution.destroy();
                execution.remove();
                if (activity.getParent() == activity.getProcessDefinition()) {
                    parentScopeExecution.setActivity(activity);
                    if (activity.getOutgoingTransitions().isEmpty()) {
                        parentScopeExecution.end();
                    } else {
                        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.PROCESS_COMPLETED, execution));
                        }
                        parentScopeExecution.performOperation(PROCESS_END);
                    }
                } else {
                    parentScopeExecution.setActivity(parentActivity);
                    parentScopeExecution.performOperation(ACTIVITY_END);
                }
            }
        } else {
            execution.remove();
            InterpretableExecution concurrentRoot = (InterpretableExecution)execution.getParent();
            if (concurrentRoot.getExecutions().size() == 1) {
                InterpretableExecution lastConcurrent = (InterpretableExecution)concurrentRoot.getExecutions().get(0);
                if (!lastConcurrent.isScope()) {
                    concurrentRoot.setActivity((ActivityImpl)lastConcurrent.getActivity());
                    lastConcurrent.setReplacedBy(concurrentRoot);
                    if (!lastConcurrent.getExecutions().isEmpty()) {
                        concurrentRoot.getExecutions().clear();
                        for (ActivityExecution activityExecution : lastConcurrent.getExecutions()) {
                            InterpretableExecution childInterpretableExecution = (InterpretableExecution)activityExecution;
                            concurrentRoot.getExecutions().add(activityExecution);
                            childInterpretableExecution.setParent(concurrentRoot);
                        }
                        lastConcurrent.getExecutions().clear();
                    }
                    concurrentRoot.setVariablesLocal(lastConcurrent.getVariablesLocal());
                    if (!concurrentRoot.isActive() && lastConcurrent.isActive()) {
                        concurrentRoot.setActive(true);
                    }
                    lastConcurrent.remove();
                } else {
                    lastConcurrent.setConcurrent(false);
                }
            }
        }
    }

    protected boolean isExecutionAloneInParent(InterpretableExecution execution) {
        ScopeImpl parentScope = (ScopeImpl)execution.getActivity().getParent();
        for (InterpretableExecution interpretableExecution : execution.getParent().getExecutions()) {
            if (interpretableExecution == execution || !parentScope.contains((ActivityImpl)interpretableExecution.getActivity())) continue;
            return false;
        }
        return true;
    }
}

