/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.pvm.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.bpmn.data.IOSpecification;
import org.activiti5.engine.impl.pvm.PvmException;
import org.activiti5.engine.impl.pvm.PvmScope;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;
import org.activiti5.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti5.engine.impl.pvm.process.ProcessElementImpl;

public abstract class ScopeImpl
extends ProcessElementImpl
implements PvmScope {
    private static final long serialVersionUID = 1L;
    protected List<ActivityImpl> activities = new ArrayList<ActivityImpl>();
    protected Map<String, ActivityImpl> namedActivities = new HashMap<String, ActivityImpl>();
    protected Map<String, List<ExecutionListener>> executionListeners = new HashMap<String, List<ExecutionListener>>();
    protected IOSpecification ioSpecification;

    public ScopeImpl(String id, ProcessDefinitionImpl processDefinition) {
        super(id, processDefinition);
    }

    @Override
    public ActivityImpl findActivity(String activityId) {
        ActivityImpl localActivity = this.namedActivities.get(activityId);
        if (localActivity != null) {
            return localActivity;
        }
        for (ActivityImpl activity : this.activities) {
            ActivityImpl nestedActivity = activity.findActivity(activityId);
            if (nestedActivity == null) continue;
            return nestedActivity;
        }
        return null;
    }

    public ActivityImpl createActivity() {
        return this.createActivity(null);
    }

    public ActivityImpl createActivity(String activityId) {
        ActivityImpl activity = new ActivityImpl(activityId, this.processDefinition);
        if (activityId != null) {
            if (this.processDefinition.findActivity(activityId) != null) {
                throw new PvmException("duplicate activity id '" + activityId + "'");
            }
            this.namedActivities.put(activityId, activity);
        }
        activity.setParent(this);
        this.activities.add(activity);
        return activity;
    }

    public boolean contains(ActivityImpl activity) {
        if (this.namedActivities.containsKey(activity.getId())) {
            return true;
        }
        for (ActivityImpl nestedActivity : this.activities) {
            if (!nestedActivity.contains(activity)) continue;
            return true;
        }
        return false;
    }

    public List<ExecutionListener> getExecutionListeners(String eventName) {
        List<ExecutionListener> executionListenerList = this.getExecutionListeners().get(eventName);
        if (executionListenerList != null) {
            return executionListenerList;
        }
        return Collections.EMPTY_LIST;
    }

    public void addExecutionListener(String eventName, ExecutionListener executionListener) {
        this.addExecutionListener(eventName, executionListener, -1);
    }

    public void addExecutionListener(String eventName, ExecutionListener executionListener, int index) {
        List<ExecutionListener> listeners = this.executionListeners.get(eventName);
        if (listeners == null) {
            listeners = new ArrayList<ExecutionListener>();
            this.executionListeners.put(eventName, listeners);
        }
        if (index < 0) {
            listeners.add(executionListener);
        } else {
            listeners.add(index, executionListener);
        }
    }

    public Map<String, List<ExecutionListener>> getExecutionListeners() {
        return this.executionListeners;
    }

    public List<ActivityImpl> getActivities() {
        return this.activities;
    }

    public IOSpecification getIoSpecification() {
        return this.ioSpecification;
    }

    public void setIoSpecification(IOSpecification ioSpecification) {
        this.ioSpecification = ioSpecification;
    }
}

