/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import org.activiti.engine.impl.persistence.entity.AbstractEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.db.BulkDeleteable;
import org.activiti5.engine.impl.db.HasRevision;
import org.activiti5.engine.impl.db.PersistentObject;
import org.activiti5.engine.impl.persistence.entity.ByteArrayRef;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.apache.commons.lang3.StringUtils;

public class VariableInstanceEntity
extends AbstractEntity
implements VariableInstance,
ValueFields,
PersistentObject,
HasRevision,
BulkDeleteable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String localizedName;
    protected String localizedDescription;
    protected VariableType type;
    protected String typeName;
    protected String processInstanceId;
    protected String executionId;
    protected String taskId;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected final ByteArrayRef byteArrayRef = new ByteArrayRef();
    protected Object cachedValue;
    protected boolean forcedUpdate;
    protected boolean deleted = false;

    protected VariableInstanceEntity() {
    }

    public static VariableInstanceEntity createAndInsert(String name, VariableType type, Object value) {
        VariableInstanceEntity variableInstance = VariableInstanceEntity.create(name, type, value);
        variableInstance.setRevision(0);
        Context.getCommandContext().getDbSqlSession().insert(variableInstance);
        return variableInstance;
    }

    public static VariableInstanceEntity create(String name, VariableType type, Object value) {
        VariableInstanceEntity variableInstance = new VariableInstanceEntity();
        variableInstance.name = name;
        variableInstance.type = type;
        variableInstance.typeName = type.getTypeName();
        variableInstance.setValue(value);
        return variableInstance;
    }

    public void setExecution(ExecutionEntity execution) {
        this.executionId = execution.getId();
        this.processInstanceId = execution.getProcessInstanceId();
        this.forceUpdate();
    }

    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    public void delete() {
        Context.getCommandContext().getDbSqlSession().delete(this);
        this.byteArrayRef.delete();
        this.deleted = true;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        if (this.longValue != null) {
            persistentState.put("longValue", this.longValue);
        }
        if (this.doubleValue != null) {
            persistentState.put("doubleValue", this.doubleValue);
        }
        if (this.textValue != null) {
            persistentState.put("textValue", this.textValue);
        }
        if (this.textValue2 != null) {
            persistentState.put("textValue2", this.textValue2);
        }
        if (this.byteArrayRef.getId() != null) {
            persistentState.put("byteArrayValueId", this.byteArrayRef.getId());
        }
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        return persistentState;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public byte[] getBytes() {
        return this.byteArrayRef.getBytes();
    }

    public void setBytes(byte[] bytes) {
        this.byteArrayRef.setValue("var-" + this.name, bytes);
    }

    public Object getValue() {
        if (!this.type.isCachable() || this.cachedValue == null) {
            this.cachedValue = this.type.getValue((ValueFields)this);
        }
        return this.cachedValue;
    }

    public void setValue(Object value) {
        this.type.setValue(value, (ValueFields)this);
        this.typeName = this.type.getTypeName();
        this.cachedValue = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    public String getLocalizedDescription() {
        return this.localizedDescription;
    }

    public void setLocalizedDescription(String localizedDescription) {
        this.localizedDescription = localizedDescription;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public VariableType getType() {
        return this.type;
    }

    public void setType(VariableType type) {
        this.type = type;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public String getTextValue2() {
        return this.textValue2;
    }

    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    public Object getCachedValue() {
        return this.cachedValue;
    }

    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VariableInstanceEntity[");
        sb.append("id=").append(this.id);
        sb.append(", name=").append(this.name);
        sb.append(", type=").append(this.type != null ? this.type.getTypeName() : "null");
        if (this.longValue != null) {
            sb.append(", longValue=").append(this.longValue);
        }
        if (this.doubleValue != null) {
            sb.append(", doubleValue=").append(this.doubleValue);
        }
        if (this.textValue != null) {
            sb.append(", textValue=").append(StringUtils.abbreviate((String)this.textValue, (int)40));
        }
        if (this.textValue2 != null) {
            sb.append(", textValue2=").append(StringUtils.abbreviate((String)this.textValue2, (int)40));
        }
        if (this.byteArrayRef.getId() != null) {
            sb.append(", byteArrayValueId=").append(this.byteArrayRef.getId());
        }
        sb.append("]");
        return sb.toString();
    }
}

