/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.persistence.entity;

import java.util.Date;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.jobexecutor.JobHandler;
import org.activiti5.engine.impl.persistence.entity.AbstractJobEntity;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.persistence.entity.TimerJobEntity;

public class JobEntity
extends AbstractJobEntity {
    private static final long serialVersionUID = 1L;
    protected String lockOwner = null;
    protected Date lockExpirationTime = null;

    public JobEntity() {
    }

    public JobEntity(AbstractJobEntity te) {
        this.id = te.getId();
        this.jobType = te.getJobType();
        this.revision = te.getRevision();
        this.jobHandlerConfiguration = te.getJobHandlerConfiguration();
        this.jobHandlerType = te.getJobHandlerType();
        this.isExclusive = te.isExclusive();
        this.repeat = te.getRepeat();
        this.retries = te.getRetries();
        this.endDate = te.getEndDate();
        this.executionId = te.getExecutionId();
        this.processInstanceId = te.getProcessInstanceId();
        this.processDefinitionId = te.getProcessDefinitionId();
        this.exceptionMessage = te.getExceptionMessage();
        this.setExceptionStacktrace(te.getExceptionStacktrace());
        this.tenantId = te.getTenantId();
    }

    public void execute(CommandContext commandContext) {
        ExecutionEntity execution = null;
        if (this.executionId != null) {
            execution = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
        }
        Map<String, JobHandler> jobHandlers = Context.getProcessEngineConfiguration().getJobHandlers();
        JobHandler jobHandler = jobHandlers.get(this.jobHandlerType);
        jobHandler.execute(this, this.jobHandlerConfiguration, execution, commandContext);
        this.delete();
        if (this.repeat != null) {
            TimerJobEntity timerRepeatJob = new TimerJobEntity(this);
            timerRepeatJob.scheduleNewTimer(commandContext);
        }
    }

    public void insert() {
        Context.getCommandContext().getDbSqlSession().insert(this);
        if (this.executionId != null) {
            ExecutionEntity execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.executionId);
            execution.addJob(this);
            if (execution.getTenantId() != null) {
                this.setTenantId(execution.getTenantId());
            }
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, this));
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, this));
        }
    }

    public void delete() {
        Context.getCommandContext().getDbSqlSession().delete(this);
        this.exceptionByteArrayRef.delete();
        if (this.executionId != null) {
            ExecutionEntity execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.executionId);
            execution.removeJob(this);
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, this));
        }
    }

    @Override
    public void setExecution(ExecutionEntity execution) {
        super.setExecution(execution);
        execution.addJob(this);
    }

    @Override
    public Object getPersistentState() {
        Map persistentState = (Map)super.getPersistentState();
        persistentState.put("lockOwner", this.lockOwner);
        persistentState.put("lockExpirationTime", this.lockExpirationTime);
        return persistentState;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    public Date getLockExpirationTime() {
        return this.lockExpirationTime;
    }

    public void setLockExpirationTime(Date lockExpirationTime) {
        this.lockExpirationTime = lockExpirationTime;
    }

    public String toString() {
        return "JobEntity [id=" + this.id + "]";
    }
}

