/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.persistence.AbstractManager;
import org.activiti5.engine.impl.persistence.entity.HistoricIdentityLinkEntity;

public class HistoricIdentityLinkEntityManager
extends AbstractManager {
    public void deleteHistoricIdentityLink(HistoricIdentityLinkEntity identityLink) {
        this.getDbSqlSession().delete(identityLink);
    }

    public void deleteHistoricIdentityLink(String id) {
        this.getDbSqlSession().delete("deleteHistoricIdentityLink", id);
    }

    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinksByTaskId(String taskId) {
        return this.getDbSqlSession().selectList("selectHistoricIdentityLinksByTask", taskId);
    }

    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinksByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectHistoricIdentityLinksByProcessInstance", processInstanceId);
    }

    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinksByProcessDefinitionId(String processDefinitionId) {
        return this.getDbSqlSession().selectList("selectHistoricIdentityLinksByProcessDefinition", processDefinitionId);
    }

    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinks() {
        return this.getDbSqlSession().selectList("selectHistoricIdentityLinks");
    }

    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinkByTaskUserGroupAndType(String taskId, String userId, String groupId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("taskId", taskId);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        parameters.put("type", type);
        return this.getDbSqlSession().selectList("selectHistoricIdentityLinkByTaskUserGroupAndType", parameters);
    }

    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinkByProcessDefinitionUserAndGroup(String processDefinitionId, String userId, String groupId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        return this.getDbSqlSession().selectList("selectHistoricIdentityLinkByProcessDefinitionUserAndGroup", parameters);
    }

    public void deleteHistoricIdentityLinksByTaskId(String taskId) {
        List<HistoricIdentityLinkEntity> identityLinks = this.findHistoricIdentityLinksByTaskId(taskId);
        for (HistoricIdentityLinkEntity identityLink : identityLinks) {
            this.deleteHistoricIdentityLink(identityLink);
        }
    }

    public void deleteHistoricIdentityLinksByProcInstance(String processInstanceId) {
        List<HistoricIdentityLinkEntity> identityLinks = this.findHistoricIdentityLinksByProcessInstanceId(processInstanceId);
        for (HistoricIdentityLinkEntity identityLink : identityLinks) {
            this.deleteHistoricIdentityLink(identityLink);
        }
        List<HistoricIdentityLinkEntity> identityLinksFromCache = Context.getCommandContext().getDbSqlSession().findInCache(HistoricIdentityLinkEntity.class);
        for (HistoricIdentityLinkEntity identityLinkEntity : identityLinksFromCache) {
            if (!processInstanceId.equals(identityLinkEntity.getProcessInstanceId())) continue;
            this.deleteHistoricIdentityLink(identityLinkEntity);
        }
    }

    public void deleteHistoricIdentityLinksByProcDef(String processDefId) {
        this.getDbSqlSession().delete("deleteHistoricIdentityLinkByProcDef", processDefId);
    }
}

