/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.ActivitiOptimisticLockingException;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.ExecutionQueryImpl;
import org.activiti5.engine.impl.Page;
import org.activiti5.engine.impl.ProcessInstanceQueryImpl;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.AbstractManager;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.runtime.Execution;
import org.activiti5.engine.runtime.ProcessInstance;

public class ExecutionEntityManager
extends AbstractManager {
    public void deleteProcessInstancesByProcessDefinition(String processDefinitionId, String deleteReason, boolean cascade) {
        List processInstanceIds = this.getDbSqlSession().selectList("selectProcessInstanceIdsByProcessDefinitionId", processDefinitionId);
        for (String processInstanceId : processInstanceIds) {
            this.deleteProcessInstance(processInstanceId, deleteReason, cascade);
        }
        if (cascade) {
            Context.getCommandContext().getHistoricProcessInstanceEntityManager().deleteHistoricProcessInstanceByProcessDefinitionId(processDefinitionId);
        }
    }

    public void deleteProcessInstance(String processInstanceId, String deleteReason) {
        this.deleteProcessInstance(processInstanceId, deleteReason, false);
    }

    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean cascade) {
        ExecutionEntity execution = this.findExecutionById(processInstanceId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("No process instance found for id '" + processInstanceId + "'", ProcessInstance.class);
        }
        this.deleteProcessInstanceCascade(execution, deleteReason, cascade);
    }

    private void deleteProcessInstanceCascade(ExecutionEntity execution, String deleteReason, boolean deleteHistory) {
        CommandContext commandContext = Context.getCommandContext();
        ProcessInstanceQueryImpl processInstanceQuery = new ProcessInstanceQueryImpl(commandContext);
        List subProcesses = processInstanceQuery.superProcessInstanceId(execution.getProcessInstanceId()).list();
        for (ProcessInstance subProcess : subProcesses) {
            this.deleteProcessInstanceCascade((ExecutionEntity)subProcess, deleteReason, deleteHistory);
        }
        commandContext.getTaskEntityManager().deleteTasksByProcessInstanceId(execution.getId(), deleteReason, deleteHistory);
        if (deleteReason == null) {
            deleteReason = "ACTIVITY_DELETED";
        }
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createCancelledEvent(execution.getProcessInstanceId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), deleteReason));
        }
        execution.deleteCascade(deleteReason);
        if (deleteHistory) {
            commandContext.getHistoricProcessInstanceEntityManager().deleteHistoricProcessInstanceById(execution.getId());
        }
    }

    public ExecutionEntity findSubProcessInstanceBySuperExecutionId(String superExecutionId) {
        return (ExecutionEntity)this.getDbSqlSession().selectOne("selectSubProcessInstanceBySuperExecutionId", superExecutionId);
    }

    public List<ExecutionEntity> findChildExecutionsByParentExecutionId(String parentExecutionId) {
        return this.getDbSqlSession().selectList("selectExecutionsByParentExecutionId", parentExecutionId);
    }

    public List<ExecutionEntity> findChildExecutionsByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectExecutionsByProcessInstanceId", processInstanceId);
    }

    public ExecutionEntity findExecutionById(String executionId) {
        return this.getDbSqlSession().selectById(ExecutionEntity.class, executionId);
    }

    public long findExecutionCountByQueryCriteria(ExecutionQueryImpl executionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectExecutionCountByQueryCriteria", executionQuery);
    }

    public List<ExecutionEntity> findExecutionsByQueryCriteria(ExecutionQueryImpl executionQuery, Page page) {
        return this.getDbSqlSession().selectList("selectExecutionsByQueryCriteria", executionQuery, page);
    }

    public long findProcessInstanceCountByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectProcessInstanceCountByQueryCriteria", executionQuery);
    }

    public List<ProcessInstance> findProcessInstanceByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return this.getDbSqlSession().selectList("selectProcessInstanceByQueryCriteria", executionQuery);
    }

    public List<ProcessInstance> findProcessInstanceAndVariablesByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        if (executionQuery.getFirstResult() < 0 || executionQuery.getMaxResults() <= 0) {
            return Collections.EMPTY_LIST;
        }
        int firstResult = executionQuery.getFirstResult();
        int maxResults = executionQuery.getMaxResults();
        if (executionQuery.getProcessInstanceVariablesLimit() != null) {
            executionQuery.setMaxResults(executionQuery.getProcessInstanceVariablesLimit());
        } else {
            executionQuery.setMaxResults(Context.getProcessEngineConfiguration().getExecutionQueryLimit());
        }
        executionQuery.setFirstResult(0);
        List instanceList = this.getDbSqlSession().selectListWithRawParameterWithoutFilter("selectProcessInstanceWithVariablesByQueryCriteria", executionQuery, executionQuery.getFirstResult(), executionQuery.getMaxResults());
        if (instanceList != null && !instanceList.isEmpty()) {
            if (firstResult > 0) {
                if (firstResult <= instanceList.size()) {
                    int toIndex = firstResult + Math.min(maxResults, instanceList.size() - firstResult);
                    return instanceList.subList(firstResult, toIndex);
                }
                return Collections.EMPTY_LIST;
            }
            int toIndex = Math.min(maxResults, instanceList.size());
            return instanceList.subList(0, toIndex);
        }
        return Collections.EMPTY_LIST;
    }

    public List<ExecutionEntity> findEventScopeExecutionsByActivityId(String activityRef, String parentExecutionId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("activityId", activityRef);
        parameters.put("parentExecutionId", parentExecutionId);
        return this.getDbSqlSession().selectList("selectExecutionsByParentExecutionId", parameters);
    }

    public List<Execution> findExecutionsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public List<ProcessInstance> findProcessInstanceByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findExecutionCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectExecutionCountByNativeQuery", parameterMap);
    }

    public void updateExecutionTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateExecutionTenantIdForDeployment", params);
    }

    public void updateProcessInstanceLockTime(String processInstanceId) {
        CommandContext commandContext = Context.getCommandContext();
        Date expirationTime = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        int lockMillis = commandContext.getProcessEngineConfiguration().getAsyncExecutorAsyncJobLockTimeInMillis();
        GregorianCalendar lockCal = new GregorianCalendar();
        lockCal.setTime(expirationTime);
        lockCal.add(14, lockMillis);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", processInstanceId);
        params.put("lockTime", lockCal.getTime());
        params.put("expirationTime", expirationTime);
        int result = this.getDbSqlSession().update("updateProcessInstanceLockTime", params);
        if (result == 0) {
            throw new ActivitiOptimisticLockingException("Could not lock process instance");
        }
    }

    public void clearProcessInstanceLockTime(String processInstanceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", processInstanceId);
        this.getDbSqlSession().update("clearProcessInstanceLockTime", params);
    }
}

