/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.juel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.EnumSet;
import java.util.Properties;
import org.activiti5.engine.impl.javax.el.ELContext;
import org.activiti5.engine.impl.javax.el.ELException;
import org.activiti5.engine.impl.javax.el.ExpressionFactory;
import org.activiti5.engine.impl.juel.Builder;
import org.activiti5.engine.impl.juel.Cache;
import org.activiti5.engine.impl.juel.ObjectValueExpression;
import org.activiti5.engine.impl.juel.TreeBuilder;
import org.activiti5.engine.impl.juel.TreeMethodExpression;
import org.activiti5.engine.impl.juel.TreeStore;
import org.activiti5.engine.impl.juel.TreeValueExpression;
import org.activiti5.engine.impl.juel.TypeConverter;

public class ExpressionFactoryImpl
extends ExpressionFactory {
    public static final String PROP_METHOD_INVOCATIONS = "javax.el.methodInvocations";
    public static final String PROP_VAR_ARGS = "javax.el.varArgs";
    public static final String PROP_NULL_PROPERTIES = "javax.el.nullProperties";
    public static final String PROP_CACHE_SIZE = "javax.el.cacheSize";
    private final TreeStore store;
    private final TypeConverter converter;

    public ExpressionFactoryImpl() {
        this(Profile.JEE6);
    }

    public ExpressionFactoryImpl(Profile profile) {
        Properties properties = this.loadProperties("el.properties");
        this.store = this.createTreeStore(1000, profile, properties);
        this.converter = this.createTypeConverter(properties);
    }

    public ExpressionFactoryImpl(Properties properties) {
        this(Profile.JEE6, properties);
    }

    public ExpressionFactoryImpl(Profile profile, Properties properties) {
        this.store = this.createTreeStore(1000, profile, properties);
        this.converter = this.createTypeConverter(properties);
    }

    public ExpressionFactoryImpl(Properties properties, TypeConverter converter) {
        this(Profile.JEE6, properties, converter);
    }

    public ExpressionFactoryImpl(Profile profile, Properties properties, TypeConverter converter) {
        this.store = this.createTreeStore(1000, profile, properties);
        this.converter = converter;
    }

    public ExpressionFactoryImpl(TreeStore store) {
        this(store, TypeConverter.DEFAULT);
    }

    public ExpressionFactoryImpl(TreeStore store, TypeConverter converter) {
        this.store = store;
        this.converter = converter;
    }

    private Properties loadDefaultProperties() {
        String home = System.getProperty("java.home");
        String path = home + File.separator + "lib" + File.separator + "el.properties";
        File file = new File(path);
        if (file.exists()) {
            Properties properties = new Properties();
            InputStream input = null;
            try {
                input = new FileInputStream(file);
                properties.load(input);
            }
            catch (IOException e) {
                throw new ELException("Cannot read default EL properties", e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
            if (this.getClass().getName().equals(properties.getProperty("javax.el.ExpressionFactory"))) {
                return properties;
            }
        }
        if (this.getClass().getName().equals(System.getProperty("javax.el.ExpressionFactory"))) {
            return System.getProperties();
        }
        return null;
    }

    private Properties loadProperties(String path) {
        Properties properties = new Properties(this.loadDefaultProperties());
        InputStream input = null;
        try {
            input = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        }
        catch (SecurityException e) {
            input = ClassLoader.getSystemResourceAsStream(path);
        }
        if (input != null) {
            try {
                properties.load(input);
            }
            catch (IOException e) {
                throw new ELException("Cannot read EL properties", e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    private boolean getFeatureProperty(Profile profile, Properties properties, Builder.Feature feature, String property) {
        return Boolean.valueOf(properties.getProperty(property, String.valueOf(profile.contains(feature))));
    }

    protected TreeStore createTreeStore(int defaultCacheSize, Profile profile, Properties properties) {
        TreeBuilder builder = null;
        if (properties == null) {
            builder = this.createTreeBuilder(null, profile.features());
        } else {
            EnumSet<Builder.Feature> features = EnumSet.noneOf(Builder.Feature.class);
            if (this.getFeatureProperty(profile, properties, Builder.Feature.METHOD_INVOCATIONS, PROP_METHOD_INVOCATIONS)) {
                features.add(Builder.Feature.METHOD_INVOCATIONS);
            }
            if (this.getFeatureProperty(profile, properties, Builder.Feature.VARARGS, PROP_VAR_ARGS)) {
                features.add(Builder.Feature.VARARGS);
            }
            if (this.getFeatureProperty(profile, properties, Builder.Feature.NULL_PROPERTIES, PROP_NULL_PROPERTIES)) {
                features.add(Builder.Feature.NULL_PROPERTIES);
            }
            builder = this.createTreeBuilder(properties, features.toArray(new Builder.Feature[0]));
        }
        int cacheSize = defaultCacheSize;
        if (properties != null && properties.containsKey(PROP_CACHE_SIZE)) {
            try {
                cacheSize = Integer.parseInt(properties.getProperty(PROP_CACHE_SIZE));
            }
            catch (NumberFormatException e) {
                throw new ELException("Cannot parse EL property javax.el.cacheSize", e);
            }
        }
        Cache cache = cacheSize > 0 ? new Cache(cacheSize) : null;
        return new TreeStore(builder, cache);
    }

    protected TypeConverter createTypeConverter(Properties properties) {
        Class<?> clazz = this.load(TypeConverter.class, properties);
        if (clazz == null) {
            return TypeConverter.DEFAULT;
        }
        try {
            return (TypeConverter)TypeConverter.class.cast(clazz.newInstance());
        }
        catch (Exception e) {
            throw new ELException("TypeConverter " + clazz + " could not be instantiated", e);
        }
    }

    protected TreeBuilder createTreeBuilder(Properties properties, Builder.Feature ... features) {
        Class<?> clazz = this.load(TreeBuilder.class, properties);
        if (clazz == null) {
            return new Builder(features);
        }
        try {
            if (Builder.class.isAssignableFrom(clazz)) {
                Constructor<?> constructor = clazz.getConstructor(Builder.Feature[].class);
                if (constructor == null) {
                    if (features == null || features.length == 0) {
                        return (TreeBuilder)TreeBuilder.class.cast(clazz.newInstance());
                    }
                    throw new ELException("Builder " + clazz + " is missing constructor (can't pass features)");
                }
                return (TreeBuilder)TreeBuilder.class.cast(constructor.newInstance(new Object[]{features}));
            }
            return (TreeBuilder)TreeBuilder.class.cast(clazz.newInstance());
        }
        catch (Exception e) {
            throw new ELException("TreeBuilder " + clazz + " could not be instantiated", e);
        }
    }

    private Class<?> load(Class<?> clazz, Properties properties) {
        String className;
        if (properties != null && (className = properties.getProperty(clazz.getName())) != null) {
            ClassLoader loader;
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception e) {
                throw new ELException("Could not get context class loader", e);
            }
            try {
                return loader == null ? Class.forName(className) : loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new ELException("Class " + className + " not found", e);
            }
            catch (Exception e) {
                throw new ELException("Class " + className + " could not be instantiated", e);
            }
        }
        return null;
    }

    @Override
    public final Object coerceToType(Object obj, Class<?> targetType) {
        return this.converter.convert(obj, targetType);
    }

    @Override
    public final ObjectValueExpression createValueExpression(Object instance, Class<?> expectedType) {
        return new ObjectValueExpression(this.converter, instance, expectedType);
    }

    @Override
    public final TreeValueExpression createValueExpression(ELContext context, String expression, Class<?> expectedType) {
        return new TreeValueExpression(this.store, context.getFunctionMapper(), context.getVariableMapper(), this.converter, expression, expectedType);
    }

    @Override
    public final TreeMethodExpression createMethodExpression(ELContext context, String expression, Class<?> expectedReturnType, Class<?>[] expectedParamTypes) {
        return new TreeMethodExpression(this.store, context.getFunctionMapper(), context.getVariableMapper(), this.converter, expression, expectedReturnType, expectedParamTypes);
    }

    public static enum Profile {
        JEE5(EnumSet.noneOf(Builder.Feature.class)),
        JEE6(EnumSet.of(Builder.Feature.METHOD_INVOCATIONS, Builder.Feature.VARARGS));

        private final EnumSet<Builder.Feature> features;

        private Profile(EnumSet<Builder.Feature> features) {
            this.features = features;
        }

        Builder.Feature[] features() {
            return this.features.toArray(new Builder.Feature[this.features.size()]);
        }

        boolean contains(Builder.Feature feature) {
            return this.features.contains((Object)feature);
        }
    }
}

