/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.el;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.impl.Condition;
import org.activiti5.engine.impl.context.Context;

public class UelExpressionCondition
implements Condition {
    private static final long serialVersionUID = 1L;
    protected String initialConditionExpression;

    public UelExpressionCondition(String conditionExpression) {
        this.initialConditionExpression = conditionExpression;
    }

    @Override
    public boolean evaluate(String sequenceFlowId, DelegateExecution execution) {
        String conditionExpression = null;
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode elementProperties = Context.getBpmnOverrideElementProperties(sequenceFlowId, execution.getProcessDefinitionId());
            conditionExpression = this.getActiveValue(this.initialConditionExpression, "sequenceFlowCondition", elementProperties);
        } else {
            conditionExpression = this.initialConditionExpression;
        }
        Expression expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(conditionExpression);
        Object result = expression.getValue((VariableScope)execution);
        if (result == null) {
            throw new ActivitiException("condition expression returns null");
        }
        if (!(result instanceof Boolean)) {
            throw new ActivitiException("condition expression returns non-Boolean: " + result + " (" + result.getClass().getName() + ")");
        }
        return (Boolean)result;
    }

    protected String getActiveValue(String originalValue, String propertyName, ObjectNode elementProperties) {
        JsonNode overrideValueNode;
        String activeValue = originalValue;
        if (elementProperties != null && (overrideValueNode = elementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : overrideValueNode.asText();
        }
        return activeValue;
    }
}

