/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.IdentityLink;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.ProcessDefinitionEntity;

public class GetIdentityLinksForProcessDefinitionCmd
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetIdentityLinksForProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public List<IdentityLink> execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = commandContext.getProcessDefinitionEntityManager().findProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("Cannot find process definition with id " + this.processDefinitionId, ProcessDefinition.class);
        }
        List<IdentityLink> identityLinks = processDefinition.getIdentityLinks();
        return identityLinks;
    }
}

