/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.history.HistoricProcessInstance;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.HistoricProcessInstanceEntity;

public class DeleteHistoricProcessInstanceCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;

    public DeleteHistoricProcessInstanceCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("processInstanceId is null");
        }
        HistoricProcessInstanceEntity instance = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(this.processInstanceId);
        if (instance == null) {
            throw new ActivitiObjectNotFoundException("No historic process instance found with id: " + this.processInstanceId, HistoricProcessInstance.class);
        }
        if (instance.getEndTime() == null) {
            throw new ActivitiException("Process instance is still running, cannot delete historic process instance: " + this.processInstanceId);
        }
        commandContext.getHistoricProcessInstanceEntityManager().deleteHistoricProcessInstanceById(this.processInstanceId);
        return null;
    }
}

