/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.CommentEntity;
import org.activiti5.engine.impl.persistence.entity.CommentEntityManager;
import org.activiti5.engine.task.Comment;

public class DeleteCommentCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String processInstanceId;
    protected String commentId;

    public DeleteCommentCmd(String taskId, String processInstanceId, String commentId) {
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.commentId = commentId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        CommentEntityManager commentManager = commandContext.getCommentEntityManager();
        if (this.commentId != null) {
            Comment comment = commentManager.findComment(this.commentId);
            if (comment == null) {
                throw new ActivitiObjectNotFoundException("Comment with id '" + this.commentId + "' doesn't exists.", Comment.class);
            }
            commentManager.delete((CommentEntity)comment);
        } else {
            ArrayList<Comment> comments = new ArrayList<Comment>();
            if (this.processInstanceId != null) {
                comments.addAll(commentManager.findCommentsByProcessInstanceId(this.processInstanceId));
            }
            if (this.taskId != null) {
                comments.addAll(commentManager.findCommentsByTaskId(this.taskId));
            }
            for (Comment comment : comments) {
                commentManager.delete((CommentEntity)comment);
            }
        }
        return null;
    }
}

