/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.util.List;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.persistence.entity.JobEntity;
import org.activiti5.engine.impl.persistence.entity.SuspendedJobEntity;
import org.activiti5.engine.impl.persistence.entity.SuspensionState;
import org.activiti5.engine.impl.persistence.entity.TaskEntity;
import org.activiti5.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti5.engine.runtime.Execution;

public abstract class AbstractSetProcessInstanceStateCmd
implements Command<Void> {
    protected final String executionId;

    public AbstractSetProcessInstanceStateCmd(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ActivitiIllegalArgumentException("ProcessInstanceId cannot be null.");
        }
        ExecutionEntity executionEntity = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
        if (executionEntity == null) {
            throw new ActivitiObjectNotFoundException("Cannot find processInstance for id '" + this.executionId + "'.", Execution.class);
        }
        if (!executionEntity.isProcessInstanceType()) {
            throw new ActivitiException("Cannot set suspension state for execution '" + this.executionId + "': not a process instance.");
        }
        SuspensionState.SuspensionStateUtil.setSuspensionState(executionEntity, this.getNewState());
        List<ExecutionEntity> childExecutions = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(this.executionId);
        for (ExecutionEntity childExecution : childExecutions) {
            if (childExecution.getId().equals(this.executionId)) continue;
            SuspensionState.SuspensionStateUtil.setSuspensionState(childExecution, this.getNewState());
        }
        List<TaskEntity> tasks = commandContext.getTaskEntityManager().findTasksByProcessInstanceId(this.executionId);
        for (TaskEntity taskEntity : tasks) {
            SuspensionState.SuspensionStateUtil.setSuspensionState(taskEntity, this.getNewState());
        }
        if (this.getNewState() == SuspensionState.ACTIVE) {
            List<SuspendedJobEntity> suspendedJobs = commandContext.getSuspendedJobEntityManager().findSuspendedJobsByProcessInstanceId(this.executionId);
            for (SuspendedJobEntity suspendedJob : suspendedJobs) {
                if ("timer".equals(suspendedJob.getJobType())) {
                    TimerJobEntity timerJob = new TimerJobEntity(suspendedJob);
                    commandContext.getTimerJobEntityManager().insert(timerJob);
                    commandContext.getSuspendedJobEntityManager().delete(suspendedJob);
                    continue;
                }
                JobEntity job = new JobEntity(suspendedJob);
                commandContext.getJobEntityManager().insert(job);
                commandContext.getSuspendedJobEntityManager().delete(suspendedJob);
            }
        } else {
            List<TimerJobEntity> timerJobs = commandContext.getTimerJobEntityManager().findTimerJobsByProcessInstanceId(this.executionId);
            for (TimerJobEntity timerJob : timerJobs) {
                SuspendedJobEntity suspendedJob = new SuspendedJobEntity(timerJob);
                commandContext.getSuspendedJobEntityManager().insert(suspendedJob);
                commandContext.getTimerJobEntityManager().delete(timerJob);
            }
            List<JobEntity> jobs = commandContext.getJobEntityManager().findJobsByProcessInstanceId(this.executionId);
            for (JobEntity job : jobs) {
                SuspendedJobEntity suspendedJob = new SuspendedJobEntity(job);
                commandContext.getSuspendedJobEntityManager().insert(suspendedJob);
                commandContext.getJobEntityManager().delete(job);
            }
        }
        return null;
    }

    protected abstract SuspensionState getNewState();
}

