/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.CancelEventDefinition;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.TerminateEventDefinition;
import org.activiti5.engine.impl.bpmn.parser.BpmnParse;
import org.activiti5.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;
import org.activiti5.engine.impl.pvm.process.ScopeImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndEventParseHandler
extends AbstractActivityBpmnParseHandler<EndEvent> {
    private static final Logger logger = LoggerFactory.getLogger(EndEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return EndEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, EndEvent endEvent) {
        ActivityImpl endEventActivity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)endEvent, "endEvent");
        EventDefinition eventDefinition = null;
        if (!endEvent.getEventDefinitions().isEmpty()) {
            eventDefinition = (EventDefinition)endEvent.getEventDefinitions().get(0);
        }
        if (eventDefinition instanceof ErrorEventDefinition) {
            ErrorEventDefinition errorDefinition = (ErrorEventDefinition)eventDefinition;
            if (bpmnParse.getBpmnModel().containsErrorRef(errorDefinition.getErrorCode())) {
                String errorCode = (String)bpmnParse.getBpmnModel().getErrors().get(errorDefinition.getErrorCode());
                if (StringUtils.isEmpty((CharSequence)errorCode)) {
                    logger.warn("errorCode is required for an error event " + endEvent.getId());
                }
                endEventActivity.setProperty("type", "errorEndEvent");
                errorDefinition.setErrorCode(errorCode);
            }
            endEventActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createErrorEndEventActivityBehavior(endEvent, errorDefinition));
        } else if (eventDefinition instanceof CancelEventDefinition) {
            ScopeImpl scope = bpmnParse.getCurrentScope();
            if (scope.getProperty("type") == null || !scope.getProperty("type").equals("transaction")) {
                logger.warn("end event with cancelEventDefinition only supported inside transaction subprocess (id=" + endEvent.getId() + ")");
            } else {
                endEventActivity.setProperty("type", "cancelEndEvent");
                endEventActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createCancelEndEventActivityBehavior(endEvent));
            }
        } else if (eventDefinition instanceof TerminateEventDefinition) {
            endEventActivity.setAsync(endEvent.isAsynchronous());
            endEventActivity.setExclusive(!endEvent.isNotExclusive());
            endEventActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createTerminateEndEventActivityBehavior(endEvent));
        } else if (eventDefinition == null) {
            endEventActivity.setAsync(endEvent.isAsynchronous());
            endEventActivity.setExclusive(!endEvent.isNotExclusive());
            endEventActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createNoneEndEventActivityBehavior(endEvent));
        }
    }
}

