/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl;

import java.io.Serializable;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.interceptor.CommandExecutor;
import org.activiti5.engine.management.TablePage;
import org.activiti5.engine.management.TablePageQuery;

public class TablePageQueryImpl
implements TablePageQuery,
Command<TablePage>,
Serializable {
    private static final long serialVersionUID = 1L;
    transient CommandExecutor commandExecutor;
    protected String tableName;
    protected String order;
    protected int firstResult;
    protected int maxResults;

    public TablePageQueryImpl() {
    }

    public TablePageQueryImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public TablePageQueryImpl tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @Override
    public TablePageQueryImpl orderAsc(String column) {
        this.addOrder(column, "asc");
        return this;
    }

    @Override
    public TablePageQueryImpl orderDesc(String column) {
        this.addOrder(column, "desc");
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    protected void addOrder(String column, String sortOrder) {
        this.order = this.order == null ? "" : this.order + ", ";
        this.order = this.order + column + " " + sortOrder;
    }

    @Override
    public TablePage listPage(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        return this.commandExecutor.execute(this);
    }

    @Override
    public TablePage execute(CommandContext commandContext) {
        return commandContext.getTableDataManager().getTablePage(this, this.firstResult, this.maxResults);
    }

    public String getOrder() {
        return this.order;
    }
}

