/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.deployer;

import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.deploy.Deployer;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.form.api.FormDeploymentBuilder;
import org.activiti.form.api.FormRepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormDeployer
implements Deployer {
    private static final Logger log = LoggerFactory.getLogger(FormDeployer.class);

    public void deploy(DeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        if (!deployment.isNew()) {
            return;
        }
        log.debug("FormDeployer: processing deployment {}", (Object)deployment.getName());
        FormDeploymentBuilder formDeploymentBuilder = null;
        Map resources = deployment.getResources();
        for (String resourceName : resources.keySet()) {
            if (!resourceName.endsWith(".form")) continue;
            log.info("FormDeployer: processing resource {}", (Object)resourceName);
            if (formDeploymentBuilder == null) {
                FormRepositoryService formRepositoryService = Context.getProcessEngineConfiguration().getFormEngineRepositoryService();
                formDeploymentBuilder = formRepositoryService.createDeployment();
            }
            formDeploymentBuilder.addFormBytes(resourceName, ((ResourceEntity)resources.get(resourceName)).getBytes());
        }
        if (formDeploymentBuilder != null) {
            formDeploymentBuilder.parentDeploymentId(deployment.getId());
            if (deployment.getTenantId() != null && deployment.getTenantId().length() > 0) {
                formDeploymentBuilder.tenantId(deployment.getTenantId());
            }
            formDeploymentBuilder.deploy();
        }
    }
}

