/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime.variable;

import org.activiti.app.model.runtime.RestVariable;
import org.activiti.app.rest.runtime.variable.RestVariableConverter;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.springframework.stereotype.Component;

@Component
public class IntegerRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "integer";
    }

    @Override
    public Class<?> getVariableType() {
        return Integer.class;
    }

    @Override
    public Object getVariableValue(RestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof Number)) {
                throw new ActivitiIllegalArgumentException("Converter can only convert integers");
            }
            return ((Number)result.getValue()).intValue();
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, RestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof Integer)) {
                throw new ActivitiIllegalArgumentException("Converter can only convert integers");
            }
            result.setValue(variableValue);
        } else {
            result.setValue(null);
        }
    }
}

