/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime.variable;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.activiti.app.model.runtime.RestVariable;
import org.activiti.app.rest.runtime.variable.RestVariableConverter;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.springframework.stereotype.Component;

@Component
public class DateRestVariableConverter
implements RestVariableConverter {
    protected ISO8601DateFormat isoFormatter = new ISO8601DateFormat();

    @Override
    public String getRestTypeName() {
        return "date";
    }

    @Override
    public Class<?> getVariableType() {
        return Date.class;
    }

    @Override
    public Object getVariableValue(RestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof String)) {
                throw new ActivitiIllegalArgumentException("Converter can only convert string to date");
            }
            try {
                return this.isoFormatter.parse((String)result.getValue());
            }
            catch (ParseException e) {
                throw new ActivitiIllegalArgumentException("The given variable value is not a date: '" + result.getValue() + "'", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, RestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof Date)) {
                throw new ActivitiIllegalArgumentException("Converter can only convert booleans");
            }
            result.setValue((Object)this.isoFormatter.format(variableValue));
        } else {
            result.setValue(null);
        }
    }
}

