/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.activiti.app.model.runtime.CreateTaskRepresentation;
import org.activiti.app.model.runtime.TaskRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TasksResource {
    @Inject
    protected TaskService taskService;

    @RequestMapping(value={"/rest/tasks"}, method={RequestMethod.POST})
    public TaskRepresentation createNewTask(@RequestBody CreateTaskRepresentation taskRepresentation, HttpServletRequest request) {
        if (StringUtils.isEmpty((CharSequence)taskRepresentation.getName())) {
            throw new BadRequestException("Task name is required");
        }
        Task task = this.taskService.newTask();
        task.setName(taskRepresentation.getName());
        task.setDescription(taskRepresentation.getDescription());
        if (StringUtils.isNotEmpty((CharSequence)taskRepresentation.getCategory())) {
            task.setCategory(taskRepresentation.getCategory());
        }
        task.setAssignee(SecurityUtils.getCurrentUserId());
        this.taskService.saveTask(task);
        return new TaskRepresentation((Task)((TaskQuery)this.taskService.createTaskQuery().taskId(task.getId())).singleResult());
    }
}

