/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.runtime.ProcessInstanceRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.UserCache;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProcessInstanceQueryResource {
    private static final int DEFAULT_PAGE_SIZE = 25;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected UserCache userCache;

    public ResultListDataRepresentation getProcessInstances(ObjectNode requestNode) {
        JsonNode stateNode;
        JsonNode deploymentKeyNode;
        HistoricProcessInstanceQuery instanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        User currentUser = SecurityUtils.getCurrentUserObject();
        instanceQuery.involvedUser(String.valueOf(currentUser.getId()));
        JsonNode processDefinitionIdNode = requestNode.get("processDefinitionId");
        if (processDefinitionIdNode != null && !processDefinitionIdNode.isNull()) {
            instanceQuery.processDefinitionId(processDefinitionIdNode.asText());
        }
        if ((deploymentKeyNode = requestNode.get("deploymentKey")) != null && !deploymentKeyNode.isNull()) {
            List deployments = this.repositoryService.createDeploymentQuery().deploymentKey(deploymentKeyNode.asText()).list();
            ArrayList<String> deploymentIds = new ArrayList<String>();
            for (Deployment deployment : deployments) {
                deploymentIds.add(deployment.getId());
            }
            instanceQuery.deploymentIdIn(deploymentIds);
        }
        if ((stateNode = requestNode.get("state")) != null && !stateNode.isNull()) {
            String state = stateNode.asText();
            if ("running".equals(state)) {
                instanceQuery.unfinished();
            } else if ("completed".equals(state)) {
                instanceQuery.finished();
            } else if (!"all".equals(state)) {
                throw new BadRequestException("Illegal state filter value passed, only 'running', 'completed' or 'all' are supported");
            }
        } else {
            instanceQuery.unfinished();
        }
        JsonNode sortNode = requestNode.get("sort");
        if (sortNode != null && !sortNode.isNull()) {
            if ("created-desc".equals(sortNode.asText())) {
                instanceQuery.orderByProcessInstanceStartTime().desc();
            } else if ("created-asc".equals(sortNode.asText())) {
                instanceQuery.orderByProcessInstanceStartTime().asc();
            } else if ("ended-desc".equals(sortNode.asText())) {
                instanceQuery.orderByProcessInstanceEndTime().desc();
            } else if ("ended-asc".equals(sortNode.asText())) {
                instanceQuery.orderByProcessInstanceEndTime().asc();
            }
        } else {
            instanceQuery.orderByProcessInstanceStartTime().desc();
        }
        int page = 0;
        JsonNode pageNode = requestNode.get("page");
        if (pageNode != null && !pageNode.isNull()) {
            page = pageNode.asInt(0);
        }
        int size = 25;
        JsonNode sizeNode = requestNode.get("size");
        if (sizeNode != null && !sizeNode.isNull()) {
            size = sizeNode.asInt(25);
        }
        List instances = instanceQuery.listPage(page * size, size);
        ResultListDataRepresentation result = new ResultListDataRepresentation(this.convertInstanceList(instances));
        if (page != 0 || instances.size() == size) {
            Long totalCount = instanceQuery.count();
            result.setTotal(Long.valueOf(totalCount.intValue()));
            result.setStart(Integer.valueOf(page * size));
        }
        return result;
    }

    protected List<ProcessInstanceRepresentation> convertInstanceList(List<HistoricProcessInstance> instances) {
        ArrayList<ProcessInstanceRepresentation> result = new ArrayList<ProcessInstanceRepresentation>();
        if (CollectionUtils.isNotEmpty(instances)) {
            for (HistoricProcessInstance processInstance : instances) {
                UserCache.CachedUser user;
                User userRep = null;
                if (processInstance.getStartUserId() != null && (user = this.userCache.getUser(processInstance.getStartUserId())) != null && user.getUser() != null) {
                    userRep = user.getUser();
                }
                ProcessDefinitionEntity procDef = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
                ProcessInstanceRepresentation instanceRepresentation = new ProcessInstanceRepresentation(processInstance, (ProcessDefinition)procDef, procDef.isGraphicalNotationDefined(), userRep);
                result.add(instanceRepresentation);
            }
        }
        return result;
    }
}

