/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.activiti.app.domain.runtime.Comment;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.runtime.CommentRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.app.service.exception.NotPermittedException;
import org.activiti.app.service.runtime.CommentService;
import org.activiti.app.service.runtime.PermissionService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.identity.User;
import org.apache.commons.lang3.StringUtils;

public class AbstractCommentsResource {
    @Inject
    private PermissionService permissionService;
    @Inject
    private CommentService commentService;
    @Inject
    private HistoryService historyService;

    public ResultListDataRepresentation getTaskComments(String taskId, Boolean latestFirst) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        this.checkReadPermissionOnTask(currentUser, taskId);
        List comments = this.commentService.getCommentsForTask(taskId, Boolean.TRUE.equals(latestFirst));
        ArrayList<CommentRepresentation> commentList = new ArrayList<CommentRepresentation>();
        for (Comment comment : comments) {
            commentList.add(new CommentRepresentation(comment));
        }
        return new ResultListDataRepresentation(commentList);
    }

    public CommentRepresentation addTaskComment(CommentRepresentation commentRequest, String taskId) {
        if (StringUtils.isBlank((CharSequence)commentRequest.getMessage())) {
            throw new BadRequestException("Comment should not be empty");
        }
        HistoricTaskInstance task = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("No task found with id: " + taskId);
        }
        User currentUser = SecurityUtils.getCurrentUserObject();
        this.checkReadPermissionOnTask(currentUser, taskId);
        Comment comment = this.commentService.createComment(commentRequest.getMessage(), currentUser, task.getId(), task.getProcessInstanceId());
        return new CommentRepresentation(comment);
    }

    public ResultListDataRepresentation getProcessInstanceComments(String processInstanceId, Boolean latestFirst) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        this.checkReadPermissionOnProcessInstance(currentUser, processInstanceId);
        List comments = this.commentService.getCommentsForProcessInstance(processInstanceId, Boolean.TRUE.equals(latestFirst));
        ArrayList<CommentRepresentation> commentList = new ArrayList<CommentRepresentation>();
        for (Comment comment : comments) {
            commentList.add(new CommentRepresentation(comment));
        }
        return new ResultListDataRepresentation(commentList);
    }

    public CommentRepresentation addProcessInstanceComment(CommentRepresentation commentRequest, String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)commentRequest.getMessage())) {
            throw new BadRequestException("Comment should not be empty");
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new NotFoundException("No process instance found with id: " + processInstanceId);
        }
        User currentUser = SecurityUtils.getCurrentUserObject();
        this.checkReadPermissionOnProcessInstance(currentUser, processInstanceId);
        Comment comment = this.commentService.createComment(commentRequest.getMessage(), currentUser, processInstanceId);
        return new CommentRepresentation(comment);
    }

    protected void checkReadPermissionOnTask(User user, String taskId) {
        if (taskId == null) {
            throw new BadRequestException("Task id is required");
        }
        this.permissionService.validateReadPermissionOnTask(SecurityUtils.getCurrentUserObject(), taskId);
    }

    protected void checkReadPermissionOnProcessInstance(User user, String processInstanceId) {
        if (processInstanceId == null) {
            throw new BadRequestException("Process instance id is required");
        }
        if (!this.permissionService.hasReadPermissionOnProcessInstance(SecurityUtils.getCurrentUserObject(), processInstanceId)) {
            throw new NotPermittedException("You are not permitted to read process instance with id: " + processInstanceId);
        }
    }
}

