/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.exception;

import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.BaseModelerRestException;
import org.activiti.app.service.exception.ConflictingRequestException;
import org.activiti.app.service.exception.ErrorInfo;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.app.service.exception.NonJsonResourceNotFoundException;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.app.service.exception.NotPermittedException;
import org.activiti.app.service.exception.UnauthorizedException;
import org.activiti.engine.identity.User;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.LockedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@ControllerAdvice
public class RestExceptionHandlerAdvice {
    private static final String UNAUTHORIZED_MESSAGE_KEY = "GENERAL.ERROR.UNAUTHORIZED";
    private static final String NOT_FOUND_MESSAGE_KEY = "GENERAL.ERROR.NOT-FOUND";
    private static final String BAD_REQUEST_MESSAGE_KEY = "GENERAL.ERROR.BAD-REQUEST";
    private static final String INTERNAL_SERVER_ERROR_MESSAGE_KEY = "GENERAL.ERROR.INTERNAL-SERVER_ERROR";
    private static final String FORBIDDEN_MESSAGE_KEY = "GENERAL.ERROR.FORBIDDEN";
    private static final String INACTIVE_USER_MESSAGE_KEY = "GENERAL.ERROR.INACTIVE_USER";
    private static final String UPLOAD_LIMIT_EXCEEDED = "GENERAL.ERROR.UPLOAD-LIMIT-EXCEEDED";
    private static final String UPLOAD_LIMIT_EXCEEDED_TRIAL_USER = "GENERAL.ERROR.UPLOAD-LIMIT-EXCEEDED-TRIAL-USER";
    private static final String QUOTA_EXCEEDED_PREFIX = "GENERAL.ERROR.QUOTA-EXCEEDED-";

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NotFoundException.class})
    @ResponseBody
    public ErrorInfo handleNotFound(NotFoundException e) {
        return this.createInfoFromException((BaseModelerRestException)e, NOT_FOUND_MESSAGE_KEY);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NonJsonResourceNotFoundException.class})
    public void handleNonJsonResourceNotFound(NonJsonResourceNotFoundException e) {
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BadRequestException.class})
    @ResponseBody
    public ErrorInfo handleBadRequest(BadRequestException e) {
        return this.createInfoFromException((BaseModelerRestException)((Object)e), BAD_REQUEST_MESSAGE_KEY);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={InternalServerErrorException.class})
    @ResponseBody
    public ErrorInfo handleInternalServerError(InternalServerErrorException e) {
        return this.createInfoFromException((BaseModelerRestException)e, INTERNAL_SERVER_ERROR_MESSAGE_KEY);
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={NotPermittedException.class})
    @ResponseBody
    public ErrorInfo handleNoPermission(NotPermittedException e) {
        return this.createInfoFromException((BaseModelerRestException)e, FORBIDDEN_MESSAGE_KEY);
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={LockedException.class})
    @ResponseBody
    public ErrorInfo handleLockedUser(LockedException e) {
        ErrorInfo result = new ErrorInfo(e.getMessage());
        result.setMessageKey(INACTIVE_USER_MESSAGE_KEY);
        return result;
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseBody
    public ErrorInfo handleUnauthorized(UnauthorizedException e) {
        return this.createInfoFromException((BaseModelerRestException)e, UNAUTHORIZED_MESSAGE_KEY);
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={ConflictingRequestException.class})
    @ResponseBody
    public ErrorInfo handleConflict(ConflictingRequestException e) {
        return this.createInfoFromException((BaseModelerRestException)e, BAD_REQUEST_MESSAGE_KEY);
    }

    @ResponseStatus(value=HttpStatus.REQUEST_ENTITY_TOO_LARGE)
    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    @ResponseBody
    public ErrorInfo handleMaxFileSizeExceeded(MaxUploadSizeExceededException musee) {
        ErrorInfo errorInfo = new ErrorInfo("Maximum upload size exceeded");
        User currentUser = SecurityUtils.getCurrentUserObject();
        errorInfo.setMessageKey(UPLOAD_LIMIT_EXCEEDED_TRIAL_USER);
        errorInfo.addParameter("quota", (Object)musee.getMaxUploadSize());
        return errorInfo;
    }

    protected ErrorInfo createInfoFromException(BaseModelerRestException exception, String defaultMessageKey) {
        ErrorInfo result = null;
        result = new ErrorInfo(exception.getMessage());
        if (exception.getCustomData() != null) {
            result.setCustomData(exception.getCustomData());
        }
        if (exception.getMessageKey() != null) {
            result.setMessageKey(exception.getMessageKey());
        } else {
            result.setMessageKey(defaultMessageKey);
        }
        return result;
    }

    protected String getSafeMessageKey(String fragment) {
        if (fragment != null) {
            return fragment.toUpperCase();
        }
        return "";
    }
}

