/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.editor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.activiti.app.domain.editor.AbstractModel;
import org.activiti.app.domain.editor.Model;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.editor.form.FormRepresentation;
import org.activiti.app.repository.editor.ModelRepository;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/form-models"})
public class FormsResource {
    private static final Logger logger = LoggerFactory.getLogger(FormsResource.class);
    private static final int MIN_FILTER_LENGTH = 2;
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ObjectMapper objectMapper;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public ResultListDataRepresentation getForms(HttpServletRequest request) {
        String filter = null;
        List params = URLEncodedUtils.parse((String)request.getQueryString(), (Charset)Charset.forName("UTF-8"));
        if (params != null) {
            for (NameValuePair nameValuePair : params) {
                if (!"filter".equalsIgnoreCase(nameValuePair.getName())) continue;
                filter = nameValuePair.getValue();
            }
        }
        String validFilter = this.makeValidFilterText(filter);
        List models = null;
        models = validFilter != null ? this.modelRepository.findModelsByModelType(Integer.valueOf(2), validFilter) : this.modelRepository.findModelsByModelType(Integer.valueOf(2));
        ArrayList<FormRepresentation> reps = new ArrayList<FormRepresentation>();
        for (Model model : models) {
            reps.add(new FormRepresentation((AbstractModel)model));
        }
        Collections.sort(reps, new NameComparator());
        ResultListDataRepresentation result = new ResultListDataRepresentation(reps);
        result.setTotal(Long.valueOf(models.size()));
        return result;
    }

    protected String makeValidFilterText(String filterText) {
        String trimmed;
        String validFilter = null;
        if (filterText != null && (trimmed = StringUtils.trim((String)filterText)).length() >= 2) {
            validFilter = "%" + trimmed.toLowerCase() + "%";
        }
        return validFilter;
    }

    class NameComparator
    implements Comparator<FormRepresentation> {
        NameComparator() {
        }

        @Override
        public int compare(FormRepresentation o1, FormRepresentation o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }
}

