/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.editor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStreamReader;
import java.util.Collection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.app.domain.editor.AbstractModel;
import org.activiti.app.domain.editor.Model;
import org.activiti.app.model.editor.ModelRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.ModelService;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.NonJsonResourceNotFoundException;
import org.activiti.app.util.XmlUtil;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.identity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public class AbstractModelResource {
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ObjectMapper objectMapper;
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();
    protected BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();

    public ModelRepresentation getModel(String modelId) {
        Model model = this.modelService.getModel(modelId);
        ModelRepresentation result = new ModelRepresentation((AbstractModel)model);
        return result;
    }

    public byte[] getModelThumbnail(String modelId) {
        Model model = this.modelService.getModel(modelId);
        if (model == null) {
            throw new NonJsonResourceNotFoundException();
        }
        return model.getThumbnail();
    }

    public ModelRepresentation importNewVersion(String modelId, MultipartFile file) {
        Model processModel = this.modelService.getModel(modelId);
        User currentUser = SecurityUtils.getCurrentUserObject();
        String fileName = file.getOriginalFilename();
        if (fileName != null && (fileName.endsWith(".bpmn") || fileName.endsWith(".bpmn20.xml"))) {
            try {
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                InputStreamReader xmlIn = new InputStreamReader(file.getInputStream(), "UTF-8");
                XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
                BpmnModel bpmnModel = this.bpmnXMLConverter.convertToBpmnModel(xtr);
                if (CollectionUtils.isEmpty((Collection)bpmnModel.getProcesses())) {
                    throw new BadRequestException("No process found in definition " + fileName);
                }
                if (bpmnModel.getLocationMap().size() == 0) {
                    throw new BadRequestException("No required BPMN DI information found in definition " + fileName);
                }
                ObjectNode modelNode = this.bpmnJsonConverter.convertToJson(bpmnModel);
                Model savedModel = this.modelService.saveModel(modelId, processModel.getName(), processModel.getKey(), processModel.getDescription(), modelNode.toString(), true, "Version import via REST service", currentUser);
                return new ModelRepresentation((AbstractModel)savedModel);
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BadRequestException("Import failed for " + fileName + ", error message " + e.getMessage());
            }
        }
        throw new BadRequestException("Invalid file name, only .bpmn and .bpmn20.xml files are supported not " + fileName);
    }
}

