/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.editor;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.activiti.app.domain.editor.AbstractModel;
import org.activiti.app.domain.editor.Model;
import org.activiti.app.domain.editor.ModelHistory;
import org.activiti.app.service.api.ModelService;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.BaseModelerRestException;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.bpmn.model.BpmnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractModelBpmnResource {
    private final Logger log = LoggerFactory.getLogger(AbstractModelBpmnResource.class);
    @Autowired
    protected ModelService modelService;

    public void getProcessModelBpmn20Xml(HttpServletResponse response, String processModelId) throws IOException {
        if (processModelId == null) {
            throw new BadRequestException("No process model id provided");
        }
        Model model = this.modelService.getModel(processModelId);
        this.generateBpmn20Xml(response, (AbstractModel)model);
    }

    public void getHistoricProcessModelBpmn20Xml(HttpServletResponse response, String processModelId, String processModelHistoryId) throws IOException {
        if (processModelId == null) {
            throw new BadRequestException("No process model id provided");
        }
        ModelHistory historicModel = this.modelService.getModelHistory(processModelId, processModelHistoryId);
        this.generateBpmn20Xml(response, (AbstractModel)historicModel);
    }

    protected void generateBpmn20Xml(HttpServletResponse response, AbstractModel model) {
        String name = model.getName().replaceAll(" ", "_");
        response.setHeader("Content-Disposition", "attachment; filename=" + name + ".bpmn20.xml");
        if (model.getModelEditorJson() != null) {
            try {
                int count;
                ServletOutputStream servletOutputStream = response.getOutputStream();
                response.setContentType("application/xml");
                BpmnModel bpmnModel = this.modelService.getBpmnModel(model);
                byte[] xmlBytes = this.modelService.getBpmnXML(bpmnModel);
                BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(xmlBytes));
                byte[] buffer = new byte[8096];
                while ((count = in.read(buffer)) != -1) {
                    servletOutputStream.write(buffer, 0, count);
                }
                servletOutputStream.flush();
                servletOutputStream.close();
            }
            catch (BaseModelerRestException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("Could not generate BPMN 2.0 XML", (Throwable)e);
                throw new InternalServerErrorException("Could not generate BPMN 2.0 xml");
            }
        }
    }
}

