/*
	Animal Crossing: New Leaf (Welcome amiibo) building list for Savegame Editor

	FORMAT: [id,plusId,group,mask,name,lockInEditor]
*/


/*
0xbb,0xab,0x9b,0x0b,0x1b,0x2b,0x3b
0xba,0xaa,0x9a,0x0a,0x1a,0x2a,0x3a
0xb9,0xa9,0x99,0x09,0x19,0x29,0x39
0xb0,0xa0,0x90,0x00,0x10,0x20,0x30
0xb1,0xa1,0x91,0x01,0x11,0x21,0x31
0xb2,0xa2,0x92,0x02,0x12,0x22,0x32
0xb3,0xa3,0x93,0x03,0x13,0x23,0x33
*/

const BUILDING_MASK_NONE=[];
const BUILDING_MASK_1x1=[0x00];
const BUILDING_MASK_1x2=[0x00,0x09];
const BUILDING_MASK_2x1=[0x00,0x10];
const BUILDING_MASK_2x2=[0x00,0x10,0x09,0x19];
const BUILDING_MASK_2x3=[0x0a,0x1a,0x09,0x19,0x00,0x10];
const BUILDING_MASK_3x1=[0x90,0x00,0x10];
const BUILDING_MASK_3x2=[0x99,0x09,0x19,0x90,0x00,0x10];
const BUILDING_MASK_3x3=[0x9a,0x0a,0x1a,0x99,0x09,0x19,0x90,0x00,0x10];
const BUILDING_MASK_BUS_STOP=[0x99,0x09,0x19,0x29,0x90,0x20];
const BUILDING_MASK_BRIDGE_N_S=[0x0a,0x1a,0x09,0x19,0x00,0x10,0x01,0x11];
const BUILDING_MASK_BRIDGE_SW_NE=[0x09,0x19,0x90,0x00,0x10,0x91,0x01];
const BUILDING_MASK_BRIDGE_NW_SE=[0x99,0x09,0x90,0x00,0x10,0x01,0x11];
const BUILDING_MASK_BRIDGE_W_E=[0x99,0x09,0x19,0x29,0x90,0x00,0x10,0x20];
const BUILDING_MASK_PLAZA_TREE=[0x99,0x09,0x19,0x90,0x00,0x10,0x91,0x01,0x11];
const BUILDING_MASK_HOUSE_VILLAGER=[0x99,0x09,0x19,0x90,0x00,0x10,0x91,0x01,0x11,0x02];
const BUILDING_MASK_POLICE_STATION_AND_CAMPSITE=[0x99,0x09,0x19,0x90,0x00,0x10,0x91,0x01,0x11,0x02,0x03];
const BUILDING_MASK_HOUSE_PLAYER_TOWNHALL=[0xa9,0x99,0x09,0x19,0x29,0xa0,0x90,0x00,0x10,0x20,0xa1,0x91,0x01,0x11,0x21,0x02];
const BUILDING_MASK_TRAIN_STATION=[0xa9,0x99,0x09,0x19,0x29,0xa0,0x90,0x00,0x10,0x20,0x01,0x02];
const BUILDING_MASK_RETAIL=[0x9a,0x0a,0x1a,0x2a,0x3a,0x99,0x09,0x19,0x29,0x39,0x90,0x00,0x10,0x20,0x01,0x02];
const BUILDING_MASK_THE_ROOST=[0xaa,0x9a,0x0a,0x1a,0x2a,0xa9,0x99,0x09,0x19,0x29,0xa0,0x90,0x00,0x10,0x20,0xa1,0x91,0x01,0x11,0x21,0x02];
const BUILDING_MASK_FENCE=[0xab,0x9b,0x0b,0x1b,0x2b,0xaa,0x2a,0xa9,0x29,0xa0,0x90,0x10,0x20];
const BUILDING_MASK_BULLETIN_BOARD=[0x99,0x09,0x90,0x00];
const BUILDING_MASK_RAILROAD_CROSSING_ARMS=[0xa0,0x90,0x00,0x10,0x20];

var BUILDINGS=[
[0x00,0x00,-1,BUILDING_MASK_HOUSE_PLAYER_TOWNHALL,["player 1 house","joueur 1 - maison",,,"casa jugador 1"]],
[0x01,0x01,-1,BUILDING_MASK_HOUSE_PLAYER_TOWNHALL,["player 2 house","joueur 2 - maison",,,"casa jugador 2"]],
[0x02,0x02,-1,BUILDING_MASK_HOUSE_PLAYER_TOWNHALL,["player 3 house","joueur 3 - maison",,,"casa jugador 3"]],
[0x03,0x03,-1,BUILDING_MASK_HOUSE_PLAYER_TOWNHALL,["player 4 house","joueur 4 - maison",,,"casa jugador 4"]],
[0x04,0x04,-1,BUILDING_MASK_NONE,["mailbox only (player 1)","joueur 1 - boîte aux lettres",,,"buzón suelto (jugador 1)"]],
[0x05,0x05,-1,BUILDING_MASK_NONE,["mailbox only (player 2)","joueur 2 - boîte aux lettres",,,"buzón suelto (jugador 2)"]],
[0x06,0x06,-1,BUILDING_MASK_NONE,["mailbox only (player 3)","joueur 3 - boîte aux lettres",,,"buzón suelto (jugador 3)"]],
[0x07,0x07,-1,BUILDING_MASK_NONE,["mailbox only (player 4)","joueur 4 - boîte aux lettres",,,"buzón suelto (jugador 4)"]],
[0x08,0x08,-1,BUILDING_MASK_HOUSE_VILLAGER,["villager 1 house","villageois 1 - maison",,,"casa vecino 1"]],
[0x09,0x09,-1,BUILDING_MASK_HOUSE_VILLAGER,["villager 2 house","villageois 2 - maison",,,"casa vecino 2"]],
[0x0a,0x0a,-1,BUILDING_MASK_HOUSE_VILLAGER,["villager 3 house","villageois 3 - maison",,,"casa vecino 3"]],
[0x0b,0x0b,-1,BUILDING_MASK_HOUSE_VILLAGER,["villager 4 house","villageois 4 - maison",,,"casa vecino 4"]],
[0x0c,0x0c,-1,BUILDING_MASK_HOUSE_VILLAGER,["villager 5 house","villageois 5 - maison",,,"casa vecino 5"]],
[0x0d,0x0d,-1,BUILDING_MASK_HOUSE_VILLAGER,["villager 6 house","villageois 6 - maison",,,"casa vecino 6"]],
[0x0e,0x0e,-1,BUILDING_MASK_HOUSE_VILLAGER,["villager 7 house","villageois 7 - maison",,,"casa vecino 7"]],
[0x0f,0x0f,-1,BUILDING_MASK_HOUSE_VILLAGER,["villager 8 house","villageois 8 - maison",,,"casa vecino 8"]],
[0x10,0x10,-1,BUILDING_MASK_HOUSE_VILLAGER,["villager 9 house","villageois 9 - maison",,,"casa vecino 9"]],
[0x11,0x11,-1,BUILDING_MASK_HOUSE_VILLAGER,["villager 10 house","villageois 10 - maison",,,"casa vecino 10"]],
[0x4c,0x4c,0,BUILDING_MASK_POLICE_STATION_AND_CAMPSITE,["modern police station","poste police moderne","Polizeizentrale","staz. di polizia moderna","comisaría moderna"]],
[0x4d,0x4d,0,BUILDING_MASK_POLICE_STATION_AND_CAMPSITE,["classic police station","poste police classique","Polizeiwache","staz. di polizia classica","comisaría clásica"]],
[0x4e,0x4e,0,BUILDING_MASK_THE_ROOST,["café",,"Café","caffetteria","cafetería"]],
[0x4f,0x4f,0,BUILDING_MASK_1x1,["Reset Center","centre Resetti","BUA","Centro Resetti","Centro de Reseteos"]],
[0x50,0x50,1,BUILDING_MASK_HOUSE_PLAYER_TOWNHALL,["classic town hall","mairie classique"]],
[0x51,0x51,1,BUILDING_MASK_HOUSE_PLAYER_TOWNHALL,["zen town hall","mairie japonaise"]],
[0x52,0x52,1,BUILDING_MASK_HOUSE_PLAYER_TOWNHALL,["fairy-tale town hall","mairie féérique"]],
[0x53,0x53,1,BUILDING_MASK_HOUSE_PLAYER_TOWNHALL,["modern town hall","mairie moderne"]],
[0x54,0x54,2,BUILDING_MASK_TRAIN_STATION,["classic train station","gare classique"]],
[0x55,0x55,2,BUILDING_MASK_TRAIN_STATION,["zen train station","gare japonaise"]],
[0x56,0x56,2,BUILDING_MASK_TRAIN_STATION,["fairy-tale train station","gare féérique"]],
[0x57,0x57,2,BUILDING_MASK_TRAIN_STATION,["modern train station","gare moderne"]],
[0x58,0x58,-1,BUILDING_MASK_RETAIL,["recycle shop","Revente et Retouche"]],
[0x59,0x59,0,BUILDING_MASK_PLAZA_TREE,["town plaza","Place de la ville"]],
[0x5a,0x5a,-1,BUILDING_MASK_RAILROAD_CROSSING_ARMS,["railroad crossing arms","Barrière voie ferrée"]],
[0x5b,0x5b,-1,BUILDING_MASK_BULLETIN_BOARD,["bulletin board","Panneau messages"]],
[0x5c,0x5c,-1,BUILDING_MASK_NONE,["island storage bin","Panier de l&#39;île"]],
[0x5d,0x5d,-1,BUILDING_MASK_NONE,["dock","Bateau d&#39;Amiral"]],
[0x5e,0x5e,0,BUILDING_MASK_NONE,["Katrina&#39;s Tent","Tente d&#39;Astrid"]],
[0x5f,0x5f,0,BUILDING_MASK_NONE,["Camper&#39;s Tent","Tente de campeur"]],
[0x60,0x60,0,BUILDING_MASK_NONE,["Redd&#39;s Tent","Tente de Rounard"]],
[0x61,0x61,0,BUILDING_MASK_NONE,["Chip&#39;s Tent","Tente de Castor"]],
[0x62,0x62,0,BUILDING_MASK_NONE,["Nat&#39;s Tent","Tente de Djarod"]],
[0x63,0x63,0,BUILDING_MASK_NONE,["Franklin&#39;s Table","Table de Dindou"]],
[0x64,0x64,0,BUILDING_MASK_NONE,["Pavé&#39;s Dance Stage","Stand de Roberto"]],
[0x65,0x65,0,BUILDING_MASK_NONE,["Countdown Board","Panneau compte à rebours"]],
[0x66,0x66,0,BUILDING_MASK_NONE,["Redd&#39;s Stand","Stand de Rounard"]],
[0x67,0x67,0,BUILDING_MASK_NONE,["Dream World Bed","Lit onirique"]],
[0x69,0x69,-1,BUILDING_MASK_NONE,["Island Hut","Hutte de l&#39;île"]], /* crashes when it's placed at normal map */
[0x6a,0x6a,0,BUILDING_MASK_NONE,["Lloid","Gyroïde"]],
[0x6b,0x6b,0,BUILDING_MASK_NONE,["face cutout standee - New Years Day"]],
[0x6c,0x6c,0,BUILDING_MASK_NONE,["face cutout standee - 6c? japanese rite"]],
[0x6d,0x6d,0,BUILDING_MASK_NONE,["face cutout standee - 6d? sky night"]],
[0x6e,0x6e,0,BUILDING_MASK_NONE,["face cutout standee - Groundhog Day"]],
[0x6f,0x6f,0,BUILDING_MASK_NONE,["face cutout standee - Bean Throwing Festival (Setsubun)"]],
[0x70,0x70,0,BUILDING_MASK_NONE,["face cutout standee - 70? japanese wedding"]],
[0x71,0x71,0,BUILDING_MASK_NONE,["face cutout standee - Shamrock Day"]],
[0x72,0x72,0,BUILDING_MASK_NONE,["face cutout standee - 72? garden kids"]],
[0x73,0x73,0,BUILDING_MASK_NONE,["face cutout standee - Nature Day"]],
[0x74,0x74,0,BUILDING_MASK_NONE,["face cutout standee - 74? carp banner"]],
[0x75,0x75,0,BUILDING_MASK_NONE,["face cutout standee - 75? japanese school"]],
[0x76,0x76,0,BUILDING_MASK_NONE,["face cutout standee - Summer Solstice"]],
[0x77,0x77,0,BUILDING_MASK_NONE,["face cutout standee - Starcrossed Day (Tanabata)"]],
[0x78,0x78,0,BUILDING_MASK_NONE,["face cutout standee - Obon"]],
[0x79,0x79,0,BUILDING_MASK_NONE,["face cutout standee - Labor Day"]],
[0x7a,0x7a,0,BUILDING_MASK_NONE,["face cutout standee - Tsukimi"]],
[0x7b,0x7b,0,BUILDING_MASK_NONE,["face cutout standee - Autumn Moon"]],
[0x7c,0x7c,0,BUILDING_MASK_NONE,["face cutout standee - Explorer&#39;s Day"]],
[0x7d,0x7d,0,BUILDING_MASK_NONE,["face cutout standee - Toy Day"]],
[0x7e,0x7e,0,BUILDING_MASK_NONE,["face cutout standee - Winter Solstice"]],
/* from 0x7f to 0x8b - glitchy doors */
[0x8c,0x8e,0,BUILDING_MASK_NONE,["Main Street lamp","Lampe centre-ville"]],
[0x8d,0x8f,0,BUILDING_MASK_1x2,["Main Street bench (vertical)"]],
[0x8e,0x90,6,BUILDING_MASK_BRIDGE_N_S,["cobblestone bridge (N-S)","pont en pierre (N-S)","Steinbrücke (N-S)","ponte di pietra (N-S)","puente de piedra (N-S)"]],
[0x8f,0x91,6,BUILDING_MASK_BRIDGE_SW_NE,["cobblestone bridge (SW-NE)","pont en pierre (SO-NE)","Steinbrücke (SW-NE)","ponte di pietra (SW-NE)","puente de piedra (SO-NE)"]],
[0x90,0x92,6,BUILDING_MASK_BRIDGE_NW_SE,["cobblestone bridge (NW-SE)","pont en pierre (NO-SE)","Steinbrücke (NW-SE)","ponte di pietra (NW-SE)","puente de piedra (NO-SE)"]],
[0x91,0x93,6,BUILDING_MASK_BRIDGE_W_E,["cobblestone bridge (W-E)","pont en pierre (O-E)","Steinbrücke (W-E)","ponte di pietra (W-E)","puente de piedra (O-E)"]],
[0x92,0x94,6,BUILDING_MASK_BRIDGE_N_S,["suspension bridge (N-S)","pont suspendu (N-S)","Hängebrücke (N-S)","ponte sospeso (N-S)","puente colgante (N-S)"]],
[0x93,0x95,6,BUILDING_MASK_BRIDGE_SW_NE,["suspension bridge (SW-NE)","pont suspendu (SO-NE)","Hängebrücke (SW-NE)","ponte sospeso (SW-NE)","puente colgante (SO-NE)"]],
[0x94,0x96,6,BUILDING_MASK_BRIDGE_NW_SE,["suspension bridge (NW-SE)","pont suspendu (NO-SE)","Hängebrücke (NW-SE)","ponte sospeso (NW-SE)","puente colgante (NO-SE)"]],
[0x95,0x97,6,BUILDING_MASK_BRIDGE_W_E,["suspension bridge (W-E)","pont suspendu (O-E)","Hängebrücke (W-E)","ponte sospeso (W-E)","puente colgante (O-E)"]],
[0x96,0x98,6,BUILDING_MASK_BRIDGE_N_S,["brick bridge (N-S)","pont en brique (N-S)","Backsteinbrücke (N-S)","ponte di mattoni (N-S)","puente de ladrillo (N-S)"]],
[0x97,0x99,6,BUILDING_MASK_BRIDGE_SW_NE,["brick bridge (SW-NE)","pont en brique (SO-NE)","Backsteinbrücke (SW-NE)","ponte di mattoni (SW-NE)","puente de ladrillo (SO-NE)"]],
[0x98,0x9a,6,BUILDING_MASK_BRIDGE_NW_SE,["brick bridge (NW-SE)","pont en brique (NO-SE)","Backsteinbrücke (NW-SE)","ponte di mattoni (NW-SE)","puente de ladrillo (NO-SE)"]],
[0x99,0x9b,6,BUILDING_MASK_BRIDGE_W_E,["brick bridge (W-E)","pont en brique (O-E)","Backsteinbrücke (W-E)","ponte di mattoni (W-E)","puente de ladrillo (O-E)"]],
[0x9a,0x9c,6,BUILDING_MASK_BRIDGE_N_S,["modern bridge (N-S)","pont moderne (N-S)","Betonbrücke (N-S)","ponte moderno (N-S)","puente moderno (N-S)"]],
[0x9b,0x9d,6,BUILDING_MASK_BRIDGE_SW_NE,["modern bridge (SW-NE)","pont moderne (SO-NE)","Betonbrücke (SW-NE)","ponte moderno (SW-NE)","puente moderno (SO-NE)"]],
[0x9c,0x9e,6,BUILDING_MASK_BRIDGE_NW_SE,["modern bridge (NW-SE)","pont moderne (NO-SE)","Betonbrücke (NW-SE)","ponte moderno (NW-SE)","puente moderno (NO-SE)"]],
[0x9d,0x9f,6,BUILDING_MASK_BRIDGE_W_E,["modern bridge (W-E)","pont moderne (O-E)","Betonbrücke (W-E)","ponte moderno (W-E)","puente moderno (O-E)"]],
[0x9e,0xa0,6,BUILDING_MASK_BRIDGE_N_S,["wooden bridge (N-S)","pont japonais (N-S)","Holzbrücke (N-S)","ponte di legno (N-S)","puente de madera (N-S)"]],
[0x9f,0xa1,6,BUILDING_MASK_BRIDGE_SW_NE,["wooden bridge (SW-NE)","pont japonais (SO-NE)","Holzbrücke (SW-NE)","ponte di legno (SW-NE)","puente de madera (SO-NE)"]],
[0xa0,0xa2,6,BUILDING_MASK_BRIDGE_NW_SE,["wooden bridge (NW-SE)","pont japonais (NO-SE)","Holzbrücke (NW-SE)","ponte di legno (NW-SE)","puente de madera (NO-SE)"]],
[0xa1,0xa3,6,BUILDING_MASK_BRIDGE_W_E,["wooden bridge (W-E)","pont japonais (O-E)","Holzbrücke (W-E)","ponte di legno (W-E)","puente de madera (O-E)"]],
[0xa2,0xa4,6,BUILDING_MASK_BRIDGE_N_S,["fairy-tale bridge (N-S)","pont féérique (N-S)","Märchenbrücke (N-S)","ponte fiabesco (N-S)","puente de cuento (N-S)"]],
[0xa3,0xa5,6,BUILDING_MASK_BRIDGE_SW_NE,["fairy-tale bridge (SW-NE)","pont féérique (SO-NE)","Märchenbrücke (SW-NE)","ponte fiabesco (SW-NE)","puente de cuento (SO-NE)"]],
[0xa4,0xa6,6,BUILDING_MASK_BRIDGE_NW_SE,["fairy-tale bridge (NW-SE)","pont féérique (NO-SE)","Märchenbrücke (NW-SE)","ponte fiabesco (NW-SE)","puente de cuento (NO-SE)"]],
[0xa5,0xa7,6,BUILDING_MASK_BRIDGE_W_E,["fairy-tale bridge (W-E)","pont féérique (O-E)","Märchenbrücke (W-E)","ponte fiabesco (W-E)","puente de cuento (O-E)"]],
[0xa6,0xa8,0,BUILDING_MASK_2x1,["yellow bench","banc jaune","Parkbank","panchina gialla","banco amarillo"]],
[0xa7,0xa9,0,BUILDING_MASK_2x1,["blue bench","banc bleu","Plastikbank","panchina azzurra","banco azul"]],
[0xa8,0xaa,0,BUILDING_MASK_2x1,["wood bench","banc en bois","Holzbank","panchina di legno","banco de madera"]],
[0xa9,0xab,0,BUILDING_MASK_2x1,["metal bench","banc en métal","Metallbank","panchina di metallo","banco de metal"]],
[0xaa,0xac,0,BUILDING_MASK_2x1,["log bench","banc tronc","Baumstammbank","panchina tronco","tronco para sentarse"]],
[0xab,0xad,0,BUILDING_MASK_2x1,["modern bench","banc moderne","Designerbank","panchina moderna","banco moderno"]],
[0xac,0xae,0,BUILDING_MASK_2x1,["fairy-tale bench","banc féérique","Märchenbank","panchina fiabesca","banco de cuento"]],
[0xad,0xaf,0,BUILDING_MASK_2x1,["zen bench","banc japonais","Fernostbank","panchina giapponese","banco japonés"]],
[0xae,0xb0,0,BUILDING_MASK_2x2,["flower bed","parterre de fleurs","Blumenbeet","aiuola","parterre"]],
[0xaf,0xb1,0,BUILDING_MASK_1x1,["drinking fountain","fontaine-abreuvoir","Trinkbrunnen","fontanella","fuente para beber","water fountain"]],
[0xb0,0xb2,0,BUILDING_MASK_1x1,["instrument shelter","abri météorologique","Wetterstation","stazione meteorologica","caja meteorológica"]],
[0xb1,0xb3,0,BUILDING_MASK_2x2,["sandbox","bac à sable","Sandkasten","recinto per la sabbia","caja de arena"]],
[0xb2,0xb4,0,BUILDING_MASK_1x1,["garbage can","poubelle","Mülleimer","cestino dei rifiuti","papelera"]],
[0xb3,0xb5,0,BUILDING_MASK_2x1,["pile of pipes","pile de tuyaux","Rohrstapel","pila di tubi","montón de tubos"]],
[0xb4,0xb6,0,BUILDING_MASK_2x2,["water well","puits en pierre","Ziehbrunnen","pozzo","pozo"]],
[0xb5,0xb7,0,BUILDING_MASK_3x3,["fountain","fontaine","Springbrunnen","fontana","fuente"]],
[0xb6,0xb8,0,BUILDING_MASK_2x1,["tire toy","jeu de pneus","Reifenspielgerät","tris di ruote da parco","rueda de juguete"]],
[0xb7,0xb9,0,BUILDING_MASK_2x2,["jungle gym","cage à écureuil","Klettergerüst","struttura d&#39;arrampicata","bola de barras","climbing frame"]],
[0xb8,0xba,0,BUILDING_MASK_1x1,["park clock","horloge lampadaire","Uhr","orologio da esterni","reloj"]],
[0xb9,0xbb,0,BUILDING_MASK_1x1,["modern clock","horloge moderne","Designeruhr","orologio moderno","reloj moderno"]],
[0xba,0xbc,0,BUILDING_MASK_1x1,["fairy-tale clock","horloge féérique","Märchenuhr","orologio fiabesco","reloj de cuento"]],
[0xbb,0xbd,0,BUILDING_MASK_1x1,["zen clock","horloge japonaise","Fernostuhr","orologio giapponese","reloj japonés"]],
[0xbc,0xbe,0,BUILDING_MASK_1x1,["street lamp","lampadaire","Gaslaterne","lampione","farola"]],
[0xbd,0xbf,0,BUILDING_MASK_1x1,["round streetlight","lampadaire globe","Straßenlaterne","lampione tondo","farola redonda"]],
[0xbe,0xc0,0,BUILDING_MASK_1x1,["streetlight","lampadaire rural","Retro-Straßenlaterne","palo della luce","farola antigua"]],
[0xbf,0xc1,0,BUILDING_MASK_1x1,["modern streetlight","lampadaire moderne","Designer-Wegleuchte","lampione moderno","farola moderna"]],
[0xc0,0xc2,0,BUILDING_MASK_1x1,["fairy-tale streetlight","lampadaire féérique","Märchenlaterne","lampione fiabesco","farola de cuento"]],
[0xc1,0xc3,0,BUILDING_MASK_1x1,["zen streetlight","lampadaire japonais","Fernostlaterne","lampione giapponese","farola japonesa"]],
[0xc2,0xc4,0,BUILDING_MASK_3x1,["balloon arch","arche de ballons","Ballontor","arco di palloncini","arco de globos"]],
[0xc3,0xc5,0,BUILDING_MASK_3x1,["flower arch","arche florale","Blumentor","arco floreale","arco de flores"]],
[0xc4,0xc6,0,BUILDING_MASK_POLICE_STATION_AND_CAMPSITE,["campsite","campement","Campingplatz","area per campeggio","acampada"]],
[0xc5,0xc7,0,BUILDING_MASK_2x3,["picnic blanket","couverture pique-nique","Picknickdecke","area da picnic","mantel de pícnic"]],
[0xc6,0xc8,0,BUILDING_MASK_2x1,["hammock","hamac","Hängematte","amaca","hamaca"]],
[0xc7,0xc9,0,BUILDING_MASK_2x2,["fire pit","bûcher","Feuerstelle","falò","hoguera"]],
[0xc8,0xca,0,BUILDING_MASK_2x3,["camping cot","lit de camp","Feldbett","branda da campeggio","cama de campaña"]],
[0xc9,0xcb,0,BUILDING_MASK_1x1,["outdoor chair","chaise de jardin","Liegestuhl","sdraio","tumbona"]],
[0xca,0xcc,0,BUILDING_MASK_1x1,["torch","torche","Fackel","torcia","antorcha"]],
[0xcb,0xcd,0,BUILDING_MASK_3x3,["zen garden","jardin zen","Fernostgarten","giardino zen","jardín zen"]],
[0xcc,0xce,0,BUILDING_MASK_3x2,["hot spring","source d&#39;eau chaude","Thermalbad","sorgente termale","fuente termal"]],
[0xcd,0xcf,0,BUILDING_MASK_2x2,["geyser","geyser","Geysir","geyser","géiser"]],
[0xce,0xd0,0,BUILDING_MASK_2x2,["statue fountain","statue fontaine","Skulpturbrunnen","fontana con statua","fuente con estatua"]],
[0xcf,0xd1,0,BUILDING_MASK_1x1,["stone tablet","pierre gravée","Gedenkstein","stele incisa","placa de piedra"]],
[0xd0,0xd2,0,BUILDING_MASK_1x1,["water pump","pompe à eau","Wasserpumpe","pompa dell&#39;acqua","bomba de agua"]],
[0xd1,0xd3,0,BUILDING_MASK_3x3,["wisteria trellis","pergola","Blumenpergola","pergola","pérgola"]],
[0xd2,0xd4,0,BUILDING_MASK_2x2,["bell","cloche","Glocke","campana","campana"]],
[0xd3,0xd5,0,BUILDING_MASK_2x2,["zen bell","cloche japonaise","Tempelglocke","campana giapponese","campana oriental"]],
[0xd4,0xd6,0,BUILDING_MASK_2x1,["scarecrow","épouvantail","Vogelscheuche","spaventapasseri","espantapájaros"]],
[0xd5,0xd7,0,BUILDING_MASK_2x1,["rack of rice","palissade de fagots","Getreideständer","rastrelliera per fascine","secadero de arroz"]],
[0xd6,0xd8,0,BUILDING_MASK_FENCE,["fence","clôture","Holzzaun","staccionata","cercado"]],
[0xd7,0xd9,0,BUILDING_MASK_BUS_STOP,["bus stop","arrêt de bus","Bushaltestelle","fermata dell&#39;autobus","parada de autobús"]],
[0xd8,0xda,0,BUILDING_MASK_1x1,["fire hydrant","borne incendie","Hydrant","idrante antincendio","boca de incendio"]],
[0xd9,0xdb,0,BUILDING_MASK_1x1,["traffic signal","feu piétons","Ampel","semaforo","semáforo"]],
[0xda,0xdc,-1,BUILDING_MASK_1x1,["custom-design sign","panneau motif perso","Designschild","cartello modello pers.","panel de diseño"],true],
[0xdb,0xdd,-1,BUILDING_MASK_1x1,["face-cutout standee","panneau photo","Fotowand","sagoma per le foto","panel para fotos"],true],
[0xdc,0xde,0,BUILDING_MASK_1x1,["caution sign","panneau avertissement","Warnschild","segnale di pericolo","señal de peligro"]],
[0xdd,0xdf,0,BUILDING_MASK_1x1,["do-not-enter sign","panneau d&#39;interdiction","Verbotsschild","segnale di divieto","prohibido el paso"]],
[0xde,0xe0,0,BUILDING_MASK_1x1,["yield sign","panneau de priorité","Vorfahrtsschild","segnale di precedenza","ceda el paso"]],
[0xdf,0xe1,0,BUILDING_MASK_2x2,["cube sculpture","sculpture cubique","Würfelskulptur","scultura cubica","escultura cúbica"]],
[0xe0,0xe2,0,BUILDING_MASK_3x3,["archway sculpture","sculpture courbe","Torskulptur","scultura astratta","escultura abstracta"]],
[0xe1,0xe3,0,BUILDING_MASK_2x2,["chair sculpture","sculpture chaise","Sitzskulptur","scultura sedia","estatua silla"]],
[0xe2,0xe4,0,BUILDING_MASK_2x1,["illuminated heart","cœur illuminé","Lichterherz","cuore illuminato","corazón de luces"]],
[0xe3,0xe5,0,BUILDING_MASK_3x1,["illuminated arch","arche illuminée","Lichtertor","arco illuminato","arco de luces"]],
[0xe4,0xe6,0,BUILDING_MASK_3x3,["illuminated clock","horloge illuminée","Lichteruhr","orologio illuminato","reloj de luces"]],
[0xe5,0xe7,0,BUILDING_MASK_1x1,["illuminated tree","sapin illuminé","Lichterbaum","albero illuminato","árbol de luces"]],
[0xe6,0xe8,0,BUILDING_MASK_2x1,["stadium light","éclairage de stade","Flutlicht","faro da stadio","foco de estadio"]],
[0xe7,0xe9,0,BUILDING_MASK_2x1,["video screen","panneau électronique","Videowand","maxischermo","pantalla gigante"]],
[0xe8,0xea,0,BUILDING_MASK_3x3,["drilling rig","puits de pétrole","Erdölpumpe","trivella petrolifera","bomba de petróleo"]],
[0xe9,0xeb,0,BUILDING_MASK_2x2,["parabolic antenna","parabole","Satellitenschüssel","antenna parabolica","antena parabólica"]],
[0xea,0xec,0,BUILDING_MASK_2x3,["solar panel","panneau solaire","Solaranlage","pannello solare","placa solar"]],
[0xeb,0xed,0,BUILDING_MASK_1x1,["wind turbine","éolienne","Windrad","turbina eolica","aerogenerador"]],
[0xec,0xee,0,BUILDING_MASK_2x2,["windmill","moulin à vent","Windmühle","mulino a vento","molino"]],
[0xed,0xef,0,BUILDING_MASK_2x2,["lighthouse","phare","Leuchtturm","faro","faro"]],
[0xee,0xf0,0,BUILDING_MASK_2x2,["tower","tour","Turm","torre","torre"]],
[0xef,0xf1,0,BUILDING_MASK_3x3,["Stonehenge","cromlech","Steinkreis","sito neolitico","círculo Stonehenge"]],
[0xf0,0xf2,0,BUILDING_MASK_1x1,["totem pole","totem","Totempfahl","totem","tótem"]],
[0xf1,0xf3,0,BUILDING_MASK_2x2,["moai statue","statue Moai","Moai-Statue","statua Moai","moái"]],
[0xf2,0xf4,0,BUILDING_MASK_3x3,["pyramid","pyramide","Pyramide","piramide","pirámide"]],
[0xf3,0xf5,0,BUILDING_MASK_2x3,["sphinx",,"Sphinx","sfinge","esfinge"]],
[0xf4,0xf6,0,BUILDING_MASK_2x2,["round topiary","topiaire en spirale","Buchsbaum-Rundturm","scultura arborea tonda","seto redondo"]],
[0xf5,0xf7,0,BUILDING_MASK_1x1,["square topiary","topiaire cube","Buchsbaum-Eckturm","scultura arborea quadr.","seto cuadrado"]],
[0xf6,0xf8,0,BUILDING_MASK_2x1,["tulip topiary","topiaire tulipe","Buchsbaumtulpe","scultura arborea fiore","seto tulipán"]],
[0xf7,0xf9,0,BUILDING_MASK_3x3,["flower clock","horloge florale","Blumenuhr","orologio floreale","reloj de flores"]],
[0xf8,0xfc,0,BUILDING_MASK_NONE,["(none)"]]
];



const PWPS_INGAME_LIST=[
	['default projects list'],
	['topiaries','topiaires','Buchsbaums','sculturas arboreas','setos'],
	['2 ?'],
	['3 ?'],
	BUILDINGS[20][4],
	BUILDINGS[21][4],
	['town hall renovation+flower clock'],
	['train station renovation'],
	BUILDINGS[103][4],
	BUILDINGS[106][4],
	BUILDINGS[102][4],
	BUILDINGS[129][4],
	BUILDINGS[123][4],
	BUILDINGS[114][4],
	BUILDINGS[100][4],
	BUILDINGS[120][4],
	["fairy-tale bridge","pont féérique","Märchenbrücke","ponte fiabesco","puente de cuento"],
	BUILDINGS[97][4],
	BUILDINGS[117][4],
	BUILDINGS[154][4],
	BUILDINGS[156][4],
	BUILDINGS[157][4],
	BUILDINGS[138][4],
	BUILDINGS[152][4],
	BUILDINGS[134][4],
	BUILDINGS[132][4],
	BUILDINGS[118][4],
	BUILDINGS[155][4],
	BUILDINGS[166][4],
	BUILDINGS[113][4],
	BUILDINGS[99][4],
	BUILDINGS[119][4],
	BUILDINGS[140][4],
	BUILDINGS[133][4],
	BUILDINGS[164][4],
	BUILDINGS[96][4],
	BUILDINGS[137][4],
	BUILDINGS[98][4],
	BUILDINGS[143][4],
	BUILDINGS[125][4],
	BUILDINGS[122][4],
	BUILDINGS[110][4],
	BUILDINGS[107][4],
	BUILDINGS[128][4],
	BUILDINGS[111][4],
	BUILDINGS[105][4],
	BUILDINGS[126][4],
	BUILDINGS[136][4],
	BUILDINGS[104][4],
	BUILDINGS[130][4],
	BUILDINGS[127][4],
	BUILDINGS[162][4],
	BUILDINGS[95][4],
	BUILDINGS[145][4],
	BUILDINGS[158][4],
	BUILDINGS[159][4],
	["wooden bridge","pont japonais","Holzbrücke","ponte di legno","puente de madera"],
	BUILDINGS[131][4],
	BUILDINGS[139][4],
	BUILDINGS[141][4],
	BUILDINGS[160][4],
	BUILDINGS[115][4],
	BUILDINGS[101][4],
	BUILDINGS[121][4],
	BUILDINGS[171][4],
	BUILDINGS[168][4],
	BUILDINGS[161][4],
	BUILDINGS[169][4],
	BUILDINGS[167][4],
	BUILDINGS[170][4],
	BUILDINGS[151][4],
	BUILDINGS[153][4],
	["police station","poste police","Polizeizentrale","staz. di polizia","comisaría"],
	["suspension bridge","pont suspendu","Hängebrücke","ponte sospeso","puente colgante"],
	["brick bridge","pont en brique","Backsteinbrücke","ponte di mattoni","puente de ladrillo"],
	["modern bridge","pont moderne","Betonbrücke","ponte moderno","puente moderno"],
	["cobblestone bridge","pont en pierre","Steinbrücke","ponte di pietra","puente de piedra"],
	BUILDINGS[163][4],
	BUILDINGS[148][4],
	BUILDINGS[150][4]
];