/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.zip;

import com.android.apksig.internal.asn1.ber.BerDataValue;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.qihoo.jiagu.g.d.i;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class ZipUtils {
    public static final short GP_FLAG_EFS = 2048;
    private static final int g = 16;
    public static final short GP_FLAG_DATA_DESCRIPTOR_USED = 8;
    private static final int a = 65535;
    public static final short COMPRESSION_METHOD_DEFLATED = 8;
    private static final int I = 22;
    private static final int h = 101010256;
    private static final int E = 10;
    public static final short COMPRESSION_METHOD_STORED = 0;
    private static final int b = 20;
    private static final int ALLATORIxDEMO = 12;

    private static /* synthetic */ Pair<ByteBuffer, Long> ALLATORIxDEMO(DataSource a2, int a32) throws IOException {
        if (a32 < 0 || a32 > 65535) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, i.ALLATORIxDEMO("!l4N#`!h\"y\u001fd6hv-")).append(a32).toString());
        }
        long l2 = a2.size();
        if (l2 < 22L) {
            return null;
        }
        a32 = (int)Math.min((long)a32, l2 - 22L);
        a32 = 22 + a32;
        ByteBuffer a32 = a2.getByteBuffer(l2 -= (long)a32, a32);
        a32.order(ByteOrder.LITTLE_ENDIAN);
        int n2 = ZipUtils.ALLATORIxDEMO(a32);
        if (n2 == -1) {
            return null;
        }
        a32.position(n2);
        a32 = a32.slice();
        a32.order(ByteOrder.LITTLE_ENDIAN);
        return Pair.of(a32, l2 + (long)n2);
    }

    public static int getUnsignedInt16(ByteBuffer a2) {
        return a2.getShort() & 0xFFFF;
    }

    static void ALLATORIxDEMO(ByteBuffer a2, long a3) {
        if (a3 < 0L || a3 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, BerDataValue.ALLATORIxDEMO("\u0000\u0005\u001b\u0018F^U\u001a\u0014\u0000\u0000\tU\u0003\u0013L\u001a\u0019\u0001L\u0007\r\u001b\u000b\u0010VU")).append(a3).toString());
        }
        a2.putInt((int)a3);
    }

    static long ALLATORIxDEMO(ByteBuffer a2, int a3) {
        return (long)a2.getInt(a3) & 0xFFFFFFFFL;
    }

    public static Pair<ByteBuffer, Long> findZipEndOfCentralDirectoryRecord(DataSource a2) throws IOException {
        if (a2.size() < 22L) {
            return null;
        }
        Pair<ByteBuffer, Long> pair = ZipUtils.ALLATORIxDEMO(a2, 0);
        if (pair != null) {
            return pair;
        }
        return ZipUtils.ALLATORIxDEMO(a2, 65535);
    }

    public static DeflateResult deflate(ByteBuffer a2) {
        Deflater deflater;
        int n2;
        byte[] byArray;
        ByteBuffer byteBuffer = a2;
        int n3 = byteBuffer.remaining();
        if (byteBuffer.hasArray()) {
            ByteBuffer byteBuffer2 = a2;
            byArray = byteBuffer2.array();
            ByteBuffer byteBuffer3 = a2;
            n2 = byteBuffer2.arrayOffset() + byteBuffer3.position();
            byteBuffer2.position(byteBuffer3.limit());
        } else {
            byArray = new byte[n3];
            n2 = 0;
            a2.get(byArray);
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, n2, n3);
        long l2 = cRC32.getValue();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Deflater deflater2 = deflater = new Deflater(9, true);
        Deflater deflater3 = deflater2;
        deflater2.setInput(byArray, n2, n3);
        deflater2.finish();
        byArray = new byte[65536];
        while (!deflater3.finished()) {
            Deflater deflater4 = deflater;
            deflater3 = deflater4;
            n2 = deflater4.deflate(byArray);
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return new DeflateResult(n3, l2, byteArrayOutputStream.toByteArray());
    }

    public static void putUnsignedInt16(ByteBuffer a2, int a3) {
        if (a3 < 0 || a3 > 65535) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, i.ALLATORIxDEMO("x%c8<z-:l x)-#klb9yl\u007f-c+hv-")).append(a3).toString());
        }
        a2.putShort((short)a3);
    }

    public static int getUnsignedInt16(ByteBuffer a2, int a3) {
        return a2.getShort(a3) & 0xFFFF;
    }

    public static void setZipEocdCentralDirectoryOffset(ByteBuffer a2, long a3) {
        ByteBuffer byteBuffer = a2;
        ZipUtils.ALLATORIxDEMO(byteBuffer);
        ZipUtils.ALLATORIxDEMO(byteBuffer, byteBuffer.position() + 16, a3);
    }

    public static long getZipEocdCentralDirectoryOffset(ByteBuffer a2) {
        ByteBuffer byteBuffer = a2;
        ZipUtils.ALLATORIxDEMO(byteBuffer);
        return ZipUtils.ALLATORIxDEMO(byteBuffer, byteBuffer.position() + 16);
    }

    public static int getZipEocdCentralDirectoryTotalRecordCount(ByteBuffer a2) {
        ByteBuffer byteBuffer = a2;
        ZipUtils.ALLATORIxDEMO(byteBuffer);
        return ZipUtils.getUnsignedInt16(byteBuffer, byteBuffer.position() + 10);
    }

    public static long getZipEocdCentralDirectorySizeBytes(ByteBuffer a2) {
        ByteBuffer byteBuffer = a2;
        ZipUtils.ALLATORIxDEMO(byteBuffer);
        return ZipUtils.ALLATORIxDEMO(byteBuffer, byteBuffer.position() + 12);
    }

    private static /* synthetic */ int ALLATORIxDEMO(ByteBuffer a2) {
        int n2;
        ByteBuffer byteBuffer = a2;
        ZipUtils.ALLATORIxDEMO(byteBuffer);
        int n3 = byteBuffer.capacity();
        if (n3 < 22) {
            return -1;
        }
        int n4 = Math.min(n3 - 22, 65535);
        n3 -= 22;
        int n5 = n2 = 0;
        while (n5 <= n4) {
            int n6 = n3 - n2;
            if (a2.getInt(n6) == 101010256 && ZipUtils.getUnsignedInt16(a2, n6 + 20) == n2) {
                return n6;
            }
            n5 = ++n2;
        }
        return -1;
    }

    static void ALLATORIxDEMO(ByteBuffer a2, int a3, long a4) {
        if (a4 < 0L || a4 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, BerDataValue.ALLATORIxDEMO("\u0000\u0005\u001b\u0018F^U\u001a\u0014\u0000\u0000\tU\u0003\u0013L\u001a\u0019\u0001L\u0007\r\u001b\u000b\u0010VU")).append(a4).toString());
        }
        a2.putInt(a3, (int)a4);
    }

    static void ALLATORIxDEMO(ByteBuffer a2, int a3, int a4) {
        if (a4 < 0 || a4 > 65535) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, i.ALLATORIxDEMO("x%c8<z-:l x)-#klb9yl\u007f-c+hv-")).append(a4).toString());
        }
        a2.putShort(a3, (short)a4);
    }

    public static String ALLATORIxDEMO(String a2) {
        int n2 = a2.length();
        int n3 = n2 - 1;
        char[] cArray = new char[n2];
        int n4 = (2 ^ 5) << 3 ^ 3;
        int cfr_ignored_0 = (3 ^ 5) << 4 ^ (2 ^ 5) << 1;
        int n5 = n3;
        int n6 = (3 ^ 5) << 4 ^ 3 << 1;
        while (n5 >= 0) {
            int n7 = n3--;
            cArray[n7] = (char)(a2.charAt(n7) ^ n6);
            if (n3 < 0) break;
            int n8 = n3--;
            cArray[n8] = (char)(a2.charAt(n8) ^ n4);
            n5 = n3;
        }
        return new String(cArray);
    }

    private /* synthetic */ ZipUtils() {
        ZipUtils a2;
    }

    static void ALLATORIxDEMO(ByteBuffer a2) {
        if (a2.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException(BerDataValue.ALLATORIxDEMO("7\u0015\u0001\t7\u0019\u0013\n\u0010\u001eU\u000e\f\u0018\u0010L\u001a\u001e\u0011\t\u0007L\u0018\u0019\u0006\u0018U\u000e\u0010L\u0019\u0005\u0001\u0018\u0019\tU\t\u001b\b\u001c\r\u001b"));
        }
    }

    static long ALLATORIxDEMO(ByteBuffer a2) {
        return (long)a2.getInt() & 0xFFFFFFFFL;
    }

    public static class DeflateResult {
        public final long inputCrc32;
        public final int inputSizeBytes;
        public final byte[] output;

        public DeflateResult(int a2, long a3, byte[] a4) {
            DeflateResult a5;
            DeflateResult deflateResult = a5;
            a5.inputSizeBytes = a2;
            deflateResult.inputCrc32 = a3;
            deflateResult.output = a4;
        }
    }
}

