/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.asn1.ber;

import com.android.apksig.internal.asn1.Asn1EncodingException;
import com.android.apksig.internal.asn1.Asn1TagClass;
import com.android.apksig.internal.asn1.Asn1Type;
import com.qihoo.jiagu.k.w;

public abstract class BerEncoding {
    public static final int TAG_NUMBER_INTEGER = 2;
    public static final int TAG_NUMBER_NULL = 5;
    public static final int TAG_NUMBER_SEQUENCE = 16;
    public static final int TAG_CLASS_PRIVATE = 3;
    public static final int TAG_CLASS_UNIVERSAL = 0;
    public static final int ID_FLAG_CONSTRUCTED_ENCODING = 32;
    public static final int TAG_NUMBER_OCTET_STRING = 4;
    public static final int TAG_NUMBER_SET = 17;
    public static final int TAG_CLASS_CONTEXT_SPECIFIC = 2;
    public static final int TAG_NUMBER_OBJECT_IDENTIFIER = 6;
    public static final int TAG_CLASS_APPLICATION = 1;

    public static byte setTagClass(byte a2, int a3) {
        return (byte)(a2 & 0x3F | a3 << 6);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String tagNumberToString(int a2) {
        switch (a2) {
            case 2: {
                return w.ALLATORIxDEMO("orryayt");
            }
            case 4: {
                return Asn1EncodingException.ALLATORIxDEMO("s/h)hLo8n%r+");
            }
            case 5: {
                return w.ALLATORIxDEMO("rspj");
            }
            case 6: {
                return Asn1EncodingException.ALLATORIxDEMO("#~&y/hLu(y\"h%z%y>");
            }
            case 16: {
                return w.ALLATORIxDEMO("ocmsyh\u007fc");
            }
            case 17: {
                return Asn1EncodingException.ALLATORIxDEMO("?y8");
            }
        }
        return new StringBuilder().insert(0, w.ALLATORIxDEMO("\f^")).append(Integer.toHexString(a2)).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getTagNumber(Asn1Type a2) {
        switch (a2) {
            case INTEGER: {
                return 2;
            }
            case OBJECT_IDENTIFIER: {
                return 6;
            }
            case OCTET_STRING: {
                return 4;
            }
            case SET_OF: {
                return 17;
            }
            case SEQUENCE: 
            case SEQUENCE_OF: {
                return 16;
            }
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, Asn1EncodingException.ALLATORIxDEMO("9R\u001fI\u001cL\u0003N\u0018Y\b\u001c\b]\u0018]LH\u0015L\t\u0006L")).append((Object)a2).toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getTagClass(Asn1TagClass a2) {
        switch (a2) {
            case APPLICATION: {
                return 1;
            }
            case CONTEXT_SPECIFIC: {
                return 2;
            }
            case PRIVATE: {
                return 3;
            }
            case UNIVERSAL: {
                return 0;
            }
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, w.ALLATORIxDEMO("sRUIVLINRYB\u001cR]A\u001cEPGOU\u0006\u0006")).append((Object)a2).toString());
    }

    public static int getTagNumber(byte a2) {
        return a2 & 0x1F;
    }

    private /* synthetic */ BerEncoding() {
        BerEncoding a2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String tagClassToString(int a2) {
        switch (a2) {
            case 1: {
                return Asn1EncodingException.ALLATORIxDEMO("-l<p%\u007f-h%s\"");
            }
            case 2: {
                return "";
            }
            case 3: {
                return w.ALLATORIxDEMO("vnojghc");
            }
            case 0: {
                return Asn1EncodingException.ALLATORIxDEMO("9r%j)n?} ");
            }
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, w.ALLATORIxDEMO("iHOSLVSTHCX\u0006H_LC\u001cEPGOU\u0006\u0006")).append(a2).toString());
    }

    public static byte setTagNumber(byte a2, int a3) {
        return (byte)(a2 & 0xFFFFFFE0 | a3);
    }

    public static String ALLATORIxDEMO(String a2) {
        int n2 = a2.length();
        int n3 = n2 - 1;
        char[] cArray = new char[n2];
        int n4 = (2 ^ 5) << 4 ^ 2 << 1;
        int cfr_ignored_0 = 3 << 3;
        int n5 = n3;
        int n6 = 1 << 3 ^ (2 ^ 5);
        while (n5 >= 0) {
            int n7 = n3--;
            cArray[n7] = (char)(a2.charAt(n7) ^ n6);
            if (n3 < 0) break;
            int n8 = n3--;
            cArray[n8] = (char)(a2.charAt(n8) ^ n4);
            n5 = n3;
        }
        return new String(cArray);
    }

    public static int getTagClass(byte a2) {
        return (a2 & 0xFF) >> 6;
    }

    public static boolean isConstructed(byte a2) {
        return (a2 & 0x20) != 0;
    }

    public static String tagClassAndNumberToString(int a2, int a32) {
        String string = BerEncoding.tagClassToString(a2);
        String a32 = BerEncoding.tagNumberToString(a32);
        if (string.isEmpty()) {
            return a32;
        }
        return new StringBuilder().insert(0, string).append(Asn1EncodingException.ALLATORIxDEMO("L")).append(a32).toString();
    }
}

