/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.asn1;

import com.android.apksig.internal.asn1.Asn1Class;
import com.android.apksig.internal.asn1.Asn1DecodingException;
import com.android.apksig.internal.asn1.Asn1Field;
import com.android.apksig.internal.asn1.Asn1OpaqueObject;
import com.android.apksig.internal.asn1.Asn1TagClass;
import com.android.apksig.internal.asn1.Asn1Tagging;
import com.android.apksig.internal.asn1.Asn1Type;
import com.android.apksig.internal.asn1.ber.BerDataValue;
import com.android.apksig.internal.asn1.ber.BerDataValueFormatException;
import com.android.apksig.internal.asn1.ber.BerDataValueReader;
import com.android.apksig.internal.asn1.ber.BerEncoding;
import com.android.apksig.internal.asn1.ber.ByteBufferBerDataValueReader;
import com.android.apksig.internal.util.ByteBufferUtils;
import com.qihoo.jiagu.dao.DaoConfig;
import com.qihoo.jiagu.k.K;
import com.qihoo.jiagu.l.a.A;
import com.qihoo.jiagu.m.i;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Asn1BerParser {
    private static /* synthetic */ long j(ByteBuffer a2) throws Asn1DecodingException {
        BigInteger bigInteger = Asn1BerParser.ALLATORIxDEMO(a2);
        try {
            return bigInteger.longValueExact();
        }
        catch (ArithmeticException arithmeticException) {
            Object[] objectArray = new Object[1];
            objectArray[0] = bigInteger;
            throw new Asn1DecodingException(String.format(A.ALLATORIxDEMO("\u001bb\u0006i\u0015i\u0000\f1M<B=XrN7\f I\"^7_7B&I6\f3_r@=B5\u0016r\tc\b6\fz\u001c*\tc\b*\u0005"), objectArray), arithmeticException);
        }
    }

    public static <T> T parse(ByteBuffer a2, Class<T> a3) throws Asn1DecodingException {
        BerDataValue berDataValue;
        try {
            berDataValue = new ByteBufferBerDataValueReader(a2).readDataValue();
        }
        catch (BerDataValueFormatException berDataValueFormatException) {
            throw new Asn1DecodingException(K.ALLATORIxDEMO("\u0007\u000f(\u0002$\na\u001a.N%\u000b\"\u0001%\u000ba\u001a.\u001el\u0002$\u0018$\u0002a\n \u001a N7\u000f-\u001b$"), berDataValueFormatException);
        }
        if (berDataValue == null) {
            throw new Asn1DecodingException(A.ALLATORIxDEMO("i?\\&UrE<\\'X"));
        }
        return Asn1BerParser.ALLATORIxDEMO(berDataValue, a3);
    }

    private static /* synthetic */ int F(ByteBuffer a2) throws Asn1DecodingException {
        BigInteger bigInteger = Asn1BerParser.ALLATORIxDEMO(a2);
        try {
            return bigInteger.intValueExact();
        }
        catch (ArithmeticException arithmeticException) {
            Object[] objectArray = new Object[1];
            objectArray[0] = bigInteger;
            throw new Asn1DecodingException(String.format(K.ALLATORIxDEMO("\b \u0015+\u0006+\u0013N\"\u000f/\u0000.\u001aa\f$N3\u000b1\u001c$\u001d$\u00005\u000b%N \u001da\u0007/\u001a{Nd_e\naFq\u0016d_e\u0016h"), objectArray), arithmeticException);
        }
    }

    private static /* synthetic */ Class<?> F(Field a2) throws Asn1DecodingException, ClassNotFoundException {
        int n2;
        String string = a2.getGenericType().getTypeName();
        int n3 = string.indexOf(60);
        if (n3 == -1) {
            throw new Asn1DecodingException(new StringBuilder().insert(0, A.ALLATORIxDEMO("\u001cC&\f3\f1C<X3E<I \f&U\"Ih\f")).append(a2.getGenericType()).toString());
        }
        if ((n2 = string.indexOf(62, ++n3)) == -1) {
            throw new Asn1DecodingException(new StringBuilder().insert(0, K.ALLATORIxDEMO(" .\u001aa\u000fa\r.\u00005\u000f(\u0000$\u001ca\u001a8\u001e$Ta")).append(a2.getGenericType()).toString());
        }
        return Class.forName(string.substring(n3, n2));
    }

    private static /* synthetic */ List<AnnotatedField> ALLATORIxDEMO(Class<?> a2) throws Asn1DecodingException {
        int n2;
        Field[] fieldArray = a2.getDeclaredFields();
        ArrayList<AnnotatedField> arrayList = new ArrayList<AnnotatedField>(fieldArray.length);
        int n3 = fieldArray.length;
        int n4 = n2 = 0;
        while (n4 < n3) {
            Field field = fieldArray[n2];
            Object object = field.getDeclaredAnnotation(Asn1Field.class);
            if (object != null) {
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new Asn1DecodingException(new StringBuilder().insert(0, Asn1Field.class.getName()).append(A.ALLATORIxDEMO("\f'_7HrC<\f3\f!X3X;OrJ;I>Hh\f")).append(a2.getName()).append(K.ALLATORIxDEMO("o")).append(field.getName()).toString());
                }
                try {
                    object = new AnnotatedField(field, (Asn1Field)object);
                }
                catch (Asn1DecodingException asn1DecodingException) {
                    throw new Asn1DecodingException(new StringBuilder().insert(0, A.ALLATORIxDEMO("\u001bB$M>E6\f\u0013\u007f\u001c\u0002c\f3B<C&M&E=BrC<\f")).append(a2.getName()).append(K.ALLATORIxDEMO("o")).append(field.getName()).toString(), asn1DecodingException);
                }
                arrayList.add((AnnotatedField)object);
            }
            n4 = ++n2;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static /* synthetic */ Asn1Type ALLATORIxDEMO(Class<?> a2) throws Asn1DecodingException {
        Asn1Class asn1Class = a2.getDeclaredAnnotation(Asn1Class.class);
        if (asn1Class == null) {
            throw new Asn1DecodingException(new StringBuilder().insert(0, a2.getName()).append(A.ALLATORIxDEMO("\f;_rB=XrM<B=X3X7Hr[;X:\f")).append(Asn1Class.class.getName()).toString());
        }
        switch (asn1Class.type()) {
            case CHOICE: 
            case SEQUENCE: {
                return asn1Class.type();
            }
        }
        throw new Asn1DecodingException(new StringBuilder().insert(0, K.ALLATORIxDEMO("\u0014\u00002\u001b1\u001e.\u001c5\u000b%N\u0000=\u000f@pN\"\u0001/\u001a \u0007/\u000b3N \u0000/\u00015\u000f5\u0007.\u0000a\u001a8\u001e$Ta")).append((Object)asn1Class.type()).toString());
    }

    private /* synthetic */ Asn1BerParser() {
        Asn1BerParser a2;
    }

    private static /* synthetic */ <T> T j(BerDataValue a2, Class<T> a3) throws Asn1DecodingException {
        T t2;
        Object object;
        int n2;
        List<AnnotatedField> list = Asn1BerParser.ALLATORIxDEMO(a3);
        if (list.isEmpty()) {
            throw new Asn1DecodingException(new StringBuilder().insert(0, A.ALLATORIxDEMO("b=\f4E7@6_rM<B=X3X7Hr[;X:\f")).append(Asn1Field.class.getName()).append(K.ALLATORIxDEMO("a\u0007/N\u0002&\u000e'\u0002+a\r-\u000f2\u001da")).append(a3.getName()).toString());
        }
        int n3 = n2 = 0;
        while (n3 < list.size() - 1) {
            object = list.get(n2);
            int n4 = ((AnnotatedField)object).getBerTagNumber();
            int n5 = ((AnnotatedField)object).getBerTagClass();
            int n6 = n2 + 1;
            while (n6 < list.size()) {
                int n7;
                AnnotatedField annotatedField = list.get(n7);
                int n8 = annotatedField.getBerTagNumber();
                int n9 = annotatedField.getBerTagClass();
                if (n4 == n8 && n5 == n9) {
                    throw new Asn1DecodingException(new StringBuilder().insert(0, A.ALLATORIxDEMO("o\u001ac\u001bo\u0017\f4E7@6_rM IrE<H;_&E<K'E!D3N>IrN7O3Y!IrX:I+\f:M$IrX:Ir_3A7\f&M5\f1@3_!\f3B6\f<Y?N7^h\f")).append(a3.getName()).append(K.ALLATORIxDEMO("o")).append(((AnnotatedField)object).getField().getName()).append(A.ALLATORIxDEMO("rM<Hr\u0002")).append(annotatedField.getField().getName()).toString());
                }
                n6 = ++n7;
            }
            n3 = ++n2;
        }
        try {
            t2 = a3.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            throw new Asn1DecodingException(new StringBuilder().insert(0, K.ALLATORIxDEMO("( \u0007-\u000b%N5\u0001a\u0007/\u001d5\u000f/\u001a(\u000f5\u000ba")).append(a3.getName()).toString(), exception);
        }
        Object object2 = object = list.iterator();
        while (object2.hasNext()) {
            AnnotatedField annotatedField = (AnnotatedField)object.next();
            try {
                annotatedField.setValueFrom(a2, t2);
                return t2;
            }
            catch (Asn1UnexpectedTagException asn1UnexpectedTagException) {
                object2 = object;
            }
        }
        throw new Asn1DecodingException(new StringBuilder().insert(0, A.ALLATORIxDEMO("b=\f=\\&E=B!\f=Jro\u001ac\u001bo\u0017\f")).append(a3.getName()).append(K.ALLATORIxDEMO("N,\u000f5\r)\u000b%")).toString());
    }

    private static /* synthetic */ String ALLATORIxDEMO(ByteBuffer a2) throws Asn1DecodingException {
        if (!a2.hasRemaining()) {
            throw new Asn1DecodingException(A.ALLATORIxDEMO("i?\\&Urc\u0010f\u0017o\u0006\f\u001bh\u0017b\u0006e\u0014e\u0017~"));
        }
        ByteBuffer byteBuffer = a2;
        ByteBuffer byteBuffer2 = byteBuffer;
        long l2 = Asn1BerParser.ALLATORIxDEMO(byteBuffer);
        int n2 = (int)Math.min(l2 / 40L, 2L);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Long.toString(n2)).append('.').append(Long.toString(l2 -= (long)(n2 * 40)));
        while (byteBuffer2.hasRemaining()) {
            ByteBuffer byteBuffer3 = a2;
            byteBuffer2 = byteBuffer3;
            l2 = Asn1BerParser.ALLATORIxDEMO(byteBuffer3);
            stringBuilder.append('.').append(Long.toString(l2));
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ <T> T F(BerDataValue a4, Class<T> a5) throws Asn1DecodingException {
        Object object;
        AnnotatedField annotatedField;
        List<AnnotatedField> list = Asn1BerParser.ALLATORIxDEMO(a5);
        Collections.sort(list, (a2, a3) -> a2.getAnnotation().index() - a3.getAnnotation().index());
        if (list.size() > 1) {
            Iterator<AnnotatedField> iterator;
            annotatedField = null;
            Iterator<AnnotatedField> iterator2 = iterator = list.iterator();
            while (iterator2.hasNext()) {
                object = iterator.next();
                if (annotatedField != null && annotatedField.getAnnotation().index() == ((AnnotatedField)object).getAnnotation().index()) {
                    throw new Asn1DecodingException(new StringBuilder().insert(0, K.ALLATORIxDEMO("((\u000b-\n2N)\u000f7\u000ba\u001a)\u000ba\u001d \u0003$N(\u0000%\u000b9Ta")).append(a5.getName()).append(A.ALLATORIxDEMO("\u0002")).append(annotatedField.getField().getName()).append(K.ALLATORIxDEMO("N \u0000%No")).append(((AnnotatedField)object).getField().getName()).toString());
                }
                annotatedField = object;
                iterator2 = iterator;
            }
        }
        try {
            annotatedField = (AnnotatedField)a5.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            throw new Asn1DecodingException(new StringBuilder().insert(0, A.ALLATORIxDEMO("\u0014M;@7HrX=\f;B!X3B&E3X7\f")).append(a5.getName()).toString(), exception);
        }
        int n2 = 0;
        object = a4.contentsReader();
        block9: while (n2 < list.size()) {
            BerDataValue berDataValue;
            try {
                berDataValue = object.readDataValue();
            }
            catch (BerDataValueFormatException berDataValueFormatException) {
                throw new Asn1DecodingException(K.ALLATORIxDEMO("# \u0002'\u00013\u0003$\na\n \u001a N7\u000f-\u001b$"), berDataValueFormatException);
            }
            if (berDataValue == null) {
                return (T)annotatedField;
            }
            int n3 = n2;
            while (n3 < list.size()) {
                int n4;
                block15: {
                    AnnotatedField annotatedField2 = list.get(n4);
                    try {
                        if (annotatedField2.isOptional()) {
                            try {
                                annotatedField2.setValueFrom(berDataValue, annotatedField);
                                n2 = n4 + 1;
                                continue block9;
                            }
                            catch (Asn1UnexpectedTagException asn1UnexpectedTagException) {
                                break block15;
                            }
                        }
                        annotatedField2.setValueFrom(berDataValue, annotatedField);
                        n2 = n4 + 1;
                        continue block9;
                    }
                    catch (Asn1DecodingException asn1DecodingException) {
                        throw new Asn1DecodingException(new StringBuilder().insert(0, A.ALLATORIxDEMO("\u0014M;@7HrX=\f\"M _7\f")).append(a5.getName()).append(K.ALLATORIxDEMO("o")).append(annotatedField2.getField().getName()).toString(), asn1DecodingException);
                    }
                }
                n3 = ++n4;
            }
        }
        return (T)annotatedField;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static /* synthetic */ <T> T ALLATORIxDEMO(BerDataValue a2, Class<T> a3) throws Asn1DecodingException {
        if (a2 == null) {
            throw new NullPointerException(A.ALLATORIxDEMO("O=B&M;B7^r\u0011o\f<Y>@"));
        }
        if (a3 == null) {
            throw new NullPointerException(K.ALLATORIxDEMO("\r.\u00005\u000f(\u0000$\u001c\u0002\u0002 \u001d2N|Sa\u00004\u0002-"));
        }
        Asn1Type asn1Type = Asn1BerParser.ALLATORIxDEMO(a3);
        switch (asn1Type) {
            case CHOICE: {
                return Asn1BerParser.j(a2, a3);
            }
            case SEQUENCE: {
                int n2 = 0;
                int n3 = BerEncoding.getTagNumber(asn1Type);
                if (a2.getTagClass() == n2 && a2.getTagNumber() == n3) {
                    return Asn1BerParser.F(a2, a3);
                }
                throw new Asn1UnexpectedTagException(new StringBuilder().insert(0, A.ALLATORIxDEMO("\u0007B7T\"I1X7HrH3X3\f$M>Y7\f I3HrM!\f")).append(a3.getName()).append(K.ALLATORIxDEMO("oN\u0004\u00161\u000b\"\u001a$\na")).append(BerEncoding.tagClassAndNumberToString(n2, n3)).append(A.ALLATORIxDEMO("~\f0Y&\f I3Hh\f")).append(BerEncoding.tagClassAndNumberToString(a2.getTagClass(), a2.getTagNumber())).toString());
            }
        }
        throw new Asn1DecodingException(new StringBuilder().insert(0, K.ALLATORIxDEMO("> \u001c2\u0007/\ta\r.\u00005\u000f(\u0000$\u001ca")).append((Object)asn1Type).append(A.ALLATORIxDEMO("rB=Xr_'\\\"C X7H")).toString());
    }

    private static /* synthetic */ BigInteger ALLATORIxDEMO(ByteBuffer a2) {
        if (!a2.hasRemaining()) {
            return BigInteger.ZERO;
        }
        return new BigInteger(ByteBufferUtils.toByteArray(a2));
    }

    public static <T> List<T> parseImplicitSetOf(ByteBuffer a2, Class<T> a3) throws Asn1DecodingException {
        BerDataValue berDataValue;
        try {
            berDataValue = new ByteBufferBerDataValueReader(a2).readDataValue();
        }
        catch (BerDataValueFormatException berDataValueFormatException) {
            throw new Asn1DecodingException(K.ALLATORIxDEMO("\u0007\u000f(\u0002$\na\u001a.N%\u000b\"\u0001%\u000ba\u001a.\u001el\u0002$\u0018$\u0002a\n \u001a N7\u000f-\u001b$"), berDataValueFormatException);
        }
        if (berDataValue == null) {
            throw new Asn1DecodingException(A.ALLATORIxDEMO("i?\\&UrE<\\'X"));
        }
        return Asn1BerParser.ALLATORIxDEMO(berDataValue, a3);
    }

    private static /* synthetic */ long ALLATORIxDEMO(ByteBuffer a2) throws Asn1DecodingException {
        if (!a2.hasRemaining()) {
            return 0L;
        }
        long l2 = 0L;
        while (a2.hasRemaining()) {
            if (l2 > 0xFFFFFFFFFFFFFFL) {
                throw new Asn1DecodingException(K.ALLATORIxDEMO("\u0003\u000f2\u000bl_sVa\u00004\u0003#\u000b3N5\u0001.N-\u000f3\t$"));
            }
            int n2 = a2.get() & 0xFF;
            l2 <<= 7;
            l2 |= (long)(n2 & 0x7F);
            if ((n2 & 0x80) != 0) continue;
            return l2;
        }
        throw new Asn1DecodingException(A.ALLATORIxDEMO("\u0006^'B1M&I6\f0M!I\u007f\u001d`\u0014rI<O=H7HrE<\\'Xh\f?E!_;B5\f&I A;B3X;B5\f0U&I~\f%E&DrD;K:I!XrN;XrB=Xr_7X"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ <T> List<T> ALLATORIxDEMO(BerDataValue a2, Class<T> a3) throws Asn1DecodingException {
        BerDataValueReader berDataValueReader;
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        BerDataValueReader berDataValueReader2 = a2.contentsReader();
        try {
            berDataValueReader = berDataValueReader2;
        }
        catch (BerDataValueFormatException berDataValueFormatException) {
            throw new Asn1DecodingException(K.ALLATORIxDEMO("# \u0002'\u00013\u0003$\na\n \u001a N7\u000f-\u001b$"), berDataValueFormatException);
        }
        BerDataValue berDataValue;
        while ((berDataValue = berDataValueReader.readDataValue()) != null) {
            ArrayList<ByteBuffer> arrayList2;
            Object object;
            if (ByteBuffer.class.equals(a3)) {
                object = berDataValue.getEncodedContents();
                arrayList2 = arrayList;
            } else if (Asn1OpaqueObject.class.equals(a3)) {
                object = new Asn1OpaqueObject(berDataValue.getEncoded());
                arrayList2 = arrayList;
            } else {
                object = Asn1BerParser.ALLATORIxDEMO(berDataValue, a3);
                arrayList2 = arrayList;
            }
            arrayList2.add((ByteBuffer)object);
            berDataValueReader = berDataValueReader2;
        }
        return arrayList;
    }

    private static final class BerToJavaConverter {
        private static final byte[] ALLATORIxDEMO = new byte[0];

        private /* synthetic */ BerToJavaConverter() {
            BerToJavaConverter a2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static void setFieldValue(Object a2, Field a3, Asn1Type a42, BerDataValue a5) throws Asn1DecodingException {
            try {
                switch (a42) {
                    case SET_OF: 
                    case SEQUENCE_OF: {
                        if (Asn1OpaqueObject.class.equals(a3.getType())) {
                            a3.set(a2, BerToJavaConverter.convert(a42, a5, a3.getType()));
                            return;
                        }
                        a3.set(a2, Asn1BerParser.ALLATORIxDEMO(a5, Asn1BerParser.F(a3)));
                        return;
                    }
                }
                a3.set(a2, BerToJavaConverter.convert(a42, a5, a3.getType()));
                return;
            }
            catch (ReflectiveOperationException a42) {
                throw new Asn1DecodingException(new StringBuilder().insert(0, ByteBufferUtils.ALLATORIxDEMO("x!W,[$\u001e4Q`M%J`H!R5[`Q&\u001e")).append(a2.getClass().getName()).append(a.a.a.i.i.ALLATORIxDEMO("p")).append(a3.getName()).toString(), a42);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public static <T> T convert(Asn1Type a2, BerDataValue a3, Class<T> a4) throws Asn1DecodingException {
            if (ByteBuffer.class.equals(a4)) {
                return (T)a3.getEncodedContents();
            }
            if (byte[].class.equals(a4)) {
                ByteBuffer byteBuffer = a3.getEncodedContents();
                if (!byteBuffer.hasRemaining()) {
                    return (T)ALLATORIxDEMO;
                }
                ByteBuffer byteBuffer2 = byteBuffer;
                byte[] byArray = new byte[byteBuffer2.remaining()];
                byteBuffer2.get(byArray);
                return (T)byArray;
            }
            if (Asn1OpaqueObject.class.equals(a4)) {
                return (T)new Asn1OpaqueObject(a3.getEncoded());
            }
            ByteBuffer byteBuffer = a3.getEncodedContents();
            switch (a2) {
                case INTEGER: {
                    if (Integer.TYPE.equals(a4) || Integer.class.equals(a4)) {
                        return (T)Integer.valueOf(Asn1BerParser.F(byteBuffer));
                    }
                    if (Long.TYPE.equals(a4) || Long.class.equals(a4)) {
                        return (T)Long.valueOf(Asn1BerParser.j(byteBuffer));
                    }
                    if (!BigInteger.class.equals(a4)) break;
                    return (T)Asn1BerParser.ALLATORIxDEMO(byteBuffer);
                }
                case OBJECT_IDENTIFIER: {
                    if (!String.class.equals(a4)) break;
                    return (T)Asn1BerParser.ALLATORIxDEMO(byteBuffer);
                }
                case SEQUENCE: {
                    Asn1Class asn1Class = a4.getDeclaredAnnotation(Asn1Class.class);
                    if (asn1Class == null || asn1Class.type() != Asn1Type.SEQUENCE) break;
                    return (T)Asn1BerParser.F(a3, a4);
                }
                case CHOICE: {
                    Asn1Class asn1Class = a4.getDeclaredAnnotation(Asn1Class.class);
                    if (asn1Class == null || asn1Class.type() != Asn1Type.CHOICE) break;
                    return (T)Asn1BerParser.j(a3, a4);
                }
            }
            throw new Asn1DecodingException(new StringBuilder().insert(0, ByteBufferUtils.ALLATORIxDEMO("\u0015P3K0N/L4[$\u001e#Q.H%L3W/Pz\u001e\u0001m\u000e\u0010q\u001e")).append((Object)a2).append(a.a.a.i.i.ALLATORIxDEMO("w*8~")).append(a4.getName()).toString());
        }
    }

    private static class Asn1UnexpectedTagException
    extends Asn1DecodingException {
        private static final long ALLATORIxDEMO = 1L;

        public Asn1UnexpectedTagException(String a2) {
            super(a2);
            Asn1UnexpectedTagException a3;
        }
    }

    private static final class AnnotatedField {
        private final int A;
        private final int g;
        private final Asn1Field a;
        private final Asn1TagClass I;
        private final boolean h;
        private final Field E;
        private final Asn1Type b;
        private final Asn1Tagging ALLATORIxDEMO;

        public boolean isOptional() {
            AnnotatedField a2;
            return a2.h;
        }

        public Field getField() {
            AnnotatedField a2;
            return a2.E;
        }

        public int getBerTagNumber() {
            AnnotatedField a2;
            return a2.A;
        }

        public Asn1Field getAnnotation() {
            AnnotatedField a2;
            return a2.a;
        }

        public void setValueFrom(BerDataValue a2, Object a3) throws Asn1DecodingException {
            Object object;
            AnnotatedField a4;
            int n2 = a2.getTagClass();
            if (a4.A != -1) {
                int n3 = a2.getTagNumber();
                if (n2 != a4.g || n3 != a4.A) {
                    AnnotatedField annotatedField = a4;
                    throw new Asn1UnexpectedTagException(new StringBuilder().insert(0, DaoConfig.ALLATORIxDEMO("\u0011\u0015\"T(\u001d6\u0019$\u0000&\u001ckT\u0000\f5\u0011&\u0000 \u0010\u007fT")).append(BerEncoding.tagClassAndNumberToString(annotatedField.g, annotatedField.A)).append(i.ALLATORIxDEMO("\u000es@&VsD<W=Fs")).append(BerEncoding.tagClassAndNumberToString(n2, n3)).toString());
                }
            } else if (n2 != a4.g) {
                throw new Asn1UnexpectedTagException(new StringBuilder().insert(0, DaoConfig.ALLATORIxDEMO("\u0011\u0015\"T(\u001d6\u0019$\u0000&\u001ckT\u0000\f5\u0011&\u0000 \u0010e\u0017)\u00156\u0007\u007fT")).append(BerEncoding.tagClassToString(a4.g)).append(i.ALLATORIxDEMO("\u000es@&VsD<W=Fs")).append(BerEncoding.tagClassToString(n2)).toString());
            }
            if (a4.ALLATORIxDEMO == Asn1Tagging.EXPLICIT) {
                try {
                    a2 = a2.contentsReader().readDataValue();
                    object = a3;
                }
                catch (BerDataValueFormatException berDataValueFormatException) {
                    throw new Asn1DecodingException(DaoConfig.ALLATORIxDEMO("\u0003\u0015,\u0018 \u0010e\u0000*T7\u0011$\u0010e\u0017*\u001a1\u0011+\u00006T*\u0012e1\u001d$\t=\u0006=\u0011T!\u00151\u0015e\u0002$\u00180\u0011"), berDataValueFormatException);
                }
            } else {
                object = a3;
            }
            AnnotatedField annotatedField = a4;
            BerToJavaConverter.setFieldValue(object, annotatedField.E, annotatedField.b, a2);
        }

        public int getBerTagClass() {
            AnnotatedField a2;
            return a2.g;
        }

        /*
         * Unable to fully structure code
         */
        public AnnotatedField(Field a, Asn1Field a) throws Asn1DecodingException {
            v0 = a;
            v1 = a;
            super();
            v1.E = a;
            v1.a = a;
            a.b = v0.type();
            var3_3 = v0.cls();
            if (var3_3 != Asn1TagClass.AUTOMATIC) ** GOTO lbl14
            if (a.tagNumber() != -1) {
                var3_3 = Asn1TagClass.CONTEXT_SPECIFIC;
                v2 = a;
            } else {
                var3_3 = Asn1TagClass.UNIVERSAL;
lbl14:
                // 2 sources

                v2 = a;
            }
            v2.I = var3_3;
            a.g = BerEncoding.getTagClass(a.I);
            if (a.tagNumber() != -1) {
                v3 = a;
                var3_4 = a.tagNumber();
            } else if (a.b == Asn1Type.CHOICE || a.b == Asn1Type.ANY) {
                var3_4 = -1;
                v3 = a;
            } else {
                v4 = a;
                v3 = v4;
                var3_4 = BerEncoding.getTagNumber(v4.b);
            }
            v3.A = var3_4;
            a.ALLATORIxDEMO = a.tagging();
            if ((a.ALLATORIxDEMO == Asn1Tagging.EXPLICIT || a.ALLATORIxDEMO == Asn1Tagging.IMPLICIT) && a.tagNumber() == -1) {
                throw new Asn1DecodingException(new StringBuilder().insert(0, i.ALLATORIxDEMO("v2EsL&O1G!\u0002>W Vs@6\u0002 R6A:D:G7\u0002$J6LsV2E4K=EsO<F6\u0002:Qs")).append((Object)a.ALLATORIxDEMO).toString());
            }
            a.h = a.optional();
        }
    }
}

