/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v3;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.zip.ZipFormatException;
import com.qihoo.jiagu.bean.scan.i;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class V3SigningCertificateLineage {
    private static final int b = 1;
    private static final int ALLATORIxDEMO = 1;

    public static String ALLATORIxDEMO(String a2) {
        int n2 = a2.length();
        int n3 = n2 - 1;
        char[] cArray = new char[n2];
        int n4 = 5 << 4 ^ (2 ^ 5);
        int cfr_ignored_0 = 4 << 4 ^ (2 ^ 5);
        int n5 = n3;
        int n6 = (3 ^ 5) << 4 ^ (2 << 2 ^ 3);
        while (n5 >= 0) {
            int n7 = n3--;
            cArray[n7] = (char)(a2.charAt(n7) ^ n6);
            if (n3 < 0) break;
            int n8 = n3--;
            cArray[n8] = (char)(a2.charAt(n8) ^ n4);
            n5 = n3;
        }
        return new String(cArray);
    }

    public static byte[] encodeSignedData(X509Certificate a2, int a3) {
        try {
            byte[] byArray = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(a2.getEncoded());
            ByteBuffer byteBuffer = ByteBuffer.allocate(4 + byArray.length);
            ByteBuffer byteBuffer2 = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer byteBuffer3 = byteBuffer;
            byteBuffer.put(byArray);
            byteBuffer3.putInt(a3);
            return ApkSigningBlockUtils.encodeAsLengthPrefixedElement(byteBuffer3.array());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new RuntimeException(ZipFormatException.ALLATORIxDEMO("\t\u0000&\r*\u0005o\u0015 A*\u000f,\u000e+\u0004o7|2&\u0006!\b!\u0006\f\u0004=\u0015&\u0007&\u0002.\u0015*-&\u000f*\u0000(\u0004o\u0002*\u0013;\b)\b,\u0000;\u0004"), certificateEncodingException);
        }
    }

    public V3SigningCertificateLineage() {
        V3SigningCertificateLineage a2;
    }

    public static byte[] encodeSigningCertificateNode(SigningCertificateNode a2) {
        int n2 = 0;
        if (a2.parentSigAlgorithm != null) {
            n2 = a2.parentSigAlgorithm.getId();
        }
        int n3 = 0;
        if (a2.sigAlgorithm != null) {
            n3 = a2.sigAlgorithm.getId();
        }
        SigningCertificateNode signingCertificateNode = a2;
        byte[] byArray = V3SigningCertificateLineage.encodeSignedData(signingCertificateNode.signingCert, n2);
        byte[] byArray2 = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(signingCertificateNode.signature);
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + 4 + 4 + byArray2.length);
        ByteBuffer byteBuffer2 = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer byteBuffer3 = byteBuffer;
        byteBuffer.put(byArray);
        byteBuffer3.putInt(a2.flags);
        byteBuffer.putInt(n3);
        byteBuffer.put(byArray2);
        return byteBuffer3.array();
    }

    public static List<SigningCertificateNode> readSigningCertificateLineage(ByteBuffer a2) throws IOException {
        CertificateFactory certificateFactory;
        ArrayList<SigningCertificateNode> arrayList = new ArrayList<SigningCertificateNode>();
        int n2 = 0;
        if (a2 == null || !a2.hasRemaining()) {
            return null;
        }
        ApkSigningBlockUtils.checkByteOrderLittleEndian(a2);
        try {
            certificateFactory = CertificateFactory.getInstance(i.ALLATORIxDEMO("r\"\u001f<\u0013"));
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException(ZipFormatException.ALLATORIxDEMO("'.\b#\u0004+A;\u000eo\u000e-\u0015.\b!A\u0017OzQvA\f\u0004=\u0015&\u0007&\u0002.\u0015*'.\u0002;\u000e=\u0018"), certificateException);
        }
        Certificate certificate = null;
        int n3 = 0;
        try {
            int n4 = a2.getInt();
            if (n4 != 1) {
                throw new IllegalArgumentException(i.ALLATORIxDEMO("IDoEhOh\n_CkDeDkiiXxCjCoKxO@CbOmMi\ndK\u007f\nm\nzO~YeEb\nhCjLiXiDx\nxBmD,KbS,Ej\n{BeId\n{O,K~O,K{K~O"));
            }
            HashSet<Certificate> hashSet = new HashSet<Certificate>();
            while (a2.hasRemaining()) {
                Object object;
                ++n2;
                ByteBuffer byteBuffer = ApkSigningBlockUtils.getLengthPrefixedSlice(a2);
                ByteBuffer byteBuffer2 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer);
                int n5 = byteBuffer.getInt();
                int n6 = byteBuffer.getInt();
                Object object2 = SignatureAlgorithm.findById(n3);
                byte[] byArray = ApkSigningBlockUtils.readLengthPrefixedByteArray(byteBuffer);
                if (certificate != null) {
                    object = object2.getJcaSignatureAlgorithmAndParams().getFirst();
                    AlgorithmParameterSpec algorithmParameterSpec = object2.getJcaSignatureAlgorithmAndParams().getSecond();
                    object2 = certificate.getPublicKey();
                    Signature signature = Signature.getInstance((String)object);
                    signature.initVerify((PublicKey)object2);
                    if (algorithmParameterSpec != null) {
                        signature.setParameter(algorithmParameterSpec);
                    }
                    signature.update(byteBuffer2);
                    if (!signature.verify(byArray)) {
                        throw new SecurityException(new StringBuilder().insert(0, ZipFormatException.ALLATORIxDEMO("4!\u0000-\r*A;\u000eo\u0017*\u0013&\u00076A<\b(\u000f.\u0015:\u0013*A \u0007o\u0002*\u0013;\b)\b,\u0000;\u0004oB")).append(n2).append(i.ALLATORIxDEMO("\nyYeDk\n")).append((String)object).append(ZipFormatException.ALLATORIxDEMO("o\u0016'\u0004!A9\u0004=\b)\u0018&\u000f(A\u0019R\u001c\b(\u000f&\u000f(\"*\u0013;\b)\b,\u0000;\u0004\u0003\b!\u0004.\u0006*A \u0003%\u0004,\u0015")).toString());
                    }
                }
                byteBuffer2.rewind();
                ByteBuffer byteBuffer3 = byteBuffer2;
                object = ApkSigningBlockUtils.readLengthPrefixedByteArray(byteBuffer3);
                int n7 = byteBuffer3.getInt();
                if (certificate != null && n3 != n7) {
                    throw new SecurityException(new StringBuilder().insert(0, i.ALLATORIxDEMO("yeMbCbM,K`McXe^dG,cH\naC\u007fGm^oB,LcX,IiXxCjCoKxO,\t")).append(byteBuffer).append(ZipFormatException.ALLATORIxDEMO("o\u0016'\u0004!A9\u0004=\b)\u0018&\u000f(A\u0019R\u001c\b(\u000f&\u000f(\"*\u0013;\b)\b,\u0000;\u0004\u0003\b!\u0004.\u0006*A \u0003%\u0004,\u0015")).toString());
                }
                certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream((byte[])object));
                if (hashSet.contains(certificate = new GuaranteedEncodedFormX509Certificate((X509Certificate)certificate, (byte[])object))) {
                    throw new SecurityException(new StringBuilder().insert(0, i.ALLATORIxDEMO("obIc_b^iXiN,NyZ`CoKxO,Ob^~CiY,Cb\n_CkDeDkiiXxCjCoKxO@CbOmMi\nm^,IiXxCjCoKxO,\t")).append(n2).append(ZipFormatException.ALLATORIxDEMO("aAo #\ro\u0012&\u0006!\b!\u0006o\u0002*\u0013;\b)\b,\u0000;\u0004<A<\t \u0014#\u0005o\u0003*A:\u000f&\u0010:\u0004")).toString());
                }
                hashSet.add(certificate);
                n3 = n6;
                arrayList.add(new SigningCertificateNode((X509Certificate)certificate, SignatureAlgorithm.findById(n7), SignatureAlgorithm.findById(n6), byArray, n5));
            }
        }
        catch (ApkFormatException | BufferUnderflowException exception) {
            throw new IOException(i.ALLATORIxDEMO("JKeFiN,^c\n|K~Yi\nZ\u0019_CkDeDkiiXxCjCoKxO@CbOmMi\ncHfOo^"), exception);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            throw new SecurityException(new StringBuilder().insert(0, ZipFormatException.ALLATORIxDEMO("'.\b#\u0004+A;\u000eo\u0017*\u0013&\u00076A<\b(\u000f.\u0015:\u0013*A \u0017*\u0013o\u0012&\u0006!\u0004+A+\u0000;\u0000o\u0007 \u0013o\u0002*\u0013;\b)\b,\u0000;\u0004oB")).append(n2).append(i.ALLATORIxDEMO(",]dOb\n|K~YeDk\nZ\u0019_CkDeDkiiXxCjCoKxO@CbOmMi\ncHfOo^")).toString(), generalSecurityException);
        }
        catch (CertificateException certificateException) {
            throw new SecurityException(new StringBuilder().insert(0, ZipFormatException.ALLATORIxDEMO("\t\u0000&\r*\u0005o\u0015 A+\u0004,\u000e+\u0004o\u0002*\u0013;\b)\b,\u0000;\u0004oB")).append(n2).append(i.ALLATORIxDEMO(",]dOb\n|K~YeDk\nZ\u0019_CkDeDkiiXxCjCoKxO@CbOmMi\ncHfOo^")).toString(), certificateException);
        }
        return arrayList;
    }

    public static byte[] encodeSigningCertificateLineage(List<SigningCertificateNode> a2) {
        Object object;
        Object object2 = new ArrayList<byte[]>();
        Object object3 = object = a2.iterator();
        while (object3.hasNext()) {
            SigningCertificateNode signingCertificateNode = object.next();
            object3 = object;
            object2.add((byte[])V3SigningCertificateLineage.encodeSigningCertificateNode(signingCertificateNode));
        }
        object = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(object2);
        int n2 = 4 + ((Object)object).length;
        object2 = ByteBuffer.allocate(n2);
        ByteBuffer byteBuffer = ((ByteBuffer)object2).order(ByteOrder.LITTLE_ENDIAN);
        Object object4 = object2;
        ((ByteBuffer)object2).putInt(1);
        ((ByteBuffer)object4).put((byte[])object);
        return ((ByteBuffer)object4).array();
    }

    public static class SigningCertificateNode {
        public final X509Certificate signingCert;
        public final SignatureAlgorithm parentSigAlgorithm;
        public SignatureAlgorithm sigAlgorithm;
        public final byte[] signature;
        public int flags;

        public SigningCertificateNode(X509Certificate a2, SignatureAlgorithm a3, SignatureAlgorithm a4, byte[] a5, int a6) {
            SigningCertificateNode a7;
            SigningCertificateNode signingCertificateNode = a7;
            SigningCertificateNode signingCertificateNode2 = a7;
            a7.signingCert = a2;
            signingCertificateNode2.parentSigAlgorithm = a3;
            signingCertificateNode2.sigAlgorithm = a4;
            signingCertificateNode.signature = a5;
            signingCertificateNode.flags = a6;
        }

        public boolean equals(Object a2) {
            SigningCertificateNode a3;
            if (a3 == a2) {
                return true;
            }
            if (!(a2 instanceof SigningCertificateNode)) {
                return false;
            }
            SigningCertificateNode signingCertificateNode = (SigningCertificateNode)a2;
            if (!a3.signingCert.equals(signingCertificateNode.signingCert)) {
                return false;
            }
            if (a3.parentSigAlgorithm != signingCertificateNode.parentSigAlgorithm) {
                return false;
            }
            if (a3.sigAlgorithm != signingCertificateNode.sigAlgorithm) {
                return false;
            }
            if (!Arrays.equals(a3.signature, signingCertificateNode.signature)) {
                return false;
            }
            return a3.flags == signingCertificateNode.flags;
        }
    }
}

