/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v3;

import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.qihoo.jiagu.bean.A;
import com.qihoo.jiagu.g.d.i;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class V3SchemeSigner {
    public static final int PROOF_OF_ROTATION_ATTR_ID = 1000370060;
    private static final int ALLATORIxDEMO = -262969152;

    private static /* synthetic */ byte[] ALLATORIxDEMO(ApkSigningBlockUtils.SignerConfig a2, Map<ContentDigestAlgorithm, byte[]> a3) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Object object;
        if (a2.certificates.isEmpty()) {
            throw new SignatureException(A.ALLATORIxDEMO("I\u0016'\u001ab\u000bs\u0010a\u0010d\u0018s\u001ctYd\u0016i\u001fn\u001er\u000bb\u001d'\u001fh\u000b'\nn\u001ei\u001cu"));
        }
        byte[] byArray = ApkSigningBlockUtils.encodePublicKey(a2.certificates.get(0).getPublicKey());
        V3SignatureSchemeBlock.SignedData signedData = new V3SignatureSchemeBlock.SignedData();
        try {
            signedData.certificates = ApkSigningBlockUtils.encodeCertificates(a2.certificates);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new SignatureException(i.ALLATORIxDEMO("K-d h(-8blh\"n#i)-/h>y%k%n-y)~"), certificateEncodingException);
        }
        ArrayList<Pair<Integer, byte[]>> arrayList = new ArrayList<Pair<Integer, byte[]>>(a2.signatureAlgorithms.size());
        Object object2 = object = a2.signatureAlgorithms.iterator();
        while (object2.hasNext()) {
            SignatureAlgorithm signatureAlgorithm = object.next();
            ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
            byte[] byArray2 = a3.get((Object)contentDigestAlgorithm);
            if (byArray2 == null) {
                throw new RuntimeException((Object)((Object)contentDigestAlgorithm) + A.ALLATORIxDEMO("Yd\u0016i\rb\u0017sYc\u0010`\u001ct\r'\u001fh\u000b'") + (Object)((Object)signatureAlgorithm) + i.ALLATORIxDEMO("-\"b8-/b!}9y)i"));
            }
            arrayList.add(Pair.of(signatureAlgorithm.getId(), byArray2));
            object2 = object;
        }
        V3SignatureSchemeBlock.SignedData signedData2 = signedData;
        ApkSigningBlockUtils.SignerConfig signerConfig = a2;
        V3SignatureSchemeBlock.SignedData signedData3 = signedData;
        signedData3.digests = arrayList;
        signedData3.minSdkVersion = a2.minSdkVersion;
        signedData2.maxSdkVersion = signerConfig.maxSdkVersion;
        signedData2.additionalAttributes = V3SchemeSigner.ALLATORIxDEMO(signerConfig);
        Object object3 = object = new V3SignatureSchemeBlock.Signer();
        Object object4 = object;
        ApkSigningBlockUtils.SignerConfig signerConfig2 = a2;
        ((V3SignatureSchemeBlock.Signer)object).signedData = V3SchemeSigner.ALLATORIxDEMO(signedData);
        ((V3SignatureSchemeBlock.Signer)object).minSdkVersion = signerConfig2.minSdkVersion;
        ((V3SignatureSchemeBlock.Signer)object4).maxSdkVersion = signerConfig2.maxSdkVersion;
        ((V3SignatureSchemeBlock.Signer)object4).publicKey = byArray;
        ((V3SignatureSchemeBlock.Signer)object3).signatures = ApkSigningBlockUtils.generateSignaturesOverData(a2, ((V3SignatureSchemeBlock.Signer)object3).signedData);
        return V3SchemeSigner.ALLATORIxDEMO((V3SignatureSchemeBlock.Signer)object3);
    }

    private static /* synthetic */ byte[] ALLATORIxDEMO(V3SignatureSchemeBlock.SignedData a2) {
        V3SignatureSchemeBlock.SignedData signedData = a2;
        byte[] byArray = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(signedData.digests));
        byte[] byArray2 = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(signedData.certificates));
        byte[] byArray3 = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(signedData.additionalAttributes);
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + byArray2.length + 4 + 4 + byArray3.length);
        ByteBuffer byteBuffer2 = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer byteBuffer3 = byteBuffer;
        byteBuffer.put(byArray);
        byteBuffer3.put(byArray2);
        byteBuffer.putInt(a2.minSdkVersion);
        byteBuffer.putInt(a2.maxSdkVersion);
        byteBuffer.put(byArray3);
        return byteBuffer3.array();
    }

    private static /* synthetic */ Pair<byte[], Integer> ALLATORIxDEMO(List<ApkSigningBlockUtils.SignerConfig> a2, Map<ContentDigestAlgorithm, byte[]> a3) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Iterator<ApkSigningBlockUtils.SignerConfig> iterator;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(a2.size());
        int n2 = 0;
        Iterator<ApkSigningBlockUtils.SignerConfig> iterator2 = iterator = a2.iterator();
        while (iterator2.hasNext()) {
            ++n2;
            Object object = iterator.next();
            try {
                object = V3SchemeSigner.ALLATORIxDEMO((ApkSigningBlockUtils.SignerConfig)object, a3);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeyException(new StringBuilder().insert(0, A.ALLATORIxDEMO("*n\u001ei\u001cuY$")).append(n2).append(i.ALLATORIxDEMO("-*l%a)i")).toString(), invalidKeyException);
            }
            catch (SignatureException signatureException) {
                throw new SignatureException(new StringBuilder().insert(0, A.ALLATORIxDEMO("*n\u001ei\u001cuY$")).append(n2).append(i.ALLATORIxDEMO("-*l%a)i")).toString(), signatureException);
            }
            arrayList.add((byte[])object);
            iterator2 = iterator;
        }
        byte[][] byArrayArray = new byte[1][];
        byArrayArray[0] = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(arrayList);
        return Pair.of(ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(byArrayArray), -262969152);
    }

    private /* synthetic */ V3SchemeSigner() {
        V3SchemeSigner a2;
    }

    public static List<SignatureAlgorithm> getSuggestedSignatureAlgorithms(PublicKey a2, int a32, boolean a4) throws InvalidKeyException {
        String a32 = a2.getAlgorithm();
        if (A.ALLATORIxDEMO("U*F").equalsIgnoreCase(a32)) {
            int n2 = ((RSAKey)((Object)a2)).getModulus().bitLength();
            if (n2 <= 3072) {
                ArrayList<SignatureAlgorithm> arrayList = new ArrayList<SignatureAlgorithm>();
                arrayList.add(SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA256);
                if (a4) {
                    arrayList.add(SignatureAlgorithm.VERITY_RSA_PKCS1_V1_5_WITH_SHA256);
                }
                return arrayList;
            }
            return Collections.singletonList(SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA512);
        }
        if (i.ALLATORIxDEMO("I\u001fL").equalsIgnoreCase(a32)) {
            ArrayList<SignatureAlgorithm> arrayList = new ArrayList<SignatureAlgorithm>();
            arrayList.add(SignatureAlgorithm.DSA_WITH_SHA256);
            if (a4) {
                arrayList.add(SignatureAlgorithm.VERITY_DSA_WITH_SHA256);
            }
            return arrayList;
        }
        if (A.ALLATORIxDEMO("<D").equalsIgnoreCase(a32)) {
            int n3 = ((ECKey)((Object)a2)).getParams().getOrder().bitLength();
            if (n3 <= 256) {
                ArrayList<SignatureAlgorithm> arrayList = new ArrayList<SignatureAlgorithm>();
                arrayList.add(SignatureAlgorithm.ECDSA_WITH_SHA256);
                if (a4) {
                    arrayList.add(SignatureAlgorithm.VERITY_ECDSA_WITH_SHA256);
                }
                return arrayList;
            }
            return Collections.singletonList(SignatureAlgorithm.ECDSA_WITH_SHA512);
        }
        throw new InvalidKeyException(new StringBuilder().insert(0, i.ALLATORIxDEMO("X\"~9}<b>y)ilf)tll j#\u007f%y$`v-")).append(a32).toString());
    }

    private static /* synthetic */ byte[] ALLATORIxDEMO(V3SignatureSchemeBlock.Signer a2) {
        V3SignatureSchemeBlock.Signer signer = a2;
        byte[] byArray = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(signer.signedData);
        byte[] byArray2 = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(signer.signatures));
        byte[] byArray3 = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(signer.publicKey);
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + 4 + 4 + byArray2.length + byArray3.length);
        ByteBuffer byteBuffer2 = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer byteBuffer3 = byteBuffer;
        byteBuffer.put(byArray);
        byteBuffer3.putInt(a2.minSdkVersion);
        byteBuffer.putInt(a2.maxSdkVersion);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        return byteBuffer3.array();
    }

    public static Pair<byte[], Integer> generateApkSignatureSchemeV3Block(DataSource a2, DataSource a3, DataSource a4, List<ApkSigningBlockUtils.SignerConfig> a5) throws IOException, InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        a3 = ApkSigningBlockUtils.computeContentDigests(a2, (DataSource)a3, a4, a5);
        return V3SchemeSigner.ALLATORIxDEMO(((Pair)a3).getFirst(), (Map<ContentDigestAlgorithm, byte[]>)((Map)((Pair)a3).getSecond()));
    }

    private static /* synthetic */ byte[] ALLATORIxDEMO(ApkSigningBlockUtils.SignerConfig a2) {
        if (a2.mSigningCertificateLineage == null) {
            return new byte[0];
        }
        return a2.mSigningCertificateLineage.generateV3SignerAttribute();
    }

    private static final class V3SignatureSchemeBlock {
        private /* synthetic */ V3SignatureSchemeBlock() {
            V3SignatureSchemeBlock a2;
        }

        private static final class SignedData {
            public byte[] additionalAttributes;
            public int minSdkVersion;
            public List<Pair<Integer, byte[]>> digests;
            public int maxSdkVersion;
            public List<byte[]> certificates;

            private /* synthetic */ SignedData() {
                SignedData a2;
            }
        }

        private static final class Signer {
            public int minSdkVersion;
            public byte[] publicKey;
            public int maxSdkVersion;
            public byte[] signedData;
            public List<Pair<Integer, byte[]>> signatures;

            private /* synthetic */ Signer() {
                Signer a2;
            }
        }
    }
}

