/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v2;

import com.android.apksig.ApkVerifier;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.pkcs7.IssuerAndSerialNumber;
import com.android.apksig.internal.util.ByteBufferUtils;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.util.DataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class V2SchemeVerifier {
    private static final int ALLATORIxDEMO = 1896449818;

    private static /* synthetic */ void ALLATORIxDEMO(ByteBuffer a2, Set<ContentDigestAlgorithm> a3, Map<Integer, String> a4, Set<Integer> a5, int a6, int a7, ApkSigningBlockUtils.Result a8) throws NoSuchAlgorithmException {
        CertificateFactory certificateFactory;
        ByteBuffer byteBuffer;
        try {
            byteBuffer = ApkSigningBlockUtils.getLengthPrefixedSlice(a2);
        }
        catch (ApkFormatException apkFormatException) {
            a8.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_SIGNERS, new Object[0]);
            return;
        }
        if (!byteBuffer.hasRemaining()) {
            a8.addError(ApkVerifier.Issue.V2_SIG_NO_SIGNERS, new Object[0]);
            return;
        }
        try {
            certificateFactory = CertificateFactory.getInstance(IssuerAndSerialNumber.ALLATORIxDEMO("7(Z6V"));
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException(ByteBufferUtils.ALLATORIxDEMO("x!W,[$\u001e4Q`Q\"J!W.\u001e\u0018\u0010u\u000ey\u001e\u0003[2J)X)]!J%x!]4Q2G"), certificateException);
        }
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            int n3 = n2++;
            ApkSigningBlockUtils.Result.SignerInfo signerInfo = new ApkSigningBlockUtils.Result.SignerInfo();
            signerInfo.index = n3;
            a8.signers.add(signerInfo);
            try {
                ByteBuffer byteBuffer2 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer);
                V2SchemeVerifier.ALLATORIxDEMO(byteBuffer2, certificateFactory, signerInfo, a3, a4, a5, a6, a7);
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_SIGNER, new Object[0]);
                return;
            }
        }
    }

    private /* synthetic */ V2SchemeVerifier() {
        V2SchemeVerifier a2;
    }

    public static ApkSigningBlockUtils.Result verify(DataSource a2, ApkUtils.ZipSections a3, Map<Integer, String> a4, Set<Integer> a5, int a6, int a7) throws IOException, ApkFormatException, NoSuchAlgorithmException, ApkSigningBlockUtils.SignatureNotFoundException {
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(2);
        DataSource dataSource = a2;
        a3 = ApkSigningBlockUtils.findSignature(dataSource, (ApkUtils.ZipSections)a3, 1896449818, result);
        DataSource dataSource2 = dataSource.slice(0L, ((SignatureInfo)a3).apkSigningBlockOffset);
        DataSource dataSource3 = dataSource.slice(((SignatureInfo)a3).centralDirOffset, ((SignatureInfo)a3).eocdOffset - ((SignatureInfo)a3).centralDirOffset);
        ByteBuffer byteBuffer = ((SignatureInfo)a3).eocd;
        V2SchemeVerifier.ALLATORIxDEMO(dataSource2, ((SignatureInfo)a3).signatureBlock, dataSource3, byteBuffer, a4, a5, a6, a7, result);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ void ALLATORIxDEMO(ByteBuffer a2, CertificateFactory a32, ApkSigningBlockUtils.Result.SignerInfo a4, Set<ContentDigestAlgorithm> a5, Map<Integer, String> a6, Set<Integer> a7, int a2222, int a822) throws ApkFormatException, NoSuchAlgorithmException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ByteBuffer byteBuffer = ApkSigningBlockUtils.getLengthPrefixedSlice(a2);
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        byteBuffer.flip();
        ByteBuffer byteBuffer2 = a2;
        a4.signedData = byArray;
        ByteBuffer byteBuffer3 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer2);
        byte[] byArray2 = ApkSigningBlockUtils.readLengthPrefixedByteArray(byteBuffer2);
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<ApkSigningBlockUtils.SupportedSignature>(1);
        ByteBuffer byteBuffer4 = byteBuffer3;
        while (byteBuffer4.hasRemaining()) {
            ++n2;
            try {
                object4 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer3);
                int n3 = ((ByteBuffer)object4).getInt();
                object3 = ApkSigningBlockUtils.readLengthPrefixedByteArray((ByteBuffer)object4);
                a4.signatures.add(new ApkSigningBlockUtils.Result.SignerInfo.Signature(n3, (byte[])object3));
                object2 = SignatureAlgorithm.findById(n3);
                if (object2 == null) {
                    Object[] objectArray = new Object[1];
                    objectArray[0] = n3;
                    a4.addWarning(ApkVerifier.Issue.V2_SIG_UNKNOWN_SIG_ALGORITHM, objectArray);
                    byteBuffer4 = byteBuffer3;
                    continue;
                }
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                Object[] objectArray = new Object[1];
                objectArray[0] = n2;
                a4.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_SIGNATURE, objectArray);
                return;
            }
            {
                arrayList.add((Integer)((Object)new ApkSigningBlockUtils.SupportedSignature((SignatureAlgorithm)((Object)object2), (byte[])object3)));
                byteBuffer4 = byteBuffer3;
            }
        }
        if (a4.signatures.isEmpty()) {
            a4.addError(ApkVerifier.Issue.V2_SIG_NO_SIGNATURES, new Object[0]);
            return;
        }
        object4 = null;
        try {
            object4 = ApkSigningBlockUtils.getSignaturesToVerify(arrayList, a2222, a822);
        }
        catch (ApkSigningBlockUtils.NoSupportedSignaturesException noSupportedSignaturesException) {
            a4.addError(ApkVerifier.Issue.V2_SIG_NO_SUPPORTED_SIGNATURES, new Object[0]);
            return;
        }
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            PublicKey publicKey;
            ApkSigningBlockUtils.SupportedSignature supportedSignature = (ApkSigningBlockUtils.SupportedSignature)object5.next();
            object3 = supportedSignature;
            object2 = supportedSignature.algorithm;
            String a2222 = ((SignatureAlgorithm)((Object)object2)).getJcaSignatureAlgorithmAndParams().getFirst();
            AlgorithmParameterSpec a822 = ((SignatureAlgorithm)((Object)object2)).getJcaSignatureAlgorithmAndParams().getSecond();
            String string = ((SignatureAlgorithm)((Object)object2)).getJcaKeyAlgorithm();
            try {
                publicKey = KeyFactory.getInstance(string).generatePublic(new X509EncodedKeySpec(byArray2));
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                objectArray[0] = exception;
                a4.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_PUBLIC_KEY, objectArray);
                return;
            }
            try {
                arrayList = Signature.getInstance(a2222);
                ((Signature)((Object)arrayList)).initVerify(publicKey);
                if (a822 != null) {
                    ((Signature)((Object)arrayList)).setParameter(a822);
                }
                byteBuffer.position(0);
                ((Signature)((Object)arrayList)).update(byteBuffer);
                object4 = ((ApkSigningBlockUtils.SupportedSignature)object3).signature;
                if (!((Signature)((Object)arrayList)).verify((byte[])object4)) {
                    Object[] objectArray = new Object[1];
                    objectArray[0] = object2;
                    a4.addError(ApkVerifier.Issue.V2_SIG_DID_NOT_VERIFY, objectArray);
                    return;
                }
                a4.verifiedSignatures.put((SignatureAlgorithm)((Object)object2), (byte[])object4);
                a5.add((Integer)((Object)((SignatureAlgorithm)((Object)object2)).getContentDigestAlgorithm()));
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | SignatureException generalSecurityException) {
                Object[] objectArray = new Object[2];
                objectArray[0] = object2;
                objectArray[1] = generalSecurityException;
                a4.addError(ApkVerifier.Issue.V2_SIG_VERIFY_EXCEPTION, objectArray);
                return;
            }
        }
        byteBuffer.position(0);
        ByteBuffer byteBuffer5 = byteBuffer;
        object5 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer5);
        object3 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer5);
        object2 = ApkSigningBlockUtils.getLengthPrefixedSlice(byteBuffer5);
        int a2222 = -1;
        Object object6 = object3;
        while (((Buffer)object6).hasRemaining()) {
            X509Certificate x509Certificate;
            byte[] a822 = ApkSigningBlockUtils.readLengthPrefixedByteArray((ByteBuffer)object3);
            ++a2222;
            try {
                x509Certificate = (X509Certificate)((CertificateFactory)((Object)a32)).generateCertificate(new ByteArrayInputStream(a822));
            }
            catch (CertificateException certificateException) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a2222;
                objectArray[1] = a2222 + 1;
                objectArray[2] = certificateException;
                a4.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_CERTIFICATE, objectArray);
                return;
            }
            GuaranteedEncodedFormX509Certificate guaranteedEncodedFormX509Certificate = new GuaranteedEncodedFormX509Certificate(x509Certificate, a822);
            object6 = object3;
            a4.certs.add(guaranteedEncodedFormX509Certificate);
        }
        if (a4.certs.isEmpty()) {
            a4.addError(ApkVerifier.Issue.V2_SIG_NO_CERTIFICATES, new Object[0]);
            return;
        }
        Object a822 = a4.certs.get(0);
        byte[] byArray3 = ((Certificate)a822).getPublicKey().getEncoded();
        if (!Arrays.equals(byArray2, byArray3)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = ApkSigningBlockUtils.toHex(byArray3);
            objectArray[1] = ApkSigningBlockUtils.toHex(byArray2);
            a4.addError(ApkVerifier.Issue.V2_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD, objectArray);
            return;
        }
        n2 = 0;
        Object object7 = object5;
        while (((Buffer)object7).hasRemaining()) {
            ++n2;
            try {
                arrayList = ApkSigningBlockUtils.getLengthPrefixedSlice((ByteBuffer)object5);
                int n4 = ((ByteBuffer)((Object)arrayList)).getInt();
                a32 = (Iterator<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest>)ApkSigningBlockUtils.readLengthPrefixedByteArray((ByteBuffer)((Object)arrayList));
                a4.contentDigests.add(new ApkSigningBlockUtils.Result.SignerInfo.ContentDigest(n4, (byte[])a32));
                object7 = object5;
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                Object[] objectArray = new Object[1];
                objectArray[0] = n2;
                a4.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_DIGEST, objectArray);
                return;
            }
        }
        arrayList = new ArrayList<Integer>(a4.signatures.size());
        Object object8 = object = a4.signatures.iterator();
        while (object8.hasNext()) {
            a32 = object.next();
            object8 = object;
            arrayList.add(((ApkSigningBlockUtils.Result.SignerInfo.Signature)((Object)a32)).getAlgorithmId());
        }
        object = new ArrayList(a4.contentDigests.size());
        Iterator<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> iterator = a32 = a4.contentDigests.iterator();
        while (iterator.hasNext()) {
            a5 = a32.next();
            iterator = a32;
            object.add(((ApkSigningBlockUtils.Result.SignerInfo.ContentDigest)((Object)a5)).getSignatureAlgorithmId());
        }
        if (!arrayList.equals(object)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = arrayList;
            objectArray[1] = object;
            a4.addError(ApkVerifier.Issue.V2_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS, objectArray);
            return;
        }
        int a32 = 0;
        a5 = a6.keySet();
        HashSet<Integer> a2222 = new HashSet<Integer>(1);
        block24: while (((Buffer)object2).hasRemaining()) {
            ++a32;
            try {
                a822 = ApkSigningBlockUtils.getLengthPrefixedSlice((ByteBuffer)object2);
                int n5 = ((ByteBuffer)a822).getInt();
                byte[] byArray4 = ByteBufferUtils.toByteArray((ByteBuffer)a822);
                a4.additionalAttributes.add(new ApkSigningBlockUtils.Result.SignerInfo.AdditionalAttribute(n5, byArray4));
                switch (n5) {
                    case -1091571699: {
                        int n6 = ((ByteBuffer)a822).getInt();
                        if (a5.contains(n6)) {
                            a2222.add(n5);
                            continue block24;
                        }
                        Object[] objectArray = new Object[2];
                        objectArray[0] = a4.index;
                        objectArray[1] = n6;
                        a4.addWarning(ApkVerifier.Issue.V2_SIG_UNKNOWN_APK_SIG_SCHEME_ID, objectArray);
                        continue block24;
                    }
                }
                Object[] objectArray = new Object[1];
                objectArray[0] = n5;
                a4.addWarning(ApkVerifier.Issue.V2_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE, objectArray);
            }
            catch (ApkFormatException | BufferUnderflowException a822) {
                Object[] objectArray = new Object[1];
                objectArray[0] = a32;
                a4.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE, objectArray);
                return;
            }
        }
        a822 = a2222.iterator();
        while (a822.hasNext()) {
            int n7 = (Integer)a822.next();
            if (a7.contains(n7)) continue;
            String string = a6.get(n7);
            Object[] objectArray = new Object[2];
            objectArray[0] = a4.index;
            objectArray[1] = string;
            a4.addError(ApkVerifier.Issue.V2_SIG_MISSING_APK_SIG_REFERENCED, objectArray);
        }
        return;
    }

    private static /* synthetic */ void ALLATORIxDEMO(DataSource a2, ByteBuffer a3, DataSource a4, ByteBuffer a5, Map<Integer, String> a6, Set<Integer> a7, int a8, int a9, ApkSigningBlockUtils.Result a10) throws IOException, NoSuchAlgorithmException {
        HashSet<ContentDigestAlgorithm> hashSet = new HashSet<ContentDigestAlgorithm>(1);
        V2SchemeVerifier.ALLATORIxDEMO(a3, hashSet, a6, a7, a8, a9, a10);
        if (a10.containsErrors()) {
            return;
        }
        ApkSigningBlockUtils.verifyIntegrity(a2, a4, a5, hashSet, a10);
        if (!a10.containsErrors()) {
            a10.verified = true;
        }
    }
}

