/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v2;

import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.qihoo.jiagu.h.t;
import com.qihoo.jiagu.l.a.E;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class V2SchemeSigner {
    protected static final int STRIPPING_PROTECTION_ATTR_ID = -1091571699;
    private static final int ALLATORIxDEMO = 1896449818;

    private static /* synthetic */ Pair<byte[], Integer> ALLATORIxDEMO(List<ApkSigningBlockUtils.SignerConfig> a2, Map<ContentDigestAlgorithm, byte[]> a3, boolean a4) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Iterator<ApkSigningBlockUtils.SignerConfig> iterator;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(a2.size());
        int n2 = 0;
        Iterator<ApkSigningBlockUtils.SignerConfig> iterator2 = iterator = a2.iterator();
        while (iterator2.hasNext()) {
            ++n2;
            Object object = iterator.next();
            try {
                object = V2SchemeSigner.ALLATORIxDEMO((ApkSigningBlockUtils.SignerConfig)object, a3, a4);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeyException(new StringBuilder().insert(0, t.ALLATORIxDEMO("\u0007\u001d3\u001a1\u0006tW")).append(n2).append(E.ALLATORIxDEMO("93x<u0}")).toString(), invalidKeyException);
            }
            catch (SignatureException signatureException) {
                throw new SignatureException(new StringBuilder().insert(0, t.ALLATORIxDEMO("\u0007\u001d3\u001a1\u0006tW")).append(n2).append(E.ALLATORIxDEMO("93x<u0}")).toString(), signatureException);
            }
            arrayList.add((byte[])object);
            iterator2 = iterator;
        }
        byte[][] byArrayArray = new byte[1][];
        byArrayArray[0] = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(arrayList);
        return Pair.of(ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(byArrayArray), 1896449818);
    }

    public static List<SignatureAlgorithm> getSuggestedSignatureAlgorithms(PublicKey a2, int a32, boolean a4) throws InvalidKeyException {
        String a32 = a2.getAlgorithm();
        if (t.ALLATORIxDEMO("&\u00075").equalsIgnoreCase(a32)) {
            int n2 = ((RSAKey)((Object)a2)).getModulus().bitLength();
            if (n2 <= 3072) {
                ArrayList<SignatureAlgorithm> arrayList = new ArrayList<SignatureAlgorithm>();
                arrayList.add(SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA256);
                if (a4) {
                    arrayList.add(SignatureAlgorithm.VERITY_RSA_PKCS1_V1_5_WITH_SHA256);
                }
                return arrayList;
            }
            return Collections.singletonList(SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA512);
        }
        if (E.ALLATORIxDEMO("]\u0006X").equalsIgnoreCase(a32)) {
            ArrayList<SignatureAlgorithm> arrayList = new ArrayList<SignatureAlgorithm>();
            arrayList.add(SignatureAlgorithm.DSA_WITH_SHA256);
            if (a4) {
                arrayList.add(SignatureAlgorithm.VERITY_DSA_WITH_SHA256);
            }
            return arrayList;
        }
        if (t.ALLATORIxDEMO("\u00117").equalsIgnoreCase(a32)) {
            int n3 = ((ECKey)((Object)a2)).getParams().getOrder().bitLength();
            if (n3 <= 256) {
                ArrayList<SignatureAlgorithm> arrayList = new ArrayList<SignatureAlgorithm>();
                arrayList.add(SignatureAlgorithm.ECDSA_WITH_SHA256);
                if (a4) {
                    arrayList.add(SignatureAlgorithm.VERITY_ECDSA_WITH_SHA256);
                }
                return arrayList;
            }
            return Collections.singletonList(SignatureAlgorithm.ECDSA_WITH_SHA512);
        }
        throw new InvalidKeyException(new StringBuilder().insert(0, E.ALLATORIxDEMO("L;j i%v'm0}ur0`ux9~:k<m=to9")).append(a32).toString());
    }

    private static /* synthetic */ byte[] ALLATORIxDEMO(boolean a2) {
        if (a2) {
            int n2 = 12;
            ByteBuffer byteBuffer = ByteBuffer.allocate(12);
            ByteBuffer byteBuffer2 = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer byteBuffer3 = byteBuffer;
            byteBuffer.putInt(n2);
            byteBuffer3.putInt(-1091571699);
            byteBuffer.putInt(3);
            return byteBuffer3.array();
        }
        return new byte[0];
    }

    public static Pair<byte[], Integer> generateApkSignatureSchemeV2Block(DataSource a2, DataSource a3, DataSource a4, List<ApkSigningBlockUtils.SignerConfig> a5, boolean a6) throws IOException, InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        a3 = ApkSigningBlockUtils.computeContentDigests(a2, (DataSource)a3, a4, a5);
        return V2SchemeSigner.ALLATORIxDEMO(((Pair)a3).getFirst(), (Map<ContentDigestAlgorithm, byte[]>)((Map)((Pair)a3).getSecond()), a6);
    }

    private /* synthetic */ V2SchemeSigner() {
        V2SchemeSigner a2;
    }

    public static String ALLATORIxDEMO(String a2) {
        int n2 = a2.length();
        int n3 = n2 - 1;
        char[] cArray = new char[n2];
        int n4 = (2 ^ 5) << 4 ^ 3 << 1;
        int cfr_ignored_0 = 5 << 3 ^ 5;
        int n5 = n3;
        int n6 = 2 << 3;
        while (n5 >= 0) {
            int n7 = n3--;
            cArray[n7] = (char)(a2.charAt(n7) ^ n6);
            if (n3 < 0) break;
            int n8 = n3--;
            cArray[n8] = (char)(a2.charAt(n8) ^ n4);
            n5 = n3;
        }
        return new String(cArray);
    }

    private static /* synthetic */ byte[] ALLATORIxDEMO(ApkSigningBlockUtils.SignerConfig a2, Map<ContentDigestAlgorithm, byte[]> a3, boolean a4) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Object object;
        if (a2.certificates.isEmpty()) {
            throw new SignatureException(t.ALLATORIxDEMO(":;T7\u0011&\u0000=\u0012=\u00175\u00001\u0007t\u0017;\u001a2\u001d3\u0001&\u00110T2\u001b&T'\u001d3\u001a1\u0006"));
        }
        byte[] byArray = ApkSigningBlockUtils.encodePublicKey(a2.certificates.get(0).getPublicKey());
        V2SignatureSchemeBlock.SignedData signedData = new V2SignatureSchemeBlock.SignedData();
        try {
            signedData.certificates = ApkSigningBlockUtils.encodeCertificates(a2.certificates);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new SignatureException(E.ALLATORIxDEMO("_4p9|19!vu|;z:}096|'m<\u007f<z4m0j"), certificateEncodingException);
        }
        ArrayList<Pair<Integer, byte[]>> arrayList = new ArrayList<Pair<Integer, byte[]>>(a2.signatureAlgorithms.size());
        Object object2 = object = a2.signatureAlgorithms.iterator();
        while (object2.hasNext()) {
            SignatureAlgorithm signatureAlgorithm = object.next();
            ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
            byte[] byArray2 = a3.get((Object)contentDigestAlgorithm);
            if (byArray2 == null) {
                throw new RuntimeException((Object)((Object)contentDigestAlgorithm) + t.ALLATORIxDEMO("t\u0017;\u001a \u0011:\u0000t\u0010=\u00131\u0007 T2\u001b&T") + (Object)((Object)signatureAlgorithm) + E.ALLATORIxDEMO("9;v!96v8i m0}"));
            }
            arrayList.add(Pair.of(signatureAlgorithm.getId(), byArray2));
            object2 = object;
        }
        signedData.digests = arrayList;
        signedData.additionalAttributes = V2SchemeSigner.ALLATORIxDEMO(a4);
        object = new V2SignatureSchemeBlock.Signer();
        byte[][] byArrayArray = new byte[3][];
        byArrayArray[0] = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(signedData.digests);
        byArrayArray[1] = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(signedData.certificates);
        byArrayArray[2] = new byte[0];
        new V2SignatureSchemeBlock.Signer().signedData = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(byArrayArray);
        ((V2SignatureSchemeBlock.Signer)object).publicKey = byArray;
        Object object3 = object;
        ((V2SignatureSchemeBlock.Signer)object).signatures = new ArrayList<Pair<Integer, byte[]>>();
        ((V2SignatureSchemeBlock.Signer)object).signatures = ApkSigningBlockUtils.generateSignaturesOverData(a2, ((V2SignatureSchemeBlock.Signer)object).signedData);
        byte[][] byArrayArray2 = new byte[3][];
        byArrayArray2[0] = ((V2SignatureSchemeBlock.Signer)object).signedData;
        byArrayArray2[1] = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(((V2SignatureSchemeBlock.Signer)object).signatures);
        byArrayArray2[2] = ((V2SignatureSchemeBlock.Signer)object).publicKey;
        return ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(byArrayArray2);
    }

    private static final class V2SignatureSchemeBlock {
        private /* synthetic */ V2SignatureSchemeBlock() {
            V2SignatureSchemeBlock a2;
        }

        private static final class SignedData {
            public List<byte[]> certificates;
            public byte[] additionalAttributes;
            public List<Pair<Integer, byte[]>> digests;

            private /* synthetic */ SignedData() {
                SignedData a2;
            }
        }

        private static final class Signer {
            public byte[] publicKey;
            public List<Pair<Integer, byte[]>> signatures;
            public byte[] signedData;

            private /* synthetic */ Signer() {
                Signer a2;
            }
        }
    }
}

