/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk;

import com.android.apksig.ApkVerifier;
import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkSigningBlockNotFoundException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.util.ByteBufferDataSource;
import com.android.apksig.internal.util.ChainedDataSource;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.util.VerityTreeBuilder;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSinks;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.qihoo.jiagu.g.a.i;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ApkSigningBlockUtils {
    public static final byte[] APK_SIGNING_BLOCK_MAGIC;
    public static final int VERSION_JAR_SIGNATURE_SCHEME = 1;
    private static final int E = 1114793335;
    public static final int ANDROID_COMMON_PAGE_ALIGNMENT_BYTES = 4096;
    public static final int VERSION_APK_SIGNATURE_SCHEME_V3 = 3;
    public static final int VERSION_APK_SIGNATURE_SCHEME_V2 = 2;
    private static final int b = 0x100000;
    private static final char[] ALLATORIxDEMO;

    /*
     * Enabled aggressive block sorting
     */
    private static /* synthetic */ int ALLATORIxDEMO(ContentDigestAlgorithm a2, ContentDigestAlgorithm a3) {
        switch (a2) {
            case CHUNKED_SHA256: {
                switch (a3) {
                    case CHUNKED_SHA256: {
                        return 0;
                    }
                    case CHUNKED_SHA512: 
                    case VERITY_CHUNKED_SHA256: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException(new StringBuilder().insert(0, ApkFormatException.ALLATORIxDEMO("\b\r6\r2\u00143C<\u000f:QgC")).append((Object)a3).toString());
            }
            case CHUNKED_SHA512: {
                switch (a3) {
                    case CHUNKED_SHA256: 
                    case VERITY_CHUNKED_SHA256: {
                        return 1;
                    }
                    case CHUNKED_SHA512: {
                        return 0;
                    }
                }
                throw new IllegalArgumentException(new StringBuilder().insert(0, i.ALLATORIxDEMO("G#y#}:|ms!u\u007f(m")).append((Object)a3).toString());
            }
            case VERITY_CHUNKED_SHA256: {
                switch (a3) {
                    case CHUNKED_SHA256: {
                        return 1;
                    }
                    case VERITY_CHUNKED_SHA256: {
                        return 0;
                    }
                    case CHUNKED_SHA512: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException(new StringBuilder().insert(0, ApkFormatException.ALLATORIxDEMO("\b\r6\r2\u00143C<\u000f:QgC")).append((Object)a3).toString());
            }
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, i.ALLATORIxDEMO("G#y#}:|ms!u|(m")).append((Object)a2).toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void verifyIntegrity(DataSource a2, DataSource a3, ByteBuffer a42, Set<ContentDigestAlgorithm> a52, Result a6) throws IOException, NoSuchAlgorithmException {
        if (a52.isEmpty()) {
            throw new RuntimeException(ApkFormatException.ALLATORIxDEMO("\u0013\f}\u00002\r)\u00063\u0017}\u00074\u00048\u0010)\u0010}\u00052\u00163\u0007"));
        }
        Iterator<Result.SignerInfo> iterator = a42;
        Object object = ByteBuffer.allocate(((Buffer)((Object)iterator)).remaining());
        int n2 = ((Buffer)((Object)iterator)).position();
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        ((ByteBuffer)object).put((ByteBuffer)((Object)a42));
        ((ByteBuffer)object).flip();
        ((ByteBuffer)((Object)a42)).position(n2);
        ZipUtils.setZipEocdCentralDirectoryOffset((ByteBuffer)object, a2.size());
        try {
            a3 = ApkSigningBlockUtils.computeContentDigests((Set<ContentDigestAlgorithm>)a52, a2, a3, new ByteBufferDataSource((ByteBuffer)object));
        }
        catch (DigestException a42) {
            throw new RuntimeException(i.ALLATORIxDEMO("\u000bs$~(vmf\"2.} b8f(2.}#f(|92){*w>f>"), a42);
        }
        if (!a52.equals(a3.keySet())) {
            throw new RuntimeException(new StringBuilder().insert(0, ApkFormatException.ALLATORIxDEMO(".4\u00100\u0002)\u00005C?\u0006)\u00148\u00063C.\u0006)\u0010}\f;C/\u0006,\u00168\u0010)\u00069C<\r9C>\f0\u0013(\u00178\u0007}\u00002\r)\u00063\u0017}\u00074\u00048\u0010)\u0010}M}18\u0012(\u0006.\u00178\u0007gC")).append(a52).append(i.ALLATORIxDEMO(">mq\"\u007f=g9w)(m")).append(a3.keySet()).toString());
        }
        Iterator<Result.SignerInfo> a42 = a6.signers.iterator();
        block2: while (a42.hasNext()) {
            Result.SignerInfo a52 = a42.next();
            object = a52.contentDigests.iterator();
            block3: while (true) {
                Object object2 = object;
                while (true) {
                    byte[] byArray;
                    if (!object2.hasNext()) continue block2;
                    Object object3 = (Result.SignerInfo.ContentDigest)object.next();
                    Enum enum_ = SignatureAlgorithm.findById(((Result.SignerInfo.ContentDigest)object3).getSignatureAlgorithmId());
                    if (enum_ == null) {
                        object2 = object;
                        continue;
                    }
                    enum_ = ((SignatureAlgorithm)enum_).getContentDigestAlgorithm();
                    if (!Arrays.equals((byte[])(object3 = (Object)((Result.SignerInfo.ContentDigest)object3).getValue()), byArray = a3.get(enum_))) {
                        if (a6.signatureSchemeVersion == 2) {
                            Object[] objectArray = new Object[3];
                            objectArray[0] = enum_;
                            objectArray[1] = ApkSigningBlockUtils.toHex((byte[])object3);
                            objectArray[2] = ApkSigningBlockUtils.toHex(byArray);
                            a52.addError(ApkVerifier.Issue.V2_SIG_APK_DIGEST_DID_NOT_VERIFY, objectArray);
                            object2 = object;
                            continue;
                        }
                        if (a6.signatureSchemeVersion != 3) continue block3;
                        Object[] objectArray = new Object[3];
                        objectArray[0] = enum_;
                        objectArray[1] = ApkSigningBlockUtils.toHex((byte[])object3);
                        objectArray[2] = ApkSigningBlockUtils.toHex(byArray);
                        a52.addError(ApkVerifier.Issue.V3_SIG_APK_DIGEST_DID_NOT_VERIFY, objectArray);
                        object2 = object;
                        continue;
                    }
                    a52.verifiedContentDigests.put((ContentDigestAlgorithm)enum_, byArray);
                    object2 = object;
                }
                break;
            }
            break;
        }
        return;
    }

    static {
        ALLATORIxDEMO = ApkFormatException.ALLATORIxDEMO("SlQnWhUj[dS<\u0001>\u00078\u0005").toCharArray();
        byte[] byArray = new byte[16];
        byArray[0] = 65;
        byArray[1] = 80;
        byArray[2] = 75;
        byArray[3] = 32;
        byArray[4] = 83;
        byArray[5] = 105;
        byArray[6] = 103;
        byArray[7] = 32;
        byArray[8] = 66;
        byArray[9] = 108;
        byArray[10] = 111;
        byArray[11] = 99;
        byArray[12] = 107;
        byArray[13] = 32;
        byArray[14] = 52;
        byArray[15] = 50;
        APK_SIGNING_BLOCK_MAGIC = byArray;
    }

    public static DataSource copyWithModifiedCDOffset(DataSource a2, DataSource a3) throws IOException {
        long l2 = a2.size();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)a3.size());
        ByteBuffer byteBuffer2 = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DataSource dataSource = a3;
        dataSource.copyTo(0L, (int)dataSource.size(), byteBuffer);
        ByteBuffer byteBuffer3 = byteBuffer;
        byteBuffer.flip();
        ZipUtils.setZipEocdCentralDirectoryOffset(byteBuffer3, l2);
        return DataSources.asDataSource(byteBuffer3);
    }

    public static Pair<List<SignerConfig>, Map<ContentDigestAlgorithm, byte[]>> computeContentDigests(DataSource a2, DataSource a3, DataSource a4, List<SignerConfig> a5) throws IOException, NoSuchAlgorithmException, SignatureException {
        Map<ContentDigestAlgorithm, byte[]> map;
        if (a5.isEmpty()) {
            throw new IllegalArgumentException(i.ALLATORIxDEMO("\\\"2>{*|(`mq\"|+{*amb?};{)w)<mS92!w,a92\"|(2$am`(c8{?w)"));
        }
        HashSet<ContentDigestAlgorithm> hashSet = new HashSet<ContentDigestAlgorithm>(1);
        for (SignerConfig signerConfig : a5) {
            Iterator<SignatureAlgorithm> iterator = signerConfig.signatureAlgorithms.iterator();
            while (iterator.hasNext()) {
                Iterator<SignatureAlgorithm> iterator2;
                SignatureAlgorithm signatureAlgorithm = iterator2.next();
                iterator = iterator2;
                hashSet.add(signatureAlgorithm.getContentDigestAlgorithm());
            }
        }
        try {
            map = ApkSigningBlockUtils.computeContentDigests(hashSet, a2, a3, a4);
        }
        catch (IOException iOException) {
            throw new IOException(ApkFormatException.ALLATORIxDEMO("%<\n1\u00069C)\f}\u00118\u00029C\u001c3\u0016C?\u00064\r:C.\n:\r8\u0007"), iOException);
        }
        catch (DigestException digestException) {
            throw new SignatureException(i.ALLATORIxDEMO("T,{!w)29}mq\"\u007f=g9wmv$u(a9am}+2\fB\u0006"), digestException);
        }
        return Pair.of(a5, map);
    }

    private static final /* synthetic */ long ALLATORIxDEMO(long a2, int a3) {
        return (a2 + (long)a3 - 1L) / (long)a3;
    }

    public static String toHex(byte[] a2) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(a2.length * 2);
        int n3 = a2.length;
        int n4 = n2 = 0;
        while (n4 < n3) {
            int n5 = (a2[n2] & 0xFF) >>> 4;
            int n6 = a2[n2] & 0xF;
            stringBuilder.append(ALLATORIxDEMO[n5]).append(ALLATORIxDEMO[n6]);
            n4 = ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ ByteBuffer ALLATORIxDEMO(ByteBuffer a2, int a32, int a4) {
        if (a32 < 0) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, ApkFormatException.ALLATORIxDEMO("\u0010)\u0002/\u0017gC")).append(a32).toString());
        }
        if (a4 < a32) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, i.ALLATORIxDEMO("(|)2q2>f,`9(m")).append(a4).append(ApkFormatException.ALLATORIxDEMO("CaC")).append(a32).toString());
        }
        int n2 = a2.capacity();
        if (a4 > a2.capacity()) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, i.ALLATORIxDEMO("w#vm,mq,b,q$f4(m")).append(a4).append(ApkFormatException.ALLATORIxDEMO("CcC")).append(n2).toString());
        }
        ByteBuffer byteBuffer = a2;
        n2 = byteBuffer.limit();
        int n3 = byteBuffer.position();
        try {
            a2.position(0);
            a2.limit(a4);
            a2.position(a32);
            ByteBuffer a32 = a2.slice();
            a32.order(a2.order());
            return a32;
        }
        finally {
            a2.position(0);
            a2.limit(n2);
            a2.position(n3);
        }
    }

    public static byte[] encodeAsSequenceOfLengthPrefixedElements(List<byte[]> a2) {
        List<byte[]> list = a2;
        return ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements((byte[][])list.toArray((T[])new byte[list.size()][]));
    }

    public static byte[] encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(List<Pair<Integer, byte[]>> a2) {
        Object object;
        Object object2;
        int n2 = 0;
        Object object3 = object2 = a2.iterator();
        while (object3.hasNext()) {
            object = object2.next();
            n2 += 12 + ((byte[])((Pair)object).getSecond()).length;
            object3 = object2;
        }
        object2 = ByteBuffer.allocate(n2);
        ((ByteBuffer)object2).order(ByteOrder.LITTLE_ENDIAN);
        object = a2.iterator();
        Object object4 = object;
        while (object4.hasNext()) {
            Pair pair = (Pair)object.next();
            byte[] byArray = (byte[])pair.getSecond();
            ((ByteBuffer)object2).putInt(8 + byArray.length);
            ((ByteBuffer)object2).putInt((Integer)pair.getFirst());
            ((ByteBuffer)object2).putInt(byArray.length);
            ((ByteBuffer)object2).put(byArray);
            object4 = object;
        }
        return ((ByteBuffer)object2).array();
    }

    public static List<byte[]> encodeCertificates(List<X509Certificate> a2) throws CertificateEncodingException {
        Iterator<X509Certificate> iterator;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(a2.size());
        Iterator<X509Certificate> iterator2 = iterator = a2.iterator();
        while (iterator2.hasNext()) {
            X509Certificate x509Certificate = iterator.next();
            iterator2 = iterator;
            arrayList.add(x509Certificate.getEncoded());
        }
        return arrayList;
    }

    public ApkSigningBlockUtils() {
        ApkSigningBlockUtils a2;
    }

    public static List<Pair<Integer, byte[]>> generateSignaturesOverData(SignerConfig a2, byte[] a3) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        Iterator<SignatureAlgorithm> iterator;
        ArrayList<Pair<Integer, byte[]>> arrayList = new ArrayList<Pair<Integer, byte[]>>(a2.signatureAlgorithms.size());
        PublicKey publicKey = a2.certificates.get(0).getPublicKey();
        Iterator<SignatureAlgorithm> iterator2 = iterator = a2.signatureAlgorithms.iterator();
        while (iterator2.hasNext()) {
            byte[] byArray;
            Signature signature;
            SignatureAlgorithm signatureAlgorithm = iterator.next();
            Object object = signatureAlgorithm.getJcaSignatureAlgorithmAndParams();
            String string = ((Pair)object).getFirst();
            object = ((Pair)object).getSecond();
            try {
                signature = Signature.getInstance(string);
                signature.initSign(a2.privateKey);
                if (object != null) {
                    signature.setParameter((AlgorithmParameterSpec)object);
                }
                Signature signature2 = signature;
                signature2.update(a3);
                byArray = signature2.sign();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeyException(new StringBuilder().insert(0, i.ALLATORIxDEMO("\u000bs$~(vmf\"2>{*|mg>{#um")).append(string).toString(), invalidKeyException);
            }
            catch (InvalidAlgorithmParameterException | SignatureException generalSecurityException) {
                throw new SignatureException(new StringBuilder().insert(0, ApkFormatException.ALLATORIxDEMO("%<\n1\u00069C)\f}\u00104\u00043C(\u00104\r:C")).append(string).toString(), generalSecurityException);
            }
            try {
                signature = Signature.getInstance(string);
                signature.initVerify(publicKey);
                if (object != null) {
                    signature.setParameter((AlgorithmParameterSpec)object);
                }
                signature.update(a3);
                if (!signature.verify(byArray)) {
                    throw new SignatureException(new StringBuilder().insert(0, i.ALLATORIxDEMO("\u000bs$~(vmf\"2;w?{+kmu(|(`,f(vm")).append(string).append(ApkFormatException.ALLATORIxDEMO("}\u00104\u00043\u0002)\u0016/\u0006}\u0016.\n3\u0004}\u0013(\u00011\n>C6\u0006$C;\u00112\u000e}\u00008\u0011)\n;\n>\u0002)\u0006")).toString());
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeyException(new StringBuilder().insert(0, i.ALLATORIxDEMO("\u000bs$~(vmf\"2;w?{+kmu(|(`,f(vm")).append(string).append(ApkFormatException.ALLATORIxDEMO("}\u00104\u00043\u0002)\u0016/\u0006}\u0016.\n3\u0004}\u0013(\u00011\n>C6\u0006$C;\u00112\u000e}\u00008\u0011)\n;\n>\u0002)\u0006")).toString(), invalidKeyException);
            }
            catch (InvalidAlgorithmParameterException | SignatureException generalSecurityException) {
                throw new SignatureException(new StringBuilder().insert(0, i.ALLATORIxDEMO("\u000bs$~(vmf\"2;w?{+kmu(|(`,f(vm")).append(string).append(ApkFormatException.ALLATORIxDEMO("}\u00104\u00043\u0002)\u0016/\u0006}\u0016.\n3\u0004}\u0013(\u00011\n>C6\u0006$C;\u00112\u000e}\u00008\u0011)\n;\n>\u0002)\u0006")).toString(), generalSecurityException);
            }
            arrayList.add(Pair.of(signatureAlgorithm.getId(), byArray));
            iterator2 = iterator;
        }
        return arrayList;
    }

    public static ByteBuffer getLengthPrefixedSlice(ByteBuffer a2) throws ApkFormatException {
        if (a2.remaining() < 4) {
            throw new ApkFormatException(new StringBuilder().insert(0, i.ALLATORIxDEMO("@(\u007f,{#{#ump8t+w?29}\"2>z\"`929}mq\"|9s$|m~(|*f%2\"tm~(|*f%?=`(t$j(vmt$w!vc2\u001fw s$|$|*(m")).append(a2.remaining()).toString());
        }
        int n2 = a2.getInt();
        if (n2 < 0) {
            throw new IllegalArgumentException(ApkFormatException.ALLATORIxDEMO("-8\u0004<\u00174\u00158C1\u00063\u0004)\u000b"));
        }
        if (n2 > a2.remaining()) {
            throw new ApkFormatException(new StringBuilder().insert(0, i.ALLATORIxDEMO("^(|*f%?=`(t$j(vmt$w!vm~\"|*w?29z,|m`(\u007f,{#{#ump8t+w?<mT$w!vm~(|*f%(m")).append(n2).append(ApkFormatException.ALLATORIxDEMO("O}\u00118\u000e<\n3\n3\u0004gC")).append(a2.remaining()).toString());
        }
        return ApkSigningBlockUtils.ALLATORIxDEMO(a2, n2);
    }

    private static /* synthetic */ void ALLATORIxDEMO(int a2, byte[] a3, int a4) {
        int n2 = a4;
        a3[a4] = (byte)(a2 & 0xFF);
        a3[n2 + 1] = (byte)(a2 >> 8 & 0xFF);
        a3[n2 + 2] = (byte)(a2 >> 16 & 0xFF);
        a3[a4 + 3] = (byte)(a2 >> 24 & 0xFF);
    }

    private static /* synthetic */ void ALLATORIxDEMO(DataSource a2, DataSource a3, DataSource a4, Map<ContentDigestAlgorithm, byte[]> a5) throws IOException, NoSuchAlgorithmException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(ContentDigestAlgorithm.VERITY_CHUNKED_SHA256.ALLATORIxDEMO() + 8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray = new VerityTreeBuilder(new byte[8]).generateVerityTreeRootHash(a2, a3, a4);
        byteBuffer.put(byArray);
        byteBuffer.putLong(a2.size() + a3.size() + a4.size());
        a5.put(ContentDigestAlgorithm.VERITY_CHUNKED_SHA256, byteBuffer.array());
    }

    public static byte[] encodeAsSequenceOfLengthPrefixedElements(byte[][] a2) {
        int n2;
        int n3;
        int n4 = 0;
        Object object = a2;
        int n5 = a2.length;
        int n6 = n3 = 0;
        while (n6 < n5) {
            byte[] byArray = object[n3];
            n4 += 4 + byArray.length;
            n6 = ++n3;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n4);
        object = byteBuffer;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[][] byArray = a2;
        n3 = byArray.length;
        int n7 = n2 = 0;
        while (n7 < n3) {
            byte[] byArray2 = byArray[n2];
            ((ByteBuffer)object).putInt(byArray2.length);
            ((ByteBuffer)object).put(byArray2);
            n7 = ++n2;
        }
        return ((ByteBuffer)object).array();
    }

    public static Map<ContentDigestAlgorithm, byte[]> computeContentDigests(Set<ContentDigestAlgorithm> a3, DataSource a4, DataSource a5, DataSource a6) throws IOException, NoSuchAlgorithmException, DigestException {
        HashMap<ContentDigestAlgorithm, byte[]> hashMap = new HashMap<ContentDigestAlgorithm, byte[]>();
        DataSource[] dataSourceArray = new DataSource[3];
        dataSourceArray[0] = a4;
        dataSourceArray[1] = a5;
        dataSourceArray[2] = a6;
        ApkSigningBlockUtils.ALLATORIxDEMO(a3.stream().filter(a2 -> a2 == ContentDigestAlgorithm.CHUNKED_SHA256 || a2 == ContentDigestAlgorithm.CHUNKED_SHA512).collect(Collectors.toSet()), dataSourceArray, hashMap);
        if (a3.contains((Object)ContentDigestAlgorithm.VERITY_CHUNKED_SHA256)) {
            ApkSigningBlockUtils.ALLATORIxDEMO(a4, a5, a6, hashMap);
        }
        return hashMap;
    }

    public static List<SupportedSignature> getSignaturesToVerify(List<SupportedSignature> a4, int a5, int a6) throws NoSupportedSignaturesException {
        HashMap<Integer, SupportedSignature> hashMap = new HashMap<Integer, SupportedSignature>();
        int n2 = Integer.MAX_VALUE;
        Iterator<SupportedSignature> iterator = a4.iterator();
        block0: while (true) {
            Iterator<SupportedSignature> iterator2 = iterator;
            while (iterator2.hasNext()) {
                SupportedSignature supportedSignature;
                SupportedSignature supportedSignature2 = iterator.next();
                SignatureAlgorithm signatureAlgorithm = supportedSignature2.algorithm;
                int n3 = signatureAlgorithm.getMinSdkVersion();
                if (n3 > a6) {
                    iterator2 = iterator;
                    continue;
                }
                if (n3 < n2) {
                    n2 = n3;
                }
                if ((supportedSignature = (SupportedSignature)hashMap.get(n3)) != null && ApkSigningBlockUtils.compareSignatureAlgorithm(signatureAlgorithm, supportedSignature.algorithm) <= 0) continue block0;
                hashMap.put(n3, supportedSignature2);
                continue block0;
            }
            break;
        }
        if (a5 < n2) {
            throw new NoSupportedSignaturesException(new StringBuilder().insert(0, i.ALLATORIxDEMO("\u0000{#{ g 2=`\"d$v(vma$u#s9g?wmd(`>{\"|m")).append(n2).append(ApkFormatException.ALLATORIxDEMO("CaC0\n309\b\u000b\u0006/\u00104\f3C")).append(a5).toString());
        }
        if (hashMap.isEmpty()) {
            throw new NoSupportedSignaturesException(i.ALLATORIxDEMO("\\\"2>g=b\"`9w)2>{*|,f8`("));
        }
        return hashMap.values().stream().sorted((a2, a3) -> Integer.compare(a2.algorithm.getId(), a3.algorithm.getId())).collect(Collectors.toList());
    }

    public static byte[] readLengthPrefixedByteArray(ByteBuffer a2) throws ApkFormatException {
        int n2 = a2.getInt();
        if (n2 < 0) {
            throw new ApkFormatException(ApkFormatException.ALLATORIxDEMO("-8\u0004<\u00174\u00158C1\u00063\u0004)\u000b"));
        }
        if (n2 > a2.remaining()) {
            throw new ApkFormatException(new StringBuilder().insert(0, i.ALLATORIxDEMO("\u0018|)w?t!}:2:z$~(2?w,v$|*2!w#u9z`b?w+{5w)2;s!g(<m^(|*f%(m")).append(n2).append(ApkFormatException.ALLATORIxDEMO("O}\u0002+\u00024\u000f<\u00011\u0006gC")).append(a2.remaining()).toString());
        }
        byte[] byArray = new byte[n2];
        a2.get(byArray);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ ByteBuffer ALLATORIxDEMO(ByteBuffer a2, int a32) {
        if (a32 < 0) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, i.ALLATORIxDEMO("a$h((m")).append(a32).toString());
        }
        ByteBuffer byteBuffer = a2;
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer.position();
        a32 = n3 + a32;
        if (a32 < n3 || a32 > n2) {
            throw new BufferUnderflowException();
        }
        a2.limit(a32);
        try {
            ByteBuffer byteBuffer2 = a2.slice();
            byteBuffer2.order(a2.order());
            a2.position(a32);
            ByteBuffer a32 = byteBuffer2;
            return a32;
        }
        finally {
            a2.limit(n2);
        }
    }

    public static ByteBuffer findApkSignatureSchemeBlock(ByteBuffer a2, int a3, Result a4) throws SignatureNotFoundException {
        ApkSigningBlockUtils.checkByteOrderLittleEndian(a2);
        ByteBuffer byteBuffer = a2;
        a4 = ApkSigningBlockUtils.ALLATORIxDEMO(byteBuffer, 8, byteBuffer.capacity() - 24);
        int n2 = 0;
        Object object = a4;
        while (((Buffer)object).hasRemaining()) {
            ++n2;
            if (((Buffer)a4).remaining() < 8) {
                throw new SignatureNotFoundException(new StringBuilder().insert(0, ApkFormatException.ALLATORIxDEMO("*3\u0010(\u0005;\n>\n8\r)C9\u0002)\u0002}\u00172C/\u0006<\u0007}\u00104\u00198C2\u0005}\"\r(}04\u00043\n3\u0004}!1\f>\b}\u00063\u0017/\u001a}@")).append(n2).toString());
            }
            long l2 = ((ByteBuffer)a4).getLong();
            if (l2 < 4L || l2 > Integer.MAX_VALUE) {
                throw new SignatureNotFoundException(new StringBuilder().insert(0, i.ALLATORIxDEMO("\fB\u00062\u001e{*|$|*2\u000f~\"q&2(|9`42n")).append(n2).append(ApkFormatException.ALLATORIxDEMO("}\u00104\u00198C2\u0016)C2\u0005}\u0011<\r:\u0006gC")).append(l2).toString());
            }
            int n3 = (int)l2;
            int n4 = ((Buffer)a4).position() + n3;
            if (n3 > ((Buffer)a4).remaining()) {
                throw new SignatureNotFoundException(new StringBuilder().insert(0, i.ALLATORIxDEMO("\fB\u00062\u001e{*|$|*2\u000f~\"q&2(|9`42n")).append(n2).append(ApkFormatException.ALLATORIxDEMO("}\u00104\u00198C2\u0016)C2\u0005}\u0011<\r:\u0006gC")).append(n3).append(i.ALLATORIxDEMO("a2,d,{!s/~((m")).append(((Buffer)a4).remaining()).toString());
            }
            if (((ByteBuffer)a4).getInt() == a3) {
                return ApkSigningBlockUtils.ALLATORIxDEMO((ByteBuffer)a4, n3 - 4);
            }
            Object object2 = a4;
            object = object2;
            ((ByteBuffer)object2).position(n4);
        }
        throw new SignatureNotFoundException(new StringBuilder().insert(0, ApkFormatException.ALLATORIxDEMO("\u0013\f}\"\r(}04\u00043\u0002)\u0016/\u0006}0>\u000b8\u000e8C?\u000f2\u00006C4\r}\"\r(}04\u00043\n3\u0004}!1\f>\b}\u00144\u00175C\u0014'gC")).append(a3).toString());
    }

    public static Pair<DataSource, Integer> generateApkSigningBlockPadding(DataSource a2, boolean a3) {
        int n2 = 0;
        if (a3 && a2.size() % 4096L != 0L) {
            n2 = (int)(4096L - a2.size() % 4096L);
            DataSource[] dataSourceArray = new DataSource[2];
            dataSourceArray[0] = a2;
            dataSourceArray[1] = DataSources.asDataSource(ByteBuffer.allocate(n2));
            a2 = new ChainedDataSource(dataSourceArray);
        }
        return Pair.of(a2, n2);
    }

    public static byte[] encodeAsLengthPrefixedElement(byte[] a2) {
        byte[][] byArrayArray = new byte[1][];
        byArrayArray[0] = a2;
        return ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(byArrayArray);
    }

    public static void checkByteOrderLittleEndian(ByteBuffer a2) {
        if (a2.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException(i.ALLATORIxDEMO("\u000fk9w\u000fg+t(`mp4f(2\"`)w?2 g>fmp(2!{9f!wmw#v$s#"));
        }
    }

    public static int compareSignatureAlgorithm(SignatureAlgorithm a2, SignatureAlgorithm a3) {
        ContentDigestAlgorithm contentDigestAlgorithm = a2.getContentDigestAlgorithm();
        a3 = ((SignatureAlgorithm)a3).getContentDigestAlgorithm();
        return ApkSigningBlockUtils.ALLATORIxDEMO(contentDigestAlgorithm, (ContentDigestAlgorithm)a3);
    }

    public static byte[] encodePublicKey(PublicKey a2) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray;
        byte[] byArray2 = null;
        if (ApkFormatException.ALLATORIxDEMO(";sVmZ").equals(a2.getFormat())) {
            byArray2 = a2.getEncoded();
        }
        if (byArray2 == null) {
            try {
                byArray = byArray2 = KeyFactory.getInstance(a2.getAlgorithm()).getKeySpec(a2, X509EncodedKeySpec.class).getEncoded();
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(new StringBuilder().insert(0, i.ALLATORIxDEMO("T,{!w)29}m}/f,{#2\u0015<x\"t2(|.})w)2+}?\u007fm}+2=g/~$qmy(km")).append(a2).append(ApkFormatException.ALLATORIxDEMO("}\f;C>\u000f<\u0010.C")).append(a2.getClass().getName()).toString(), invalidKeySpecException);
            }
        } else {
            byArray = byArray2;
        }
        if (byArray == null || byArray2.length == 0) {
            throw new InvalidKeyException(new StringBuilder().insert(0, i.ALLATORIxDEMO("T,{!w)29}m}/f,{#2\u0015<x\"t2(|.})w)2+}?\u007fm}+2=g/~$qmy(km")).append(a2).append(ApkFormatException.ALLATORIxDEMO("}\f;C>\u000f<\u0010.C")).append(a2.getClass().getName()).toString());
        }
        return byArray2;
    }

    public static SignatureInfo findSignature(DataSource a2, ApkUtils.ZipSections a3, int a42, Result a5) throws IOException, SignatureNotFoundException {
        DataSource dataSource;
        long l2;
        Object object;
        try {
            object = ApkUtils.findApkSigningBlock(a2, a3);
            l2 = ((ApkUtils.ApkSigningBlock)object).getStartOffset();
            dataSource = ((ApkUtils.ApkSigningBlock)object).getContents();
        }
        catch (ApkSigningBlockNotFoundException apkSigningBlockNotFoundException) {
            throw new SignatureNotFoundException(apkSigningBlockNotFoundException.getMessage(), apkSigningBlockNotFoundException);
        }
        object = dataSource.getByteBuffer(0L, (int)dataSource.size());
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer a42 = ApkSigningBlockUtils.findApkSignatureSchemeBlock((ByteBuffer)object, a42, a5);
        return new SignatureInfo(a42, l2, a3.getZipCentralDirectoryOffset(), a3.getZipEndOfCentralDirectoryOffset(), a3.getZipEndOfCentralDirectory());
    }

    public static byte[] generateApkSigningBlock(List<Pair<byte[], Integer>> a2) {
        Object object;
        Iterator<Pair<byte[], Integer>> iterator;
        int n2 = 0;
        Iterator<Pair<byte[], Integer>> iterator2 = iterator = a2.iterator();
        while (iterator2.hasNext()) {
            object = iterator.next();
            n2 += 12 + ((byte[])((Pair)object).getFirst()).length;
            iterator2 = iterator;
        }
        int n3 = 8 + n2 + 8 + 16;
        object = null;
        if (n3 % 4096 != 0) {
            n2 = 4096 - n3 % 4096;
            if (n2 < 12) {
                n2 += 4096;
            }
            object = ByteBuffer.allocate(n2).order(ByteOrder.LITTLE_ENDIAN);
            ((ByteBuffer)object).putLong(n2 - 8);
            ((ByteBuffer)object).putInt(1114793335);
            ((ByteBuffer)object).rewind();
            n3 += n2;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long l2 = (long)n3 - 8L;
        byteBuffer.putLong(l2);
        Iterator<Pair<byte[], Integer>> iterator3 = a2.iterator();
        Iterator<Pair<byte[], Integer>> iterator4 = iterator3;
        while (iterator4.hasNext()) {
            Pair<byte[], Integer> pair = iterator3.next();
            byte[] byArray = pair.getFirst();
            int n4 = pair.getSecond();
            long l3 = 4L + (long)byArray.length;
            iterator4 = iterator3;
            byteBuffer.putLong(l3);
            byteBuffer.putInt(n4);
            byteBuffer.put(byArray);
        }
        if (object != null) {
            byteBuffer.put((ByteBuffer)object);
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        byteBuffer2.putLong(l2);
        byteBuffer.put(APK_SIGNING_BLOCK_MAGIC);
        return byteBuffer2.array();
    }

    private static /* synthetic */ void ALLATORIxDEMO(Set<ContentDigestAlgorithm> a2, DataSource[] a32, Map<ContentDigestAlgorithm, byte[]> a4) throws IOException, NoSuchAlgorithmException, DigestException {
        int n2;
        Object[] objectArray;
        int n3;
        Object object;
        int n4;
        Object object2;
        int n5;
        long l2 = 0L;
        DataSource[] dataSourceArray = a32;
        int n6 = a32.length;
        int n7 = n5 = 0;
        while (n7 < n6) {
            object2 = dataSourceArray[n5];
            l2 += ApkSigningBlockUtils.ALLATORIxDEMO(object2.size(), 0x100000);
            n7 = ++n5;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new DigestException(new StringBuilder().insert(0, i.ALLATORIxDEMO("[#b8fmf\"}m~\"|*(m")).append(l2).append(ApkFormatException.ALLATORIxDEMO("C>\u000b(\r6\u0010")).toString());
        }
        int n8 = (int)l2;
        Set<ContentDigestAlgorithm> set = a2;
        ContentDigestAlgorithm[] contentDigestAlgorithmArray = set.toArray(new ContentDigestAlgorithm[set.size()]);
        MessageDigest[] messageDigestArray = new MessageDigest[contentDigestAlgorithmArray.length];
        object2 = new byte[contentDigestAlgorithmArray.length][];
        int[] nArray = new int[contentDigestAlgorithmArray.length];
        int n9 = n4 = 0;
        while (n9 < contentDigestAlgorithmArray.length) {
            ContentDigestAlgorithm contentDigestAlgorithm = object = contentDigestAlgorithmArray[n4];
            nArray[n4] = n3 = contentDigestAlgorithm.ALLATORIxDEMO();
            objectArray = new byte[5 + n8 * n3];
            objectArray[0] = (DataSource)90;
            ApkSigningBlockUtils.ALLATORIxDEMO(n8, (byte[])objectArray, 1);
            object2[n4] = objectArray;
            String string = contentDigestAlgorithm.ALLATORIxDEMO();
            messageDigestArray[n4++] = MessageDigest.getInstance(string);
            n9 = n4;
        }
        DataSink dataSink = DataSinks.asDataSink(messageDigestArray);
        object = new byte[5];
        object[0] = (ContentDigestAlgorithm)-91;
        n3 = 0;
        objectArray = a32;
        int n10 = a32.length;
        int n11 = a32 = 0;
        while (n11 < n10) {
            DataSource dataSource = objectArray[a32];
            l2 = 0L;
            long l3 = dataSource.size();
            while (l3 > 0L) {
                int n12;
                long l4;
                int n13 = (int)Math.min(l4, 0x100000L);
                ApkSigningBlockUtils.ALLATORIxDEMO(n13, (byte[])object, 1);
                int n14 = n12 = 0;
                while (n14 < messageDigestArray.length) {
                    messageDigestArray[n12++].update((byte[])object);
                    n14 = n12;
                }
                try {
                    dataSource.feed(l2, n13, dataSink);
                }
                catch (IOException iOException) {
                    throw new IOException(new StringBuilder().insert(0, i.ALLATORIxDEMO("T,{!w)29}m`(s)2.z8|&2n")).append(n3).toString(), iOException);
                }
                int n15 = n12 = 0;
                while (n15 < contentDigestAlgorithmArray.length) {
                    MessageDigest messageDigest = messageDigestArray[n12];
                    Object object3 = object2[n12];
                    int n16 = nArray[n12];
                    int n17 = messageDigest.digest((byte[])object3, 5 + n3 * n16, n16);
                    if (n17 != n16) {
                        throw new RuntimeException(new StringBuilder().insert(0, ApkFormatException.ALLATORIxDEMO("\b\r8\u001b-\u0006>\u00178\u0007}\f(\u0017-\u0016)C.\n'\u0006}\f;C")).append(messageDigest.getAlgorithm()).append(i.ALLATORIxDEMO("mv$u(a9(m")).append(n17).toString());
                    }
                    n15 = ++n12;
                }
                l2 += (long)n13;
                ++n3;
                l3 = l4 -= (long)n13;
            }
            n11 = ++a32;
        }
        int n18 = n2 = 0;
        while (n18 < contentDigestAlgorithmArray.length) {
            ContentDigestAlgorithm contentDigestAlgorithm = contentDigestAlgorithmArray[n2];
            Object a32 = object2[n2];
            MessageDigest messageDigest = messageDigestArray[n2];
            byte[] byArray = messageDigest.digest((byte[])a32);
            a4.put(contentDigestAlgorithm, byArray);
            n18 = ++n2;
        }
    }

    public static class SupportedSignature {
        public final SignatureAlgorithm algorithm;
        public final byte[] signature;

        public SupportedSignature(SignatureAlgorithm a2, byte[] a3) {
            SupportedSignature a4;
            SupportedSignature supportedSignature = a4;
            supportedSignature.algorithm = a2;
            supportedSignature.signature = a3;
        }
    }

    public static class Result {
        public final List<SignerInfo> signers;
        public final int signatureSchemeVersion;
        private final List<ApkVerifier.IssueWithParams> b;
        public SigningCertificateLineage signingCertificateLineage;
        public boolean verified;
        private final List<ApkVerifier.IssueWithParams> ALLATORIxDEMO;

        public void addError(ApkVerifier.Issue a2, Object ... a3) {
            Result a4;
            a4.b.add(new ApkVerifier.IssueWithParams(a2, a3));
        }

        public boolean containsErrors() {
            Result a2;
            if (!a2.b.isEmpty()) {
                return true;
            }
            if (!a2.signers.isEmpty()) {
                Iterator<SignerInfo> iterator = a2.signers.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().containsErrors()) continue;
                    return true;
                }
            }
            return false;
        }

        public Result(int a2) {
            Result a3;
            Result result = a3;
            Result result2 = a3;
            a3.signers = new ArrayList<SignerInfo>();
            a3.signingCertificateLineage = null;
            result.ALLATORIxDEMO = new ArrayList<ApkVerifier.IssueWithParams>();
            result.b = new ArrayList<ApkVerifier.IssueWithParams>();
            result.signatureSchemeVersion = a2;
        }

        public void addWarning(ApkVerifier.Issue a2, Object ... a3) {
            Result a4;
            a4.ALLATORIxDEMO.add(new ApkVerifier.IssueWithParams(a2, a3));
        }

        public List<ApkVerifier.IssueWithParams> getWarnings() {
            Result a2;
            return a2.ALLATORIxDEMO;
        }

        public List<ApkVerifier.IssueWithParams> getErrors() {
            Result a2;
            return a2.b;
        }

        public static class SignerInfo {
            private final List<ApkVerifier.IssueWithParams> b;
            private final List<ApkVerifier.IssueWithParams> ALLATORIxDEMO;
            public Map<SignatureAlgorithm, byte[]> verifiedSignatures;
            public List<X509Certificate> certs;
            public List<ContentDigest> contentDigests;
            public byte[] signedData;
            public Map<ContentDigestAlgorithm, byte[]> verifiedContentDigests;
            public SigningCertificateLineage signingCertificateLineage;
            public int index;
            public int minSdkVersion;
            public List<AdditionalAttribute> additionalAttributes;
            public int maxSdkVersion;
            public List<Signature> signatures;

            public SignerInfo() {
                SignerInfo a2;
                SignerInfo signerInfo = a2;
                a2.certs = new ArrayList<X509Certificate>();
                signerInfo.contentDigests = new ArrayList<ContentDigest>();
                a2.verifiedContentDigests = new HashMap<ContentDigestAlgorithm, byte[]>();
                a2.signatures = new ArrayList<Signature>();
                a2.verifiedSignatures = new HashMap<SignatureAlgorithm, byte[]>();
                a2.additionalAttributes = new ArrayList<AdditionalAttribute>();
                a2.ALLATORIxDEMO = new ArrayList<ApkVerifier.IssueWithParams>();
                a2.b = new ArrayList<ApkVerifier.IssueWithParams>();
            }

            public void addWarning(ApkVerifier.Issue a2, Object ... a3) {
                SignerInfo a4;
                a4.ALLATORIxDEMO.add(new ApkVerifier.IssueWithParams(a2, a3));
            }

            public List<ApkVerifier.IssueWithParams> getWarnings() {
                SignerInfo a2;
                return a2.ALLATORIxDEMO;
            }

            public boolean containsErrors() {
                SignerInfo a2;
                return !a2.b.isEmpty();
            }

            public List<ApkVerifier.IssueWithParams> getErrors() {
                SignerInfo a2;
                return a2.b;
            }

            public void addError(ApkVerifier.Issue a2, Object ... a3) {
                SignerInfo a4;
                a4.b.add(new ApkVerifier.IssueWithParams(a2, a3));
            }

            public static class AdditionalAttribute {
                private final byte[] b;
                private final int ALLATORIxDEMO;

                public AdditionalAttribute(int a2, byte[] a3) {
                    AdditionalAttribute a4;
                    AdditionalAttribute additionalAttribute = a4;
                    additionalAttribute.ALLATORIxDEMO = a2;
                    additionalAttribute.b = (byte[])a3.clone();
                }

                public byte[] getValue() {
                    AdditionalAttribute a2;
                    return (byte[])a2.b.clone();
                }

                public int getId() {
                    AdditionalAttribute a2;
                    return a2.ALLATORIxDEMO;
                }
            }

            public static class Signature {
                private final byte[] b;
                private final int ALLATORIxDEMO;

                public byte[] getValue() {
                    Signature a2;
                    return a2.b;
                }

                public Signature(int a2, byte[] a3) {
                    Signature a4;
                    Signature signature = a4;
                    signature.ALLATORIxDEMO = a2;
                    signature.b = a3;
                }

                public int getAlgorithmId() {
                    Signature a2;
                    return a2.ALLATORIxDEMO;
                }
            }

            public static class ContentDigest {
                private final byte[] b;
                private final int ALLATORIxDEMO;

                public ContentDigest(int a2, byte[] a3) {
                    ContentDigest a4;
                    ContentDigest contentDigest = a4;
                    contentDigest.ALLATORIxDEMO = a2;
                    contentDigest.b = a3;
                }

                public byte[] getValue() {
                    ContentDigest a2;
                    return a2.b;
                }

                public int getSignatureAlgorithmId() {
                    ContentDigest a2;
                    return a2.ALLATORIxDEMO;
                }
            }
        }
    }

    public static class SignerConfig {
        public int maxSdkVersion;
        public PrivateKey privateKey;
        public SigningCertificateLineage mSigningCertificateLineage;
        public int minSdkVersion;
        public List<X509Certificate> certificates;
        public List<SignatureAlgorithm> signatureAlgorithms;

        public SignerConfig() {
            SignerConfig a2;
        }
    }

    public static class SignatureNotFoundException
    extends Exception {
        private static final long ALLATORIxDEMO = 1L;

        public SignatureNotFoundException(String a2, Throwable a3) {
            super(a2, a3);
            SignatureNotFoundException a4;
        }

        public SignatureNotFoundException(String a2) {
            super(a2);
            SignatureNotFoundException a3;
        }
    }

    public static class NoSupportedSignaturesException
    extends Exception {
        private static final long ALLATORIxDEMO = 1L;

        public NoSupportedSignaturesException(String a2) {
            super(a2);
            NoSupportedSignaturesException a3;
        }
    }
}

