/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVA;
import sun.security.x509.AVAComparator;
import sun.security.x509.X500Name;

public class RDN {
    final AVA[] assertion;
    private volatile List<AVA> avaList;
    private volatile String canonicalString;

    public RDN(String string) throws IOException {
        this(string, Collections.emptyMap());
    }

    public RDN(String string, Map<String, String> map) throws IOException {
        AVA aVA;
        String string2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        ArrayList<AVA> arrayList = new ArrayList<AVA>(3);
        int n4 = string.indexOf(43);
        while (n4 >= 0) {
            if (n4 > 0 && string.charAt(n4 - 1) != '\\' && (n += X500Name.countQuotes(string, n2, n4)) != 1) {
                string2 = string.substring(n3, n4);
                if (string2.length() == 0) {
                    throw new IOException("empty AVA in RDN \"" + string + "\"");
                }
                aVA = new AVA((Reader)new StringReader(string2), map);
                arrayList.add(aVA);
                n3 = n4 + 1;
                n = 0;
            }
            n2 = n4 + 1;
            n4 = string.indexOf(43, n2);
        }
        string2 = string.substring(n3);
        if (string2.length() == 0) {
            throw new IOException("empty AVA in RDN \"" + string + "\"");
        }
        aVA = new AVA((Reader)new StringReader(string2), map);
        arrayList.add(aVA);
        this.assertion = arrayList.toArray(new AVA[arrayList.size()]);
    }

    RDN(String string, String string2) throws IOException {
        this(string, string2, Collections.emptyMap());
    }

    RDN(String string, String string2, Map<String, String> map) throws IOException {
        AVA aVA;
        String string3;
        if (!string2.equalsIgnoreCase("RFC2253")) {
            throw new IOException("Unsupported format " + string2);
        }
        int n = 0;
        int n2 = 0;
        ArrayList<AVA> arrayList = new ArrayList<AVA>(3);
        int n3 = string.indexOf(43);
        while (n3 >= 0) {
            if (n3 > 0 && string.charAt(n3 - 1) != '\\') {
                string3 = string.substring(n2, n3);
                if (string3.length() == 0) {
                    throw new IOException("empty AVA in RDN \"" + string + "\"");
                }
                aVA = new AVA(new StringReader(string3), 3, map);
                arrayList.add(aVA);
                n2 = n3 + 1;
            }
            n = n3 + 1;
            n3 = string.indexOf(43, n);
        }
        string3 = string.substring(n2);
        if (string3.length() == 0) {
            throw new IOException("empty AVA in RDN \"" + string + "\"");
        }
        aVA = new AVA(new StringReader(string3), 3, map);
        arrayList.add(aVA);
        this.assertion = arrayList.toArray(new AVA[arrayList.size()]);
    }

    RDN(DerValue derValue) throws IOException {
        if (derValue.tag != 49) {
            throw new IOException("X500 RDN");
        }
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSet(5);
        this.assertion = new AVA[derValueArray.length];
        for (int i = 0; i < derValueArray.length; ++i) {
            this.assertion[i] = new AVA(derValueArray[i]);
        }
    }

    RDN(int n) {
        this.assertion = new AVA[n];
    }

    public RDN(AVA aVA) {
        if (aVA == null) {
            throw new NullPointerException();
        }
        this.assertion = new AVA[]{aVA};
    }

    public RDN(AVA[] aVAArray) {
        this.assertion = (AVA[])aVAArray.clone();
        for (int i = 0; i < this.assertion.length; ++i) {
            if (this.assertion[i] != null) continue;
            throw new NullPointerException();
        }
    }

    public List<AVA> avas() {
        List<AVA> list = this.avaList;
        if (list == null) {
            this.avaList = list = Collections.unmodifiableList(Arrays.asList(this.assertion));
        }
        return list;
    }

    public int size() {
        return this.assertion.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RDN)) {
            return false;
        }
        RDN rDN = (RDN)object;
        if (this.assertion.length != rDN.assertion.length) {
            return false;
        }
        String string = this.toRFC2253String(true);
        String string2 = rDN.toRFC2253String(true);
        return string.equals(string2);
    }

    public int hashCode() {
        return this.toRFC2253String(true).hashCode();
    }

    DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        for (int i = 0; i < this.assertion.length; ++i) {
            if (!this.assertion[i].oid.equals((Object)objectIdentifier)) continue;
            return this.assertion[i].value;
        }
        return null;
    }

    void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOrderedSetOf((byte)49, this.assertion);
    }

    public String toString() {
        if (this.assertion.length == 1) {
            return this.assertion[0].toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.assertion.length; ++i) {
            if (i != 0) {
                stringBuilder.append(" + ");
            }
            stringBuilder.append(this.assertion[i].toString());
        }
        return stringBuilder.toString();
    }

    public String toRFC1779String() {
        return this.toRFC1779String(Collections.emptyMap());
    }

    public String toRFC1779String(Map<String, String> map) {
        if (this.assertion.length == 1) {
            return this.assertion[0].toRFC1779String(map);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.assertion.length; ++i) {
            if (i != 0) {
                stringBuilder.append(" + ");
            }
            stringBuilder.append(this.assertion[i].toRFC1779String(map));
        }
        return stringBuilder.toString();
    }

    public String toRFC2253String() {
        return this.toRFC2253StringInternal(false, Collections.emptyMap());
    }

    public String toRFC2253String(Map<String, String> map) {
        return this.toRFC2253StringInternal(false, map);
    }

    public String toRFC2253String(boolean bl) {
        if (!bl) {
            return this.toRFC2253StringInternal(false, Collections.emptyMap());
        }
        String string = this.canonicalString;
        if (string == null) {
            this.canonicalString = string = this.toRFC2253StringInternal(true, Collections.emptyMap());
        }
        return string;
    }

    private String toRFC2253StringInternal(boolean bl, Map<String, String> map) {
        if (this.assertion.length == 1) {
            return bl ? this.assertion[0].toRFC2253CanonicalString() : this.assertion[0].toRFC2253String(map);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            for (int i = 0; i < this.assertion.length; ++i) {
                if (i > 0) {
                    stringBuilder.append('+');
                }
                stringBuilder.append(this.assertion[i].toRFC2253String(map));
            }
        } else {
            int n;
            ArrayList<AVA> arrayList = new ArrayList<AVA>(this.assertion.length);
            for (n = 0; n < this.assertion.length; ++n) {
                arrayList.add(this.assertion[n]);
            }
            Collections.sort(arrayList, AVAComparator.getInstance());
            for (n = 0; n < arrayList.size(); ++n) {
                if (n > 0) {
                    stringBuilder.append('+');
                }
                stringBuilder.append(((AVA)arrayList.get(n)).toRFC2253CanonicalString());
            }
        }
        return stringBuilder.toString();
    }
}

