/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.keyvalues;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.KeyValueContent;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RSAKeyValue
extends SignatureElementProxy
implements KeyValueContent {
    public RSAKeyValue(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public RSAKeyValue(Document document, BigInteger bigInteger, BigInteger bigInteger2) {
        super(document);
        XMLUtils.addReturnToElement(this.constructionElement);
        this.addBigIntegerElement(bigInteger, "Modulus");
        this.addBigIntegerElement(bigInteger2, "Exponent");
    }

    public RSAKeyValue(Document document, Key key) throws IllegalArgumentException {
        super(document);
        XMLUtils.addReturnToElement(this.constructionElement);
        if (!(key instanceof RSAPublicKey)) {
            Object[] objectArray = new Object[]{"RSAKeyValue", key.getClass().getName()};
            throw new IllegalArgumentException(I18n.translate("KeyValue.IllegalArgument", objectArray));
        }
        this.addBigIntegerElement(((RSAPublicKey)key).getModulus(), "Modulus");
        this.addBigIntegerElement(((RSAPublicKey)key).getPublicExponent(), "Exponent");
    }

    @Override
    public PublicKey getPublicKey() throws XMLSecurityException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(this.getBigIntegerFromChildElement("Modulus", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("Exponent", "http://www.w3.org/2000/09/xmldsig#"));
            PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLSecurityException("empty", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new XMLSecurityException("empty", invalidKeySpecException);
        }
    }

    @Override
    public String getBaseLocalName() {
        return "RSAKeyValue";
    }
}

