/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding.util.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class Logger {
    private static final Map<String, Logger> loggerMapByName = new HashMap<String, Logger>();
    @Nonnull
    private final java.util.logging.Logger logger;

    Logger(@Nonnull java.util.logging.Logger logger) {
        this.logger = logger;
    }

    @Nonnull
    public static synchronized Logger getLogger(@Nonnull String name) {
        Logger logger = loggerMapByName.get(name);
        if (logger == null) {
            logger = new Logger(java.util.logging.Logger.getLogger(name));
            loggerMapByName.put(name, logger);
        }
        return logger;
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.logger.throwing(sourceClass, sourceMethod, thrown);
    }

    public void severe(@Nonnull String string, Object ... args) {
        this.log(Level.SEVERE, string, args);
    }

    public void warning(@Nonnull String string, Object ... args) {
        this.log(Level.WARNING, string, args);
    }

    public void info(@Nonnull String string, Object ... args) {
        this.log(Level.INFO, string, args);
    }

    public void fine(@Nonnull String string, Object ... args) {
        this.log(Level.FINE, string, args);
    }

    public void finer(@Nonnull String string, Object ... args) {
        this.log(Level.FINER, string, args);
    }

    public void finest(@Nonnull String string, Object ... args) {
        this.log(Level.FINEST, string, args);
    }

    private void log(@Nonnull Level level, @Nonnull String string, Object ... args) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, String.format(string, args));
        }
    }

    public void setLevel(Level level) throws SecurityException {
        this.logger.setLevel(level);
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public String getName() {
        return this.logger.getName();
    }

    public Level getLevel() {
        return this.logger.getLevel();
    }

    public synchronized Handler[] getHandlers() {
        return this.logger.getHandlers();
    }
}

