/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.PropertyStateEvent;
import org.jdesktop.beansbinding.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoBinding<SS, SV, TS, TV>
extends Binding<SS, SV, TS, TV> {
    private UpdateStrategy strategy;

    protected AutoBinding(@Nonnull UpdateStrategy strategy, @Nonnull SS sourceObject, @Nonnull Property<SS, SV> sourceProperty, @Nonnull TS targetObject, @Nonnull Property<TS, TV> targetProperty, @CheckForNull String name) {
        super(sourceObject, sourceProperty, targetObject, targetProperty, name);
        Parameters.checkNotNull((Object)strategy, "strategy");
        this.strategy = strategy;
    }

    public final UpdateStrategy getUpdateStrategy() {
        return this.strategy;
    }

    private final void tryRefreshThenSave() {
        Binding.SyncFailure refreshFailure = this.refresh();
        if (refreshFailure == null) {
            this.notifySynced();
        } else {
            Binding.SyncFailure saveFailure = this.save();
            if (saveFailure == null) {
                this.notifySynced();
            } else {
                this.notifySyncFailed(refreshFailure);
            }
        }
    }

    private final void trySaveThenRefresh() {
        Binding.SyncFailure saveFailure = this.save();
        if (saveFailure == null) {
            this.notifySynced();
        } else if (saveFailure.getType() == Binding.SyncFailureType.CONVERSION_FAILED || saveFailure.getType() == Binding.SyncFailureType.VALIDATION_FAILED) {
            this.notifySyncFailed(saveFailure);
        } else {
            Binding.SyncFailure refreshFailure = this.refresh();
            if (refreshFailure == null) {
                this.notifySynced();
            } else {
                this.notifySyncFailed(saveFailure);
            }
        }
    }

    @Override
    protected void bindImpl() {
        UpdateStrategy strat = this.getUpdateStrategy();
        if (strat == UpdateStrategy.READ_ONCE) {
            this.refreshAndNotify();
        } else if (strat == UpdateStrategy.READ) {
            this.refreshAndNotify();
        } else {
            this.tryRefreshThenSave();
        }
    }

    @Override
    protected void unbindImpl() {
    }

    @Override
    protected String paramString() {
        return super.paramString() + ", updateStrategy=" + (Object)((Object)this.getUpdateStrategy());
    }

    @Override
    protected void sourceChangedImpl(PropertyStateEvent pse) {
        if (this.strategy != UpdateStrategy.READ_ONCE) {
            if (this.strategy == UpdateStrategy.READ) {
                if (pse.getValueChanged()) {
                    this.refreshAndNotify();
                }
            } else if (this.strategy == UpdateStrategy.READ_WRITE) {
                if (pse.getValueChanged()) {
                    this.tryRefreshThenSave();
                } else if (pse.isWriteable()) {
                    this.saveAndNotify();
                }
            }
        }
    }

    @Override
    protected void targetChangedImpl(PropertyStateEvent pse) {
        if (this.strategy != UpdateStrategy.READ_ONCE) {
            if (this.strategy == UpdateStrategy.READ) {
                if (pse.getWriteableChanged() && pse.isWriteable()) {
                    this.refreshAndNotify();
                }
            } else if (this.strategy == UpdateStrategy.READ_WRITE) {
                if (pse.getWriteableChanged() && pse.isWriteable()) {
                    if (pse.getValueChanged()) {
                        this.tryRefreshThenSave();
                    } else {
                        this.refreshAndNotify();
                    }
                } else if (pse.getValueChanged()) {
                    this.trySaveThenRefresh();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateStrategy {
        READ_ONCE,
        READ,
        READ_WRITE;

    }
}

