/*
 * Decompiled with CFR 0.152.
 */
package com.zend.verifier.utils;

import com.zend.verifier.Verifier;
import com.zend.verifier.utils.ProvisioningHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.osgi.framework.Version;

public class ProductInfo {
    public static final String PDT_PRODUCT_IU = "org.zend.php.product";
    public static final String STUDIO_IU_FEATURE = "com.zend.php.ide.feature.group";
    public static final String STUDIO_IU = "com.zend.php.ide";
    static final String ORG_ZEND_PHP_CUSTOMIZATION_SITE_URL = "org.zend.php.customization.site.url";
    static final String COM_ZEND_PHP_CUSTOMIZATION_SITE_URL = "com.zend.php.customization.site.url";

    public static boolean isStudio() {
        return STUDIO_IU.equals(Platform.getProduct().getId());
    }

    public static boolean isPDT() {
        return PDT_PRODUCT_IU.equals(Platform.getProduct().getId());
    }

    public static Version getVersion() {
        String productId;
        IProduct product = Platform.getProduct();
        if (product != null && (productId = Platform.getProduct().getId()) != null && !productId.isEmpty()) {
            return ProductInfo.getVersion(productId);
        }
        return Verifier.getDefault().getBundle().getVersion();
    }

    public static Version getVersion(String productId) {
        Iterator<IInstallableUnit> iterator;
        Set<IInstallableUnit> results = ProvisioningHelper.getIUFromProfile(productId);
        if (results != null && (iterator = results.iterator()).hasNext()) {
            IInstallableUnit item = iterator.next();
            return Version.parseVersion((String)item.getVersion().toString());
        }
        return Platform.getProduct().getDefiningBundle().getVersion();
    }

    public static String getLicense(String productId) {
        Set<IInstallableUnit> results = ProvisioningHelper.getIUFromProfile(productId);
        for (IInstallableUnit item : results) {
            Collection licenses = item.getLicenses();
            Iterator iterator = licenses.iterator();
            if (!iterator.hasNext()) continue;
            ILicense iLicense = (ILicense)iterator.next();
            return iLicense.toString();
        }
        return "";
    }

    public static String getReleaseNotesURL() {
        Version version = ProductInfo.getVersion();
        String productVersion = String.format("%s.%s.%s", version.getMajor(), version.getMinor(), version.getMicro());
        if (ProductInfo.isBeta()) {
            productVersion = String.valueOf(productVersion) + "-ea";
        }
        return String.format("http://www.zend.com/studio/zend-studio-%s-release-notes.txt", productVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isBeta() {
        try {
            URI[] uRIArray = ProductInfo.getSiteUris();
            int n = uRIArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                URI uri = uRIArray[n2];
                if (uri.toString().endsWith("/EA")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (URISyntaxException e) {
            Verifier.log(e);
        }
        return false;
    }

    public static URI[] getSiteUris() throws URISyntaxException {
        String uri = System.getProperty(COM_ZEND_PHP_CUSTOMIZATION_SITE_URL);
        if (uri == null) {
            uri = System.getProperty(ORG_ZEND_PHP_CUSTOMIZATION_SITE_URL);
        }
        if (uri == null) {
            return new URI[0];
        }
        String[] uris = uri.split(",");
        URI[] result = new URI[uris.length];
        int i = 0;
        while (i < uris.length) {
            result[i] = new URI(uris[i]);
            ++i;
        }
        return result;
    }
}

