/*
 * Decompiled with CFR 0.152.
 */
package com.zend.verifier.license;

import com.zend.verifier.Verifier;
import com.zend.verifier.license.ILicense;
import com.zend.verifier.license.LicensePolicy;
import com.zend.verifier.license.LicenseStatus;
import com.zend.verifier.license.SKU;
import com.zend.verifier.utils.ProductInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Version;

public class LicenseUtil {
    public static Version getProductVersion() {
        return ProductInfo.getVersion();
    }

    public static String getProductVersionAsString() {
        Version productVersion = LicenseUtil.getProductVersion();
        return String.valueOf(productVersion.getMajor()) + "." + productVersion.getMinor();
    }

    public static Date getMainVersionReleaseDate(Version productVersion) {
        Pattern pattern = Pattern.compile("v(\\d{8})");
        Matcher matcher = pattern.matcher(productVersion.getQualifier());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        if (matcher.find() && matcher.groupCount() >= 1) {
            try {
                return simpleDateFormat.parse(matcher.group(1));
            }
            catch (ParseException e) {
                Verifier.log(e);
            }
        }
        if (Platform.inDevelopmentMode()) {
            return new Date();
        }
        return null;
    }

    public static URL getProductURL() throws MalformedURLException {
        return new URL("http://www.zend.com/en/store/software/studio/eclipse");
    }

    public static boolean isSystem5() {
        LicensePolicy policy = LicensePolicy.getDefaultLicensePolicy();
        try {
            String version = LicenseUtil.getProductVersionAsString();
            LicenseStatus s = policy.getCurrentLicenseStatus(version);
            if (s == LicenseStatus.LICENSED) {
                ILicense l = policy.validateCurrentLicense(version);
                return l.getSKU() == SKU.IBM;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public static boolean isFeatureLicensed(String fFeatureID, String fFeatureVersion) {
        return true;
    }
}

