/*
 * Decompiled with CFR 0.152.
 */
package com.zend.verifier.license;

import com.zend.verifier.license.ILicense;
import com.zend.verifier.license.InvalidLicenseException;
import com.zend.verifier.license.LicenseKey;
import com.zend.verifier.license.LicenseStatus;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LicensePolicy {
    public static final String EVAL = "eval";
    public static final int EVALUATOR_FIRST_BYTE = 9;
    private final String home;
    private static final LicensePolicy policy = new LicensePolicy();

    private LicensePolicy(String home) {
        this.home = home;
    }

    private LicensePolicy() {
        this(System.getProperty("user.home"));
    }

    public static LicensePolicy getDefaultLicensePolicy() {
        return policy;
    }

    public synchronized LicenseStatus getCurrentLicenseStatus(String version) throws IOException {
        File dir = this.getLicenseDirectory();
        if (!dir.isDirectory()) {
            return LicenseStatus.NO_LICENSE;
        }
        File file = this.getLicenseFile(version);
        if (!file.isFile()) {
            return LicenseStatus.NO_LICENSE;
        }
        byte[] b = this.file_get_content(file);
        if (b[0] == 9) {
            return LicenseStatus.TRIAL;
        }
        return LicenseStatus.LICENSED;
    }

    public synchronized ILicense validateCurrentLicense(String version) throws InvalidLicenseException, IOException {
        File file = this.getLicenseFile(version);
        byte[] keyByte = this.file_get_content(file);
        String key = new String(keyByte);
        LicenseKey licenseKey = new LicenseKey(key);
        return licenseKey;
    }

    public File getLicenseFile(String version) {
        File dir = this.getLicenseDirectory();
        dir.mkdir();
        if (EVAL.equals(version)) {
            return new File(dir, EVAL);
        }
        File f = new File(dir, "0_0");
        if (f.exists()) {
            return f;
        }
        final Pattern pattern = Pattern.compile("(\\d{1,2})");
        File[] listOfFiles = dir.listFiles();
        List<File> oldLicenses = Arrays.asList(listOfFiles);
        if (!oldLicenses.isEmpty()) {
            Collections.sort(oldLicenses, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    Integer i1 = 0;
                    Integer i2 = 0;
                    Matcher matcher = pattern.matcher(f1.getName());
                    if (matcher.find()) {
                        i1 = Integer.parseInt(matcher.group(1));
                    }
                    if ((matcher = pattern.matcher(f2.getName())).find()) {
                        i2 = Integer.parseInt(matcher.group(1));
                    }
                    return i2.compareTo(i1);
                }
            });
            return oldLicenses.get(0);
        }
        Matcher matcher = pattern.matcher(version);
        if (matcher.find()) {
            return new File(dir, matcher.group(1).concat("_0"));
        }
        return new File(dir, version.replace(".", "_"));
    }

    public File getLicenseDirectory() {
        File dir = new File(String.valueOf(this.home) + "/.ZendStudio/");
        return dir;
    }

    public byte[] file_get_content(File file) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(fis);
        byte[] b = new byte[(int)file.length()];
        dis.readFully(b);
        dis.close();
        return b;
    }
}

