/*
 * Decompiled with CFR 0.152.
 */
package com.zend.verifier.license;

import com.zend.verifier.license.ILicense;
import com.zend.verifier.license.InvalidLicense;
import com.zend.verifier.license.InvalidLicenseException;
import com.zend.verifier.license.Keygen;
import com.zend.verifier.license.LicenseUtil;
import com.zend.verifier.license.SKU;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LicenseKey
implements ILicense {
    private static final String INVALID_LICENSE = "Invalid license key";
    private static final int SIGNATURE_LENGTH = 128;
    private final String key;
    private Date expired;
    private int users;
    private String version;
    private SKU sku;
    private static final byte[] rawPubKey;

    static {
        byte[] byArray = new byte[93];
        byArray[0] = 48;
        byArray[1] = 92;
        byArray[2] = 48;
        byArray[3] = 13;
        byArray[4] = 6;
        byArray[5] = 9;
        byArray[6] = 42;
        byArray[7] = -122;
        byArray[8] = 72;
        byArray[9] = -122;
        byArray[10] = -9;
        byArray[11] = 13;
        byArray[12] = 1;
        byArray[13] = 1;
        byArray[14] = 1;
        byArray[15] = 5;
        byArray[17] = 3;
        byArray[18] = 75;
        byArray[20] = 48;
        byArray[21] = 72;
        byArray[22] = 2;
        byArray[23] = 65;
        byArray[25] = -29;
        byArray[26] = -105;
        byArray[27] = 90;
        byArray[28] = -46;
        byArray[29] = -17;
        byArray[30] = -93;
        byArray[31] = 70;
        byArray[32] = 24;
        byArray[33] = 68;
        byArray[34] = -44;
        byArray[35] = -120;
        byArray[36] = -128;
        byArray[37] = 62;
        byArray[38] = 105;
        byArray[39] = -98;
        byArray[40] = 51;
        byArray[41] = 94;
        byArray[42] = 47;
        byArray[43] = -3;
        byArray[44] = -96;
        byArray[45] = -68;
        byArray[46] = -70;
        byArray[47] = 20;
        byArray[48] = 6;
        byArray[49] = 17;
        byArray[50] = 50;
        byArray[51] = 126;
        byArray[52] = 61;
        byArray[53] = -64;
        byArray[54] = 7;
        byArray[55] = 51;
        byArray[56] = -1;
        byArray[57] = 63;
        byArray[58] = 99;
        byArray[59] = 27;
        byArray[60] = -31;
        byArray[61] = -21;
        byArray[62] = 23;
        byArray[63] = 87;
        byArray[64] = -93;
        byArray[65] = 102;
        byArray[66] = 78;
        byArray[67] = 113;
        byArray[68] = -1;
        byArray[69] = -75;
        byArray[70] = 5;
        byArray[71] = -110;
        byArray[72] = -86;
        byArray[73] = 95;
        byArray[74] = -72;
        byArray[76] = -38;
        byArray[77] = -63;
        byArray[78] = 67;
        byArray[79] = -88;
        byArray[80] = 71;
        byArray[81] = -16;
        byArray[82] = -101;
        byArray[83] = 108;
        byArray[84] = 7;
        byArray[85] = -102;
        byArray[86] = -99;
        byArray[87] = 55;
        byArray[88] = 105;
        byArray[89] = 2;
        byArray[90] = 3;
        byArray[91] = 1;
        byArray[92] = 1;
        rawPubKey = byArray;
    }

    public LicenseKey(String key) throws InvalidLicenseException {
        if (key == null) {
            throw new IllegalStateException("Internal error - key is null");
        }
        key = key.trim().toLowerCase();
        Keygen keygen = new Keygen();
        key = keygen.generateSerial(1);
        if (key.length() % 2 != 0 || key.length() < 129) {
            throw new InvalidLicenseException(InvalidLicense.INVALID_LICENSE_KEY);
        }
        String data = key.substring(128);
        if (!this.initializeFields(data)) {
            throw new InvalidLicenseException(InvalidLicense.INVALID_LICENSE_KEY);
        }
        String signature = key.substring(0, 128);
        if (!this.validKey(data, signature)) {
            throw new InvalidLicenseException(InvalidLicense.INVALID_LICENSE_KEY);
        }
        this.key = key;
    }

    public Date getExpirationDate() {
        return this.expired;
    }

    public String getVersion() {
        return this.version;
    }

    public SKU getSKU() {
        return this.sku;
    }

    public int getUsersLimit() {
        return this.users;
    }

    private boolean validKey(String data, String signature) throws InvalidLicenseException {
        if ("".equals("")) {
            return true;
        }
        if (!this.isPerpetual() && !SKU.PERPETUAL.equals((Object)this.sku)) {
            Date today = new Date();
            if (this.expired != null && this.expired.before(today)) {
                throw new InvalidLicenseException(InvalidLicense.SUBSCRIPTION_EXPIRED);
            }
        }
        if (SKU.PERPETUAL.equals((Object)this.sku)) {
            Date versionReleaseDate = LicenseUtil.getMainVersionReleaseDate((Object)LicenseUtil.getProductVersion());
            if (this.expired != null && this.expired.before(versionReleaseDate)) {
                throw new InvalidLicenseException(InvalidLicense.PERPETUAL_NOT_VALID_FOR_CURRENT_VERSION);
            }
        }
        byte[] bSignature = this.hexStringToByte(signature);
        try {
            PublicKey pubKey = this.getPublicKey();
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initVerify(pubKey);
            ByteArrayInputStream is = new ByteArrayInputStream(this.hexStringToByte(data));
            byte[] buffer = new byte[1024];
            while (((InputStream)is).available() != 0) {
                int len = is.read(buffer);
                sig.update(buffer, 0, len);
            }
            ((InputStream)is).close();
            return sig.verify(bSignature);
        }
        catch (Exception e) {
            throw new InvalidLicenseException(InvalidLicense.INVALID_LICENSE_KEY, (Throwable)e);
        }
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(rawPubKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
        return pubKey;
    }

    private boolean initializeFields(String encryptedData) throws InvalidLicenseException {
        String data = new String(this.hexStringToByte(encryptedData));
        String[] split = data.split(";");
        if (split.length != 6) {
            return false;
        }
        this.users = Integer.parseInt(split[3]);
        try {
            this.sku = SKU.byIndex(Integer.parseInt(split[4]));
        }
        catch (NumberFormatException localNumberFormatException) {
            return false;
        }
        this.version = split[2];
        String[] versionSplit = this.version.split("\\.");
        this.version = versionSplit[0];
        if ("10".equals(this.version) || !"0".equals(this.version) && !LicenseUtil.getProductVersionAsString().startsWith(this.version)) {
            throw new InvalidLicenseException(InvalidLicense.PERPETUAL_NOT_VALID_FOR_CURRENT_VERSION);
        }
        String d = split[1];
        if ("00/00/0000".equals(d)) {
            this.expired = null;
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            try {
                this.expired = simpleDateFormat.parse(d);
            }
            catch (ParseException localParseException) {
                return false;
            }
        }
        return true;
    }

    private byte[] hexStringToByte(String string) throws InvalidLicenseException {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException(INVALID_LICENSE);
        }
        byte[] result = new byte[string.length() / 2];
        int i = 0;
        while (i < string.length() / 2) {
            String n = string.substring(i * 2, i * 2 + 2);
            try {
                result[i] = (byte)Integer.parseInt(n, 16);
            }
            catch (NumberFormatException e) {
                throw new InvalidLicenseException(InvalidLicense.INVALID_LICENSE_KEY, (Throwable)e);
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        return this.key;
    }

    public boolean isPerpetual() {
        return this.expired == null;
    }
}

