#include "clar_libgit2.h"
#include "status_helpers.h"

void test_status_emptytreenode__cleanup(void)
{
	cl_git_sandbox_cleanup();
}

void test_status_emptytreenode__status(void)
{
	status_entry_counts counts;
	git_repository *repo = cl_git_sandbox_init("emptytreenode");

	memset(&counts, 0x0, sizeof(status_entry_counts));
	counts.expected_entry_count = 0;
	counts.expected_paths = 0;
	counts.expected_statuses = 0;

	cl_git_pass(
		git_status_foreach(repo, cb_status__normal, &counts)
	);

	cl_assert_equal_i(counts.expected_entry_count, counts.entry_count);
	cl_assert_equal_i(0, counts.wrong_status_flags_count);
	cl_assert_equal_i(0, counts.wrong_sorted_path);
	
}
