﻿Partial Public Class App
	Inherits Application

	Public Sub New()
		InitializeComponent()
	End Sub

	Private Sub Application_Startup(ByVal o As Object, ByVal e As StartupEventArgs) Handles Me.Startup
		Me.RootVisual = New MainPage()
	End Sub

	Private Sub Application_Exit(ByVal o As Object, ByVal e As EventArgs) Handles Me.Exit
	End Sub

	Private Sub Application_UnhandledException(ByVal sender As Object, ByVal e As ApplicationUnhandledExceptionEventArgs) Handles Me.UnhandledException
		' 如果正在调试程序外部运行应用程序，那么，请使用浏览器的异常机制
		' 报告异常。在 IE 上，将在状态栏中显示 
		' 黄色警报图标，Firefox 将显示脚本错误。
		If Not System.Diagnostics.Debugger.IsAttached Then

			' 注意: 在引发了异常但未对其进行处理之后，这将允许应用程序
			' 继续运行。 
			' 对于生产应用程序，应该不会对此错误进行处理，而是向网站报告此错误 
			' 并停止该应用程序。
			e.Handled = True
			Deployment.Current.Dispatcher.BeginInvoke(New Action(Of ApplicationUnhandledExceptionEventArgs)(AddressOf ReportErrorToDOM), e)
		End If
	End Sub

	Private Sub ReportErrorToDOM(ByVal e As ApplicationUnhandledExceptionEventArgs)
		Try
			Dim errorMsg As String = e.ExceptionObject.Message + e.ExceptionObject.StackTrace
			errorMsg = errorMsg.Replace(""""c, "'"c).Replace(ChrW(13) & ChrW(10), "\n")

			System.Windows.Browser.HtmlPage.Window.Eval("throw new Error(""Unhandled Error in Silverlight Application " + errorMsg + """);")
		Catch

		End Try
	End Sub
End Class