﻿Imports System
Imports System.ComponentModel

Public Class MainViewModel
	Implements INotifyPropertyChanged

	Public Sub New()
		' Insert code required on object creation below this point.
	End Sub

	Private viewModelPropertyValue As String = "Runtime Property Value"

	''' <summary>
	''' Sample ViewModel property; this property is used in the view to display its value using a Binding.
	''' </summary>
	Public Property ViewModelProperty() As String
		Get
			Return viewModelPropertyValue
		End Get
		Set(ByVal value As String)
			If viewModelPropertyValue <> value Then
				viewModelPropertyValue = value
				Me.NotifyPropertyChanged("ViewModelProperty")
			End If
		End Set
	End Property

	Public Sub ViewModelMethod()
		If Not Me.ViewModelProperty.EndsWith("Updated Value", StringComparison.Ordinal) Then
			Me.ViewModelProperty = Me.ViewModelProperty + " - Updated Value"
		End If
	End Sub

#Region "INotifyPropertyChanged"
	Private Sub NotifyPropertyChanged(ByVal info As String)
		RaiseEvent PropertyChanged(Me, New PropertyChangedEventArgs(info))
	End Sub

	Public Event PropertyChanged(ByVal sender As Object, ByVal e As System.ComponentModel.PropertyChangedEventArgs) Implements System.ComponentModel.INotifyPropertyChanged.PropertyChanged
#End Region
End Class