﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

//
// SketchFlow 需要知道哪个控件程序集包含其屏幕。这是在创建项目时
// 自动设置的，但是如果您手动更改控件程序集的名称，则也必须
// 在此处手动更新它。
//
[assembly: Microsoft.Expression.Prototyping.Services.SketchFlowLibraries("$safeassemblyname$.Screens")]

namespace $safeprojectname$
{
	public partial class App : Application
	{
		public App()
		{
			this.Startup += this.Application_Startup;
			this.Exit += this.Application_Exit;
			this.UnhandledException += this.Application_UnhandledException;

			InitializeComponent();
		}

		private void Application_Startup(object sender, StartupEventArgs e)
		{
			this.RootVisual = new Microsoft.Expression.Prototyping.Workspace.PlayerWindow();
		}

		private void Application_Exit(object sender, EventArgs e)
		{
		}

		private void Application_UnhandledException(object sender, ApplicationUnhandledExceptionEventArgs e)
		{
			// 如果正在调试程序外部运行应用程序，那么，请使用浏览器的异常机制
			// 报告异常。在 IE 上，将在状态栏中显示 
			// 黄色警报图标，Firefox 将显示脚本错误。
			if (!System.Diagnostics.Debugger.IsAttached)
			{

				// 注意: 在引发了异常但未对其进行处理之后，这将允许应用程序
				// 继续运行。 
				// 对于生产应用程序，应该不会对此错误进行处理，而是向网站报告此错误 
				// 并停止该应用程序。
				e.Handled = true;
				Deployment.Current.Dispatcher.BeginInvoke(delegate { ReportErrorToDOM(e); });
			}
		}

		private void ReportErrorToDOM(ApplicationUnhandledExceptionEventArgs e)
		{
			try
			{
				string errorMsg = e.ExceptionObject.Message + e.ExceptionObject.StackTrace;
				errorMsg = errorMsg.Replace('"', '\'').Replace("\r\n", @"\n");

				System.Windows.Browser.HtmlPage.Window.Eval("throw new Error(\"Unhandled Error in Silverlight Application " + errorMsg + "\");");
			}
			catch (Exception)
			{
			}
		}
	}
}