﻿
#include "Scribble.h"
#include "ScribbleView.h"
#include "ScribbleDoc.h"
#include "Stroke.h"

ScribbleView:: ScribbleView(ScribbleDoc ^ doc,MainWindow ^ parent)
{
	InitializeComponent();
	myDoc  = doc;
	MdiParent = parent;
	mainWin = parent;
	this->Text = String::Concat("ScribbleDoc",doc->docID.ToString(),":",doc->viewList->Count.ToString());				
}

ScribbleView::~ScribbleView(){}

void ScribbleView::InitializeComponent()
{
   components = gcnew System::ComponentModel::Container;
   AutoScaleBaseSize = System::Drawing::Size( 5, 13 );
   Text =  "ScribbleDoc";
   BackColor = Color::White;
   
   //AddOnMouseDown(new MouseEventHandler(this,&ScribbleView::MouseDownHandler)); 
   MouseDown += gcnew MouseEventHandler( this, &ScribbleView::MouseDownHandler );
   
   //AddOnMouseMove(new MouseEventHandler(this,&ScribbleView::MouseMoveHandler));  
   MouseMove += gcnew MouseEventHandler( this, &ScribbleView::MouseMoveHandler );
   
   //AddOnMouseUp(new MouseEventHandler(this,&ScribbleView::MouseUpHandler));  
   MouseUp += gcnew MouseEventHandler( this, &ScribbleView::MouseUpHandler );
   
   //AddOnPaint(new PaintEventHandler (this,&ScribbleView::PaintHandler));
   Paint += gcnew PaintEventHandler( this, &ScribbleView::PaintHandler );
   
   //AddOnClosing(new CancelEventHandler (this,&ScribbleView::CloseHandler));
   Closing += gcnew CancelEventHandler( this, &ScribbleView::ClosingHandler );
   Closed += gcnew EventHandler( this, &ScribbleView::ClosedHandler );
   
   //@design this.TrayLargeIcon = true;
   //@design this.TrayHeight = 0;
}

void ScribbleView::MouseDownHandler( Object^ /* sender */, MouseEventArgs^ e )
{
   if (  !this->Capture )
      return;

   try
   {
      Point ^ p = gcnew Point( e->X,e->Y );
      
      currentStroke = myDoc->NewStroke();
      currentStroke->pointArray->Add( p ); // 向新笔画中添加第一个点   
      previousPoint =  *p;
      this->Capture = true; // 捕获鼠标直到按钮弹起 
   }
   catch ( Exception^ ex ) 
   {
      MessageBox::Show( ex->ToString() );
   }

}

void ScribbleView::MouseMoveHandler( Object^ /* sender */, MouseEventArgs^ e )
{
   if (  !this->Capture )
      return;

   try
   {
      Point ^ p = gcnew Point( e->X,e->Y );
      
      currentStroke->pointArray->Add( p );
      Graphics^ g = CreateGraphics();
      g->DrawLine( myDoc->GetCurrentPen(), previousPoint,  *p );
      previousPoint =  *p;
   }
   catch ( Exception^ ex ) 
   {
      MessageBox::Show( ex->ToString() );
   }

}

void ScribbleView::MouseUpHandler( Object^ /* sender */, MouseEventArgs^ e )
{
   if (  !currentStroke )
      return;

   try
   {
      Point ^ p = gcnew Point( e->X,e->Y );

      currentStroke->pointArray->Add( p );
      Graphics^ g = CreateGraphics();
      g->DrawLine( myDoc->GetCurrentPen(), previousPoint,  *p );
      previousPoint =  *p;
      
      // 通知笔画项已完成向其添加点的操作。
      // 这样，它才能完成对其边框的计算。   
      currentStroke->FinishStroke();
      
      // 由于添加了笔画，因此将此事通知该文档的所有视图
      myDoc->UpdateAllViews( this, currentStroke );
      Capture = false;
   }
   catch ( Exception^ ex ) 
   {
      MessageBox::Show( ex->ToString() );
   }

}

void ScribbleView::PaintHandler( Object^ /* sender */, PaintEventArgs^ e )
{
   Rectangle rectClip = e->ClipRectangle;
   rectClip.Inflate( 1, 1 );
   Rectangle rectStroke;
   for ( int i = 0; i < myDoc->strokeList->Count; i++ )
   {
      Stroke ^ st = dynamic_cast<Stroke^>(myDoc->strokeList[ i ]);
      rectStroke = st->GetBoundingRectangle();
      rectStroke.Inflate( 1, 1 );
      if (  !rectStroke.IntersectsWith( rectClip ) )
            continue;
      st->DrawStroke( e->Graphics );

   }
}

void ScribbleView::ClosingHandler( Object^ /* sender */, CancelEventArgs^ e )
{
   if ( myDoc->isDirty && myDoc->viewList->Count == 1 )
   {
      int save = static_cast<int>(MessageBox::Show(  "Do you want to Save changes ?",  "Scribble", MessageBoxButtons::YesNoCancel ));
      if ( save == 6 )//TODO: Tarek : DialogResult::Yes )
      {
         SaveFileDialog^ saveDlg = gcnew SaveFileDialog;
         saveDlg->Filter =  "Scribble Files (*.scb)|*.scb|All Files (*.*)|*.*";
         saveDlg->DefaultExt =  ".scb";
         
         //saveDlg.FileName = "Scribb1.scb";
         int res = static_cast<int>(saveDlg->ShowDialog());
         if ( res == 1 )//TODO: Tarek: DialogResult::OK )
         {
            myDoc->SaveDocument( saveDlg->FileName );
            myDoc->viewList->Remove( this );
         }
         else
         if ( res == 2 )//TODO: Tarek: DialogResult::Cancel )
                  e->Cancel = true;
      }
      else
      if ( save == 2 )//TODO: Tarek: DialogResult::Cancel )
            e->Cancel = true;
      //如果用户选择了“取消”，则不关闭此窗体
      else
      
      //如果用户选择了“取消”，则不关闭此窗体
      if ( save == 7 )//TODO: Tarek: DialogResult::No )
            myDoc->viewList->Remove( this );
   }
   else
   {
      myDoc->viewList->Remove( this );
   }
}

void ScribbleView::ClosedHandler( Object^ /* sender */, EventArgs^ /* e */ )
{
   
   //如果不存在任何子视图，则禁用菜单项和工具栏项
   if ( mainWin->MdiChildren->Length == 0 )
      mainWin->DisableItems();
}

ScribbleDoc^ ScribbleView::GetDocument()
{
   return myDoc;
}

