﻿
#include "Scribble.h"
#include "ScribbleView.h"
#include "ScribbleDoc.h"
#include "Stroke.h"

ScribbleDoc:: ScribbleDoc(MainWindow^ mainWin)
{
    //
    // TODO: 在此处添加构造函数逻辑
    //				
		isDirty= false;
		thickPen=false;
		thinWidth=2;
		thickWidth=5;
		strokeList = gcnew ArrayList() ;
		viewList = gcnew ArrayList();
		ReplacePen();

		//将此 ID 设置为当前计数加 1。这样，此 ID 就从 1 开始
		docID = MainWindow::documentCount+1;
		//为此文档创建一个视图(窗体)
		ScribbleView^ view = gcnew ScribbleView(this,mainWin);
		viewList->Add(view);
		view->Show();
}

ScribbleDoc::~ScribbleDoc(){}

Stroke^ ScribbleDoc::NewStroke()
{
   Stroke ^ s = gcnew Stroke( penWidth );
   strokeList->Add( s );
   isDirty = true; //由于此文档已修改，因此设置已更新标志
   return s;
}

void ScribbleDoc::ReplacePen()
{
   penWidth = thickPen ? thickWidth : thinWidth;
   currentPen = gcnew Pen( Color::Black,(float)penWidth );
}

void ScribbleDoc::SaveDocument( String^ fileName )
{
   try
   {
      Stream^ s = File::Open( fileName, FileMode::Create );
      BinaryFormatter^ b = gcnew BinaryFormatter;
      b->Serialize( s, strokeList );
      s->Close();
      
      //由于此文档已保存，因此它不再是已更新状态
      isDirty = false;
   }
   catch ( Exception^ ex ) 
   {
      MessageBox::Show( ex->ToString() );
   }

}

void ScribbleDoc::OpenDocument( String^ fileName )
{
   try
   {
      Stream^ s = File::Open( fileName, FileMode::Open );
      BinaryFormatter^ b = gcnew BinaryFormatter;
      strokeList = dynamic_cast<ArrayList^>(b->Deserialize( s ));
      s->Close();
   }
   catch ( Exception^ ex ) 
   {
      MessageBox::Show( ex->ToString() );
   }

}

Pen^ ScribbleDoc::GetCurrentPen()
{
   return currentPen;
}


//用新数据更新此文档的所有视图
void ScribbleDoc::UpdateAllViews( ScribbleView ^ sender, Stroke ^ newStroke )
{
   ScribbleView ^ view;
   for ( int i = 0; i < viewList->Count; i++ )
   {
      view = dynamic_cast<ScribbleView^>(viewList[ i ]);
      if ( view->Equals( sender ) )
            continue;
      
      //如果这用于新的笔画
      if ( newStroke )
      {
         view->Invalidate( newStroke->GetBoundingRectangle() );
      }
      else
      {
         
         //必须为 ClearAll，以便使整个区域无效
         view->Invalidate();
      }
      view->Update();

   }
}


// 删除文档的内容
void ScribbleDoc::DeleteContents()
{
   strokeList->Clear();
   UpdateAllViews( nullptr, nullptr );
}

